/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.account.Account;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;

public class AccountListCellRenderer
extends TransparentPanel
implements ListCellRenderer {
    private static final Color rowColor = new Color(GuiActivator.getResources().getColor("service.gui.LIST_ROW"));
    private final JLabel accountLabel = new JLabel();
    private final JLabel statusLabel = new JLabel();
    private boolean isSelected = false;
    private Account account;
    private int index;
    private final GridBagConstraints constraints = new GridBagConstraints();

    public AccountListCellRenderer() {
        super((LayoutManager)new GridBagLayout());
        this.setPreferredSize(new Dimension(100, 38));
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.accountLabel.setAlignmentX(0.0f);
        this.accountLabel.setFont(this.accountLabel.getFont().deriveFont(1));
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 0.0;
        this.add(new JCheckBox(), this.constraints);
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.add(this.accountLabel, this.constraints);
        this.constraints.anchor = 13;
        this.constraints.fill = 0;
        this.constraints.gridx = 2;
        this.constraints.gridy = 0;
        this.constraints.weightx = 0.0;
        this.add(this.statusLabel, this.constraints);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String statusName;
        this.account = (Account)value;
        Icon accountIcon = this.account.getIcon();
        if (accountIcon != null) {
            this.accountLabel.setIcon(accountIcon);
        }
        this.accountLabel.setText(this.account.getName());
        Icon statusIcon = this.account.getStatusIcon();
        if (statusIcon != null) {
            this.statusLabel.setIcon(statusIcon);
        }
        if ((statusName = this.account.getStatusName()) != null) {
            this.statusLabel.setText(statusName);
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        if (!this.account.isEnabled()) {
            this.accountLabel.setForeground(Color.GRAY);
            this.statusLabel.setForeground(Color.GRAY);
        } else {
            this.accountLabel.setForeground(Color.BLACK);
            this.statusLabel.setForeground(Color.BLACK);
        }
        this.index = index;
        this.isSelected = isSelected;
        this.setBounds(0, 0, list.getWidth(), this.getPreferredSize().height);
        this.addCheckBox(this.account);
        return this;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        try {
            this.internalPaintComponent(g);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics g) {
        AntialiasingManager.activateAntialiasing((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.index % 2 > 0) {
            g2.setColor(rowColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.isSelected) {
            g2.setColor(Constants.SELECTED_COLOR);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void addCheckBox(Account account) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof JCheckBox)) continue;
            this.remove(c);
        }
        JCheckBox checkBox = account.getEnableCheckBox();
        if (checkBox == null) {
            checkBox = new SIPCommCheckBox();
            account.setEnableCheckBox(checkBox);
        }
        this.constraints.anchor = 17;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 0.0;
        this.add(checkBox, this.constraints);
        checkBox.setSelected(account.isEnabled());
    }

    public boolean isOverCheckBox(int x, int y) {
        JCheckBox checkBox = this.account.getEnableCheckBox();
        Point location = checkBox.getLocation();
        Dimension size = checkBox.getSize();
        return x >= location.x && x <= size.width && y >= location.y && y <= size.height;
    }
}

