/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.vbox7;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.httputil.HttpUtils;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;

public class ReplacementServiceVbox7Impl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceVbox7Impl.class);
    public static final String VBOX7_PATTERN = "(https?\\:\\/\\/(www\\.)*?vbox7\\.com\\/play\\:([a-zA-Z0-9_\\-]+))([?&]\\w+=[\\w-]*)*";
    public static final String VBOX7_CONFIG_LABEL = "Vbox7";
    public static final String SOURCE_NAME = "VBOX7";

    public ReplacementServiceVbox7Impl() {
        logger.trace((Object)"Creating a Vbox7 Source.");
    }

    public String getReplacement(String sourceString) {
        Pattern p = Pattern.compile("\\/play\\:([a-zA-Z0-9_\\-]+)([?&]\\w+=[\\w-]*)*", 34);
        Matcher m = p.matcher(sourceString);
        String thumbUrl = sourceString;
        String id = null;
        while (m.find()) {
            id = m.group(1);
            thumbUrl = "https://i.vbox7.com/p/" + id + "3.jpg";
        }
        if (id != null) {
            try {
                HttpUtils.HTTPResponseResult res = HttpUtils.openURLConnection((String)("http://vbox7.com/etc/ext.do?key=" + id));
                StringTokenizer toks = new StringTokenizer(res.getContentString(), "&");
                while (toks.hasMoreTokens()) {
                    String value = toks.nextToken();
                    String[] entries = value.split("=");
                    if (entries.length <= 1 || !entries[0].equals("jpg_addr")) continue;
                    return "http://" + entries[1];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return thumbUrl;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return VBOX7_PATTERN;
    }
}

