/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.mailcheck;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.mailcheck.MailCheckCmd;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class MailUpdate
extends MailCheckCmd {
    private static final int TYPE_UNREAD_MESSAGES = 128;
    private static final int TYPE_DOMAIN = 130;
    private static final int TYPE_URL = 7;
    private static final int TYPE_ALERT_TITLE = 5;
    private static final int TYPE_ALERT_URL = 13;
    private static final int TYPE_CHECK_TIME = 29;
    private ByteBlock block1;
    private ByteBlock block2;
    private int unreadCount;
    private String url;
    private String domain;
    private String alertTitle;
    private String alertUrl;
    private Date checkedAt;

    protected MailUpdate(SnacPacket packet) {
        super(7);
        ByteBlock data = packet.getData();
        this.block1 = data.subBlock(0, 8);
        this.block2 = data.subBlock(8, 16);
        int numtlvs = BinaryTools.getUShort(data, 24);
        ImmutableTlvChain chain = TlvTools.readChain(data.subBlock(26), numtlvs);
        this.unreadCount = chain.getUShort(128);
        this.url = chain.getString(7);
        this.domain = chain.getString(130);
        this.alertTitle = chain.getString(5);
        this.alertUrl = chain.getString(13);
        this.checkedAt = new Date(chain.getUInt(29));
    }

    public MailUpdate(ByteBlock block1, ByteBlock block2, int unreadCount, String url, String domain, String alertTitle, String alertUrl, Date checkedAt) {
        super(7);
        this.block1 = block1;
        this.block2 = block2;
        this.unreadCount = unreadCount;
        this.url = url;
        this.domain = domain;
        this.alertTitle = alertTitle;
        this.alertUrl = alertUrl;
        this.checkedAt = checkedAt;
    }

    public ByteBlock getBlock1() {
        return this.block1;
    }

    public ByteBlock getBlock2() {
        return this.block2;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAlertTitle() {
        return this.alertTitle;
    }

    public String getAlertUrl() {
        return this.alertUrl;
    }

    public Date getCheckedAt() {
        return this.checkedAt;
    }

    public void writeData(OutputStream out) throws IOException {
        this.block1.write(out);
        this.block2.write(out);
        MutableTlvChain chain = TlvTools.createMutableChain();
        if (this.unreadCount != -1) {
            chain.addTlv(Tlv.getUShortInstance(128, this.unreadCount));
        }
        if (this.url != null) {
            chain.addTlv(Tlv.getStringInstance(7, this.url));
        }
        if (this.domain != null) {
            chain.addTlv(Tlv.getStringInstance(130, this.domain));
        }
        if (this.alertTitle != null) {
            chain.addTlv(Tlv.getStringInstance(5, this.alertTitle));
        }
        if (this.alertUrl != null) {
            chain.addTlv(Tlv.getStringInstance(13, this.alertUrl));
        }
        if (this.checkedAt != null) {
            chain.addTlv(Tlv.getUIntInstance(29, this.checkedAt.getTime()));
        }
        BinaryTools.writeUShort(out, chain.getTlvCount());
        chain.write(out);
    }
}

