/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.SingleBuddyRequest;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class OldGetInfoCmd
extends LocCommand
implements SingleBuddyRequest {
    public static final int TYPE_INFO = 1;
    public static final int TYPE_AWAYMSG = 3;
    public static final int TYPE_CAPS = 4;
    private final String sn;
    private final int type;

    protected OldGetInfoCmd(SnacPacket packet) {
        super(5);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.type = BinaryTools.getUShort(snacData, 0);
        ByteBlock snBlock = snacData.subBlock(2);
        StringBlock snInfo = OscarTools.readScreenname(snBlock);
        this.sn = snInfo == null ? null : snInfo.getString();
    }

    public OldGetInfoCmd(int type, String sn) {
        super(5);
        DefensiveTools.checkRange(type, "type", 0);
        DefensiveTools.checkNull(sn, "sn");
        this.type = type;
        this.sn = sn;
    }

    public final int getRequestType() {
        return this.type;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.type);
        OscarTools.writeScreenname(out, this.sn);
    }

    public String toString() {
        return "OldGetInfoCmd for " + this.sn + ", type=" + this.type;
    }
}

