/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.sipaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.sipaccregwizz.Resources;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccRegWizzActivator;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccountRegistrationForm;
import net.java.sip.communicator.plugin.sipaccregwizz.ValidatingPanel;
import net.java.sip.communicator.service.certificate.CertificateConfigEntry;
import net.java.sip.communicator.service.protocol.sip.SipAccountID;
import org.jitsi.util.StringUtils;

public class ConnectionPanel
extends TransparentPanel
implements ItemListener,
DocumentListener,
ValidatingPanel {
    private static final long serialVersionUID = 0L;
    private final JTextField serverField = new JTextField();
    private final JTextField proxyField = new JTextField();
    private final JTextField authNameField = new JTextField();
    private final JTextField serverPortField = new JTextField(4);
    private final JTextField proxyPortField = new JTextField(4);
    private final JTextField voicemailAliasField = new JTextField(4);
    private final JTextField voicemailCheckField = new JTextField(4);
    private final JCheckBox proxyAutoCheckBox;
    private final JCheckBox proxyForceBypassCheckBox;
    private final JComboBox certificate = new JComboBox();
    private JComboBox transportCombo = new JComboBox<String>(new String[]{"UDP", "TCP", "TLS"});
    private JComboBox keepAliveMethodBox = new JComboBox<String>(new String[]{"NONE", "REGISTER", "OPTIONS", "CRLF"});
    private JTextField keepAliveIntervalValue = new JTextField(SipAccountID.getDefaultStr((String)"KEEP_ALIVE_INTERVAL"));
    private JComboBox dtmfMethodBox = new JComboBox<String>(new String[]{Resources.getString("plugin.sipaccregwizz.DTMF_AUTO"), Resources.getString("plugin.sipaccregwizz.DTMF_RTP"), Resources.getString("plugin.sipaccregwizz.DTMF_SIP_INFO"), Resources.getString("plugin.sipaccregwizz.DTMF_INBAND")});
    private JTextField dtmfMinimalToneDurationValue = new JTextField();
    private final JCheckBox mwiCheckBox;
    private boolean isServerOverridden = false;
    private SIPAccountRegistrationForm regform;

    public ConnectionPanel(SIPAccountRegistrationForm regform) {
        super((LayoutManager)new BorderLayout(10, 10));
        this.regform = regform;
        this.regform.addValidatingPanel(this);
        this.proxyAutoCheckBox = new SIPCommCheckBox(Resources.getString("plugin.sipaccregwizz.PROXY_AUTO"), regform.getRegistration().isProxyAutoConfigure());
        this.enablesProxyAutoConfigure(this.proxyAutoCheckBox.isSelected());
        this.proxyAutoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.this.enablesProxyAutoConfigure(ConnectionPanel.this.proxyAutoCheckBox.isSelected());
                ConnectionPanel.this.regform.reValidateInput();
            }
        });
        this.proxyForceBypassCheckBox = new SIPCommCheckBox(Resources.getString("plugin.sipaccregwizz.PROXY_FORCE_BYPASS"), regform.getRegistration().isProxyForceBypassConfigure());
        this.enablesProxyForceBypassConfigure(this.proxyForceBypassCheckBox.isSelected());
        this.proxyForceBypassCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.this.enablesProxyForceBypassConfigure(ConnectionPanel.this.proxyForceBypassCheckBox.isSelected());
                ConnectionPanel.this.regform.reValidateInput();
            }
        });
        this.transportCombo.addItemListener(this);
        this.transportCombo.setSelectedItem(regform.getRegistration().getPreferredTransport());
        TransparentPanel mainPanel = new TransparentPanel();
        mainPanel.setLayout(new BoxLayout((Container)mainPanel, 1));
        TransparentPanel registrarMainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        JLabel serverLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.REGISTRAR"));
        JLabel authNameLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.AUTH_NAME"));
        JLabel serverPortLabel = new JLabel(Resources.getString("service.gui.PORT"));
        JLabel certLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.CLIENT_CERTIFICATE"));
        labelsPanel.add(serverLabel);
        labelsPanel.add(authNameLabel);
        labelsPanel.add(certLabel);
        this.serverField.setText(regform.getRegistration().getServerAddress());
        this.serverPortField.setText(regform.getRegistration().getServerPort());
        TransparentPanel serverPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        serverPanel.add((Component)this.serverField, "Center");
        TransparentPanel serverPortPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        serverPortPanel.add((Component)serverPortLabel, "West");
        serverPortPanel.add((Component)this.serverPortField, "East");
        serverPanel.add((Component)serverPortPanel, "East");
        valuesPanel.add((Component)serverPanel);
        valuesPanel.add(this.authNameField);
        valuesPanel.add(this.certificate);
        this.initCertificateAliases(null);
        registrarMainPanel.add((Component)labelsPanel, "West");
        registrarMainPanel.add((Component)valuesPanel, "Center");
        registrarMainPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        mainPanel.add((Component)registrarMainPanel);
        this.proxyAutoCheckBox.setSelected(regform.getRegistration().isProxyAutoConfigure());
        this.proxyForceBypassCheckBox.setSelected(regform.getRegistration().isProxyForceBypassConfigure());
        if (!StringUtils.isNullOrEmpty((String)regform.getRegistration().getProxy())) {
            this.proxyField.setText(regform.getRegistration().getProxy());
        }
        if (!StringUtils.isNullOrEmpty((String)regform.getRegistration().getProxyPort())) {
            this.proxyPortField.setText(regform.getRegistration().getProxyPort());
        }
        JLabel proxyLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.PROXY"));
        JLabel proxyPortLabel = new JLabel(Resources.getString("service.gui.PORT"));
        JLabel transportLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.PREFERRED_TRANSPORT"));
        TransparentPanel proxyMainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        this.proxyField.getDocument().addDocumentListener(this);
        this.proxyPortField.getDocument().addDocumentListener(this);
        TransparentPanel proxyPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        proxyPanel.add((Component)this.proxyField, "Center");
        TransparentPanel proxyPortPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        proxyPortPanel.add((Component)proxyPortLabel, "West");
        proxyPortPanel.add((Component)this.proxyPortField, "East");
        proxyPanel.add((Component)proxyPortPanel, "East");
        TransparentPanel proxyNorthPanel = new TransparentPanel((LayoutManager)new GridLayout(2, 1, 10, 1));
        labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        labelsPanel.add(proxyLabel);
        labelsPanel.add(transportLabel);
        valuesPanel.add((Component)proxyPanel);
        valuesPanel.add(this.transportCombo);
        proxyNorthPanel.add(this.proxyForceBypassCheckBox);
        proxyNorthPanel.add(this.proxyAutoCheckBox);
        proxyMainPanel.add((Component)proxyNorthPanel, "North");
        proxyMainPanel.add((Component)labelsPanel, "West");
        proxyMainPanel.add((Component)valuesPanel, "Center");
        proxyMainPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.sipaccregwizz.PROXY_OPTIONS")));
        mainPanel.add((Component)proxyMainPanel);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(this.createKeepAlivePanel());
        TransparentPanel encryptionPanel = new TransparentPanel((LayoutManager)new GridLayout(1, 2, 2, 2));
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add((Component)encryptionPanel);
        TransparentPanel voicemailPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        TransparentPanel voicemailUriPanelLabels = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        TransparentPanel voicemailUriPanelValues = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        this.mwiCheckBox = new SIPCommCheckBox(Resources.getString("plugin.sipaccregwizz.MWI"), regform.getRegistration().isMessageWaitingIndicationsEnabled());
        voicemailUriPanelLabels.add(new JLabel(Resources.getString("plugin.sipaccregwizz.VOICEMAIL_URI")));
        voicemailUriPanelLabels.add(new JLabel(Resources.getString("plugin.sipaccregwizz.VOICEMAIL_CHECK_URI")));
        voicemailUriPanelValues.add(this.voicemailAliasField);
        voicemailUriPanelValues.add(this.voicemailCheckField);
        voicemailPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.sipaccregwizz.VOICEMAIL")));
        this.voicemailAliasField.setText(regform.getRegistration().getVoicemailURI());
        this.voicemailCheckField.setText(regform.getRegistration().getVoicemailCheckURI());
        voicemailPanel.add((Component)this.mwiCheckBox, "North");
        voicemailPanel.add((Component)voicemailUriPanelLabels, "West");
        voicemailPanel.add((Component)voicemailUriPanelValues, "Center");
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add((Component)voicemailPanel);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(this.createDTMFPanel());
        this.add((Component)mainPanel, "North");
    }

    private void initCertificateAliases(String id) {
        this.certificate.removeAllItems();
        this.certificate.insertItemAt(Resources.getString("plugin.sipaccregwizz.NO_CERTIFICATE"), 0);
        this.certificate.setSelectedIndex(0);
        for (CertificateConfigEntry e : SIPAccRegWizzActivator.getCertificateService().getClientAuthCertificateConfigs()) {
            this.certificate.addItem(e);
            if (!e.getId().equals(id)) continue;
            this.certificate.setSelectedItem(e);
        }
    }

    public void setServerFieldAccordingToUIN(String serverAddress) {
        if (!this.regform.isModification() || !this.isServerOverridden) {
            this.serverField.setText(serverAddress);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    private Component createKeepAlivePanel() {
        TransparentPanel emptyLabelPanel = new TransparentPanel();
        emptyLabelPanel.setMaximumSize(new Dimension(40, 35));
        TransparentPanel keepAlivePanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        TransparentPanel keepAliveLabels = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        TransparentPanel keepAliveValues = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        JLabel keepAliveMethodLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.KEEP_ALIVE_METHOD"));
        JLabel keepAliveIntervalLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.KEEP_ALIVE_INTERVAL"));
        JLabel keepAliveIntervalExampleLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.KEEP_ALIVE_INTERVAL_INFO"));
        keepAliveLabels.add(keepAliveMethodLabel);
        keepAliveLabels.add(keepAliveIntervalLabel);
        keepAliveLabels.add((Component)emptyLabelPanel);
        keepAliveIntervalExampleLabel.setForeground(Color.GRAY);
        keepAliveIntervalExampleLabel.setFont(keepAliveIntervalExampleLabel.getFont().deriveFont(8));
        keepAliveIntervalExampleLabel.setMaximumSize(new Dimension(40, 35));
        keepAliveIntervalExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.keepAliveMethodBox.setSelectedItem(SipAccountID.getDefaultStr((String)"KEEP_ALIVE_METHOD"));
        keepAliveValues.add(this.keepAliveMethodBox);
        keepAliveValues.add(this.keepAliveIntervalValue);
        keepAliveValues.add(keepAliveIntervalExampleLabel);
        keepAlivePanel.add((Component)keepAliveLabels, "West");
        keepAlivePanel.add((Component)keepAliveValues, "Center");
        keepAlivePanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.sipaccregwizz.KEEP_ALIVE")));
        return keepAlivePanel;
    }

    private Component createDTMFPanel() {
        TransparentPanel emptyLabelPanel = new TransparentPanel();
        TransparentPanel dtmfLabels = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        JLabel dtmfMethodLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.DTMF_METHOD"));
        JLabel minimalDTMFToneDurationLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.DTMF_MINIMAL_TONE_DURATION"));
        dtmfLabels.add(dtmfMethodLabel);
        dtmfLabels.add(minimalDTMFToneDurationLabel);
        dtmfLabels.add((Component)emptyLabelPanel);
        TransparentPanel dtmfValues = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        this.dtmfMethodBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isEnabled = false;
                String selectedItem = (String)ConnectionPanel.this.dtmfMethodBox.getSelectedItem();
                if (selectedItem != null && (selectedItem.equals(Resources.getString("plugin.sipaccregwizz.DTMF_AUTO")) || selectedItem.equals(Resources.getString("plugin.sipaccregwizz.DTMF_RTP")))) {
                    isEnabled = true;
                }
                ConnectionPanel.this.dtmfMinimalToneDurationValue.setEnabled(isEnabled);
            }
        });
        this.dtmfMethodBox.setSelectedItem(this.regform.getRegistration().getDTMFMethod());
        this.dtmfMinimalToneDurationValue.setText(this.regform.getRegistration().getDtmfMinimalToneDuration());
        JLabel dtmfMinimalToneDurationExampleLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.DTMF_MINIMAL_TONE_DURATION_INFO"));
        dtmfMinimalToneDurationExampleLabel.setForeground(Color.GRAY);
        dtmfMinimalToneDurationExampleLabel.setFont(dtmfMinimalToneDurationExampleLabel.getFont().deriveFont(8));
        dtmfMinimalToneDurationExampleLabel.setMaximumSize(new Dimension(40, 35));
        dtmfMinimalToneDurationExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        dtmfValues.add(this.dtmfMethodBox);
        dtmfValues.add(this.dtmfMinimalToneDurationValue);
        dtmfValues.add(dtmfMinimalToneDurationExampleLabel);
        TransparentPanel dtmfPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        dtmfPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.sipaccregwizz.DTMF")));
        dtmfPanel.add((Component)dtmfLabels, "West");
        dtmfPanel.add((Component)dtmfValues, "Center");
        return dtmfPanel;
    }

    String getServerAddress() {
        return this.serverField.getText();
    }

    void setServerAddress(String serverAddress) {
        this.serverField.setText(serverAddress);
    }

    void setServerEnabled(boolean isEnabled) {
        this.serverField.setEnabled(isEnabled);
    }

    String getAuthenticationName() {
        return this.authNameField.getText();
    }

    void setAuthenticationName(String authName) {
        this.authNameField.setText(authName);
    }

    String getServerPort() {
        return this.serverPortField.getText();
    }

    void setServerPort(String serverPort) {
        this.serverPortField.setText(serverPort);
    }

    String getProxy() {
        return this.proxyField.getText();
    }

    void setProxy(String proxyAddress) {
        this.proxyField.setText(proxyAddress);
    }

    String getProxyPort() {
        return this.proxyPortField.getText();
    }

    void setProxyPort(String proxyPort) {
        this.proxyPortField.setText(proxyPort);
    }

    String getSelectedTransport() {
        Object selectedItem = this.transportCombo.getSelectedItem();
        if (selectedItem == null) {
            selectedItem = this.transportCombo.getItemAt(0);
        }
        return selectedItem.toString();
    }

    void setSelectedTransport(String preferredTransport) {
        this.transportCombo.setSelectedItem(preferredTransport);
    }

    String getCertificateId() {
        Object selectedItem = this.certificate.getSelectedItem();
        if (selectedItem != null && selectedItem instanceof CertificateConfigEntry) {
            return ((CertificateConfigEntry)selectedItem).getId();
        }
        return null;
    }

    void setCertificateId(String id) {
        this.initCertificateAliases(id);
    }

    String getKeepAliveMethod() {
        Object selItem = this.keepAliveMethodBox.getSelectedItem();
        if (selItem != null) {
            return selItem.toString();
        }
        return null;
    }

    void setKeepAliveMethod(String keepAliveMethod) {
        this.keepAliveMethodBox.setSelectedItem(keepAliveMethod);
    }

    String getKeepAliveInterval() {
        return this.keepAliveIntervalValue.getText();
    }

    String getDTMFMethod() {
        Object selItem = this.dtmfMethodBox.getSelectedItem();
        if (selItem == null) {
            return null;
        }
        String selString = selItem.toString();
        if (selString.equals(Resources.getString("plugin.sipaccregwizz.DTMF_RTP"))) {
            return "RTP_DTMF";
        }
        if (selString.equals(Resources.getString("plugin.sipaccregwizz.DTMF_SIP_INFO"))) {
            return "SIP_INFO_DTMF";
        }
        if (selString.equals(Resources.getString("plugin.sipaccregwizz.DTMF_INBAND"))) {
            return "INBAND_DTMF";
        }
        return "AUTO_DTMF";
    }

    void setDTMFMethod(String dtmfMethod) {
        if (dtmfMethod == null) {
            this.dtmfMethodBox.setSelectedItem(0);
        } else {
            String selString = dtmfMethod.equals("RTP_DTMF") ? Resources.getString("plugin.sipaccregwizz.DTMF_RTP") : (dtmfMethod.equals("SIP_INFO_DTMF") ? Resources.getString("plugin.sipaccregwizz.DTMF_SIP_INFO") : (dtmfMethod.equals("INBAND_DTMF") ? Resources.getString("plugin.sipaccregwizz.DTMF_INBAND") : Resources.getString("plugin.sipaccregwizz.DTMF_AUTO")));
            this.dtmfMethodBox.setSelectedItem(selString);
        }
    }

    String getDtmfMinimalToneDuration() {
        return this.dtmfMinimalToneDurationValue.getText();
    }

    void setKeepAliveInterval(String keepAliveInterval) {
        this.keepAliveIntervalValue.setText(keepAliveInterval);
    }

    String getVoicemailURI() {
        return this.voicemailAliasField.getText();
    }

    void setVoicemailURI(String voicemailURI) {
        this.voicemailAliasField.setText(voicemailURI);
    }

    String getVoicemailCheckURI() {
        return this.voicemailCheckField.getText();
    }

    void setVoicemailCheckURI(String voicemailCheckURI) {
        this.voicemailCheckField.setText(voicemailCheckURI);
    }

    boolean isMessageWaitingEnabled() {
        return this.mwiCheckBox.isSelected();
    }

    void setMessageWaitingIndications(boolean enabled) {
        this.mwiCheckBox.setSelected(enabled);
    }

    void setDtmfMinimalToneDuration(String dtmfMinimalToneDuration) {
        this.dtmfMinimalToneDurationValue.setText(dtmfMinimalToneDuration);
    }

    void setServerOverridden(boolean isServerOverridden) {
        this.isServerOverridden = isServerOverridden;
    }

    boolean isProxyAutoConfigureEnabled() {
        return this.proxyAutoCheckBox.isSelected();
    }

    void enablesProxyAutoConfigure(boolean isEnable) {
        this.proxyAutoCheckBox.setSelected(isEnable);
        this.proxyField.setEnabled(!isEnable);
        this.proxyPortField.setEnabled(!isEnable);
        this.transportCombo.setEnabled(!isEnable);
        this.regform.reValidateInput();
    }

    boolean isProxyForceBypassConfigureEnabled() {
        return this.proxyForceBypassCheckBox.isSelected();
    }

    void enablesProxyForceBypassConfigure(boolean isEnable) {
        this.proxyForceBypassCheckBox.setSelected(isEnable);
        this.regform.reValidateInput();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.regform.reValidateInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.regform.reValidateInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public boolean isValidated() {
        if (!this.proxyAutoCheckBox.isSelected()) {
            return this.proxyField.getText() != null && this.proxyField.getText().length() > 0 && this.proxyPortField.getText() != null && this.proxyPortField.getText().length() > 0;
        }
        return true;
    }
}

