/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.util.Arrays;
import java.util.List;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;

public class TransformEngineChain
implements TransformEngine {
    protected TransformEngine[] engineChain;
    private List<TransformEngine> engineChainAsList;
    private PacketTransformerChain rtcpTransformChain;
    private PacketTransformerChain rtpTransformChain;

    public TransformEngineChain(TransformEngine[] engineChain) {
        this.setEngineChain((TransformEngine[])engineChain.clone());
    }

    protected TransformEngineChain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEngine(TransformEngine engine) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        TransformEngineChain transformEngineChain = this;
        synchronized (transformEngineChain) {
            TransformEngine[] oldValue;
            for (TransformEngine e : oldValue = this.engineChain) {
                if (!engine.equals(e)) continue;
                return false;
            }
            this.addEngine(engine, oldValue.length);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEngine(TransformEngine engine, TransformEngine after) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        TransformEngineChain transformEngineChain = this;
        synchronized (transformEngineChain) {
            TransformEngine[] oldValue;
            for (TransformEngine e : oldValue = this.engineChain) {
                if (!engine.equals(e)) continue;
                return false;
            }
            int position = -1;
            if (after == null) {
                position = 0;
            }
            for (int i = 0; i < oldValue.length; ++i) {
                if (oldValue[i] != after) continue;
                position = i + 1;
                break;
            }
            if (position == -1) {
                return false;
            }
            this.addEngine(engine, position);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngine(TransformEngine engine, int position) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        TransformEngineChain transformEngineChain = this;
        synchronized (transformEngineChain) {
            TransformEngine[] oldValue = this.engineChain;
            if (position < 0 || position > oldValue.length) {
                throw new IllegalArgumentException("position=" + position + "; len=" + oldValue.length);
            }
            TransformEngine[] newValue = new TransformEngine[oldValue.length + 1];
            System.arraycopy(oldValue, 0, newValue, 0, position);
            System.arraycopy(oldValue, position, newValue, position + 1, oldValue.length - position);
            newValue[position] = engine;
            this.setEngineChain(newValue);
        }
    }

    public TransformEngine[] getEngineChain() {
        return (TransformEngine[])this.engineChain.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketTransformer getRTCPTransformer() {
        TransformEngine[] transformEngineArray = this;
        synchronized (this) {
            boolean invokeOnEngineChain;
            if (this.rtcpTransformChain == null) {
                this.rtcpTransformChain = (TransformEngineChain)this.new PacketTransformerChain(false);
                invokeOnEngineChain = true;
            } else {
                invokeOnEngineChain = false;
            }
            PacketTransformerChain rtpTransformer = this.rtcpTransformChain;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (invokeOnEngineChain) {
                for (TransformEngine engine : this.engineChain) {
                    engine.getRTCPTransformer();
                }
            }
            return rtpTransformer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketTransformer getRTPTransformer() {
        TransformEngine[] transformEngineArray = this;
        synchronized (this) {
            boolean invokeOnEngineChain;
            if (this.rtpTransformChain == null) {
                this.rtpTransformChain = (TransformEngineChain)this.new PacketTransformerChain(true);
                invokeOnEngineChain = true;
            } else {
                invokeOnEngineChain = false;
            }
            PacketTransformerChain rtpTransformer = this.rtpTransformChain;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (invokeOnEngineChain) {
                for (TransformEngine engine : this.engineChain) {
                    engine.getRTPTransformer();
                }
            }
            return rtpTransformer;
        }
    }

    private void setEngineChain(TransformEngine[] engineChain) {
        this.engineChain = engineChain;
        this.engineChainAsList = Arrays.asList(engineChain);
    }

    public class PacketTransformerChain
    implements PacketTransformer {
        private final boolean rtp;

        public PacketTransformerChain(boolean rtp) {
            this.rtp = rtp;
        }

        @Override
        public void close() {
            for (TransformEngine engine : TransformEngineChain.this.engineChain) {
                PacketTransformer pTransformer;
                PacketTransformer packetTransformer = pTransformer = this.rtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (pTransformer == null) continue;
                pTransformer.close();
            }
        }

        @Override
        public RawPacket[] reverseTransform(RawPacket[] pkts) {
            TransformEngine[] engineChain = TransformEngineChain.this.engineChain;
            for (int i = engineChain.length - 1; i >= 0; --i) {
                PacketTransformer pTransformer;
                TransformEngine engine = engineChain[i];
                PacketTransformer packetTransformer = pTransformer = this.rtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (pTransformer == null) continue;
                pkts = pTransformer.reverseTransform(pkts);
            }
            return pkts;
        }

        @Override
        public RawPacket[] transform(RawPacket[] pkts) {
            return this.transform(pkts, null);
        }

        public RawPacket[] transform(RawPacket[] pkts, TransformEngine after) {
            boolean lookForAfter = after != null && TransformEngineChain.this.engineChainAsList.contains(after);
            for (TransformEngine engine : TransformEngineChain.this.engineChain) {
                PacketTransformer transformer;
                if (lookForAfter) {
                    if (!engine.equals(after)) continue;
                    lookForAfter = false;
                    continue;
                }
                PacketTransformer packetTransformer = transformer = this.rtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (transformer == null) continue;
                pkts = transformer.transform(pkts);
            }
            return pkts;
        }
    }
}

