/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.sendsidebandwidthestimation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPReport;
import org.jitsi.impl.neomedia.rtp.sendsidebandwidthestimation.SendSideBandwidthEstimation;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.rtp.BandwidthEstimator;
import org.jitsi.service.neomedia.rtp.RTCPReportAdapter;
import org.jitsi.service.neomedia.stats.MediaStreamStats2;
import org.jitsi.util.concurrent.RecurringRunnable;

public class BandwidthEstimatorImpl
extends RTCPReportAdapter
implements BandwidthEstimator,
RecurringRunnable {
    private static final int PROCESS_INTERVAL_MS = 25;
    private static final int MIN_BITRATE_BPS = 30000;
    private static final int MAX_BITRATE_BPS = 20000000;
    private static final int START_BITRATE_BPS = 300000;
    private Map<Long, Long> ssrc_to_last_received_extended_high_seq_num_ = new ConcurrentHashMap<Long, Long>();
    private long lastUpdateTime = -1L;
    private final SendSideBandwidthEstimation sendSideBandwidthEstimation;

    public BandwidthEstimatorImpl(MediaStream stream) {
        this.sendSideBandwidthEstimation = new SendSideBandwidthEstimation(stream, 300000L);
        this.sendSideBandwidthEstimation.setMinMaxBitrate(30000, 20000000);
        MediaStreamStats2 stats = stream.getMediaStreamStats();
        stats.addRTCPPacketListener(this.sendSideBandwidthEstimation);
        stats.getRTCPReports().addRTCPReportListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rtcpReportReceived(RTCPReport report) {
        if (report == null || report.getFeedbackReports() == null || report.getFeedbackReports().isEmpty()) {
            return;
        }
        long total_number_of_packets = 0L;
        long fraction_lost_aggregate = 0L;
        for (RTCPFeedback feedback : report.getFeedbackReports()) {
            long ssrc = feedback.getSSRC();
            long extSeqNum = feedback.getXtndSeqNum();
            Long lastEHSN = this.ssrc_to_last_received_extended_high_seq_num_.get(ssrc);
            if (lastEHSN == null) {
                lastEHSN = extSeqNum;
            }
            this.ssrc_to_last_received_extended_high_seq_num_.put(ssrc, extSeqNum);
            if (lastEHSN >= extSeqNum) continue;
            long number_of_packets = extSeqNum - lastEHSN;
            fraction_lost_aggregate += number_of_packets * (long)feedback.getFractionLost();
            total_number_of_packets += number_of_packets;
        }
        fraction_lost_aggregate = total_number_of_packets == 0L ? 0L : (fraction_lost_aggregate + total_number_of_packets / 2L) / total_number_of_packets;
        if (fraction_lost_aggregate > 255L) {
            return;
        }
        SendSideBandwidthEstimation sendSideBandwidthEstimation = this.sendSideBandwidthEstimation;
        synchronized (sendSideBandwidthEstimation) {
            this.lastUpdateTime = System.currentTimeMillis();
            this.sendSideBandwidthEstimation.updateReceiverBlock(fraction_lost_aggregate, total_number_of_packets, this.lastUpdateTime);
        }
    }

    @Override
    public void addListener(BandwidthEstimator.Listener listener) {
        this.sendSideBandwidthEstimation.addListener(listener);
    }

    @Override
    public void removeListener(BandwidthEstimator.Listener listener) {
        this.sendSideBandwidthEstimation.removeListener(listener);
    }

    @Override
    public long getTimeUntilNextRun() {
        return this.lastUpdateTime < 0L ? 0L : this.lastUpdateTime + 25L - System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SendSideBandwidthEstimation sendSideBandwidthEstimation = this.sendSideBandwidthEstimation;
        synchronized (sendSideBandwidthEstimation) {
            this.lastUpdateTime = System.currentTimeMillis();
            this.sendSideBandwidthEstimation.updateEstimate(this.lastUpdateTime);
        }
    }

    @Override
    public long getLatestEstimate() {
        return this.sendSideBandwidthEstimation.getLatestEstimate();
    }

    @Override
    public long getLatestREMB() {
        return this.sendSideBandwidthEstimation.getLatestREMB();
    }

    @Override
    public int getLatestFractionLoss() {
        return this.sendSideBandwidthEstimation.getLatestFractionLoss();
    }
}

