/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.contactlist;

import java.util.Hashtable;
import junit.framework.TestSuite;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockPersistentPresenceOperationSet;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.impl.protocol.mock.MockStatusEnum;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.contactlist.MclSlickFixture;
import net.java.sip.communicator.slick.contactlist.TestMetaContact;
import net.java.sip.communicator.slick.contactlist.TestMetaContactGroup;
import net.java.sip.communicator.slick.contactlist.TestMetaContactList;
import net.java.sip.communicator.slick.contactlist.TestMetaContactListPersistence;
import net.java.sip.communicator.slick.contactlist.TestSupportForMultipleProviders;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MetaContactListServiceLick
extends TestSuite
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(MetaContactListServiceLick.class);
    static final String topLevelGroupName = "SomePeople";
    static MockContactGroup topLevelMockGroup = null;
    static final String subLevelContactName = "Spencer";
    static MockContact subLevelContact = null;
    static MockContactGroup subLevelGroup = null;
    static MockContact subsubContact = null;
    static MockContact mockContactToRename = null;
    static MockContact mockContactToReorder = null;

    public void start(BundleContext context) {
        MclSlickFixture.bundleContext = context;
        this.setName("MetaContactListServiceLick");
        Hashtable<String, String> slickServiceProperties = new Hashtable<String, String>();
        slickServiceProperties.put("service.pid", this.getName());
        logger.debug((Object)("Service  " + ((Object)((Object)this)).getClass().getName() + " [  STARTED ]"));
        MockProvider provider = new MockProvider("SlickMockUser");
        this.fillMockContactList(provider);
        MclSlickFixture.mockPrServiceRegistration = MetaContactListServiceLick.registerMockProviderService(provider);
        MclSlickFixture.mockProvider = provider;
        MclSlickFixture.mockPresOpSet = (MockPersistentPresenceOperationSet)MclSlickFixture.mockProvider.getOperationSet(OperationSetPersistentPresence.class);
        this.addTestSuite(TestMetaContactList.class);
        this.addTestSuite(TestMetaContact.class);
        this.addTestSuite(TestMetaContactGroup.class);
        this.addTest(TestSupportForMultipleProviders.suite());
        this.addTest(TestMetaContactListPersistence.suite());
        context.registerService(((Object)((Object)this)).getClass().getName(), (Object)this, slickServiceProperties);
        logger.debug((Object)("Service  " + ((Object)((Object)this)).getClass().getName() + " [REGISTERED]"));
    }

    public void stop(BundleContext context) {
        ServiceReference ref;
        if (MclSlickFixture.mockPrServiceRegistration != null) {
            MclSlickFixture.mockPrServiceRegistration.unregister();
        }
        if (MclSlickFixture.mockP1ServiceRegistration != null) {
            MclSlickFixture.mockP1ServiceRegistration.unregister();
        }
        if (MclSlickFixture.mockP2ServiceRegistration != null) {
            MclSlickFixture.mockP2ServiceRegistration.unregister();
        }
        if ((ref = context.getServiceReference(MetaContactListService.class.getName())) == null) {
            return;
        }
        MetaContactListService metaClService = (MetaContactListService)context.getService(ref);
        if (metaClService != null) {
            metaClService.purgeLocallyStoredContactListCopy();
        }
    }

    public static ServiceRegistration registerMockProviderService(MockProvider provider) {
        System.setProperty("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        Hashtable<String, String> mockProvProperties = new Hashtable<String, String>();
        mockProvProperties.put("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        ServiceRegistration osgiRegistration = MclSlickFixture.bundleContext.registerService(ProtocolProviderService.class.getName(), (Object)provider, mockProvProperties);
        logger.debug((Object)"Registered a mock protocol provider!");
        return osgiRegistration;
    }

    private void fillMockContactList(MockProvider provider) {
        MockPersistentPresenceOperationSet mockOpSet = (MockPersistentPresenceOperationSet)provider.getOperationSet(OperationSetPersistentPresence.class);
        MockContactGroup root = (MockContactGroup)mockOpSet.getServerStoredContactListRoot();
        root.addContact(new MockContact("Ivan Ivanov", provider));
        root.addContact(new MockContact("Martin Dupont", provider));
        root.addContact(new MockContact("Joe Bloggs", provider));
        MockContact someOfflineContact = new MockContact("I am offline", provider);
        someOfflineContact.setPresenceStatus(MockStatusEnum.MOCK_STATUS_00);
        root.addContact(someOfflineContact);
        mockContactToRename = new MockContact("Jane Doe", provider);
        root.addContact(mockContactToRename);
        mockContactToReorder = new MockContact("ZI'llChangeMyStatus", provider);
        mockContactToReorder.setPresenceStatus(MockStatusEnum.MOCK_STATUS_00);
        root.addContact(mockContactToReorder);
        topLevelMockGroup = new MockContactGroup(topLevelGroupName, provider);
        subLevelContact = new MockContact(subLevelContactName, provider);
        topLevelMockGroup.addContact(subLevelContact);
        topLevelMockGroup.addContact(new MockContact("Pencho", provider));
        topLevelMockGroup.addContact(new MockContact("Toto", provider));
        subLevelGroup = new MockContactGroup("SubSubGroup", provider);
        subsubContact = new MockContact("SContact1", provider);
        subLevelGroup.addContact(subsubContact);
        subLevelGroup.addContact(new MockContact("SContact2", provider));
        subLevelGroup.addContact(new MockContact("SContact3", provider));
        subLevelGroup.addContact(new MockContact("SContact4", provider));
        topLevelMockGroup.addSubgroup(subLevelGroup);
        root.addSubgroup(topLevelMockGroup);
    }
}

