/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig.autoaway;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.java.sip.communicator.plugin.generalconfig.GeneralConfigPluginActivator;
import net.java.sip.communicator.plugin.generalconfig.autoaway.Preferences;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class StatusUpdateThread
implements Runnable {
    private static final int AWAY_DEFAULT_STATUS = 40;
    private static final int IDLE_TIMER = 3000;
    private Point lastPosition = null;
    private final Map<ProtocolProviderService, PresenceStatus> lastStates = new HashMap<ProtocolProviderService, PresenceStatus>();
    private boolean run = false;

    static PresenceStatus findAwayStatus(OperationSetPresence presence) {
        Iterator statusSet = presence.getSupportedStatusSet();
        PresenceStatus status = null;
        while (statusSet.hasNext()) {
            PresenceStatus possibleState = (PresenceStatus)statusSet.next();
            int possibleStatus = possibleState.getStatus();
            if (possibleStatus >= 50 || possibleStatus < 20 || status != null && Math.abs(possibleStatus - 40) >= Math.abs(status.getStatus() - 40)) continue;
            status = possibleState;
        }
        return status;
    }

    private static boolean isNear(Point p1, Point p2) {
        return p1 != null && p2 != null && Math.abs(p1.x - p2.x) <= 10 && Math.abs(p1.y - p2.y) <= 10;
    }

    public boolean isRunning() {
        return this.run;
    }

    @Override
    public void run() {
        this.run = true;
        int timer = 0;
        do {
            try {
                if (MouseInfo.getPointerInfo() != null) {
                    Point currentPosition;
                    PointerInfo info = MouseInfo.getPointerInfo();
                    Point point = currentPosition = info != null ? info.getLocation() : new Point(0, 0);
                    if (!StatusUpdateThread.isNear(this.lastPosition, currentPosition)) {
                        for (ProtocolProviderService protocolProvider : GeneralConfigPluginActivator.getProtocolProviders()) {
                            if (this.lastStates.get(protocolProvider) == null) continue;
                            PresenceStatus lastState = this.lastStates.get(protocolProvider);
                            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
                            try {
                                presence.publishPresenceStatus(lastState, "");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (IllegalStateException illegalStateException) {
                            }
                            catch (OperationFailedException operationFailedException) {
                                // empty catch block
                            }
                            this.lastStates.remove(protocolProvider);
                        }
                        timer = Preferences.getTimer() * 1000 * 60;
                    } else {
                        for (ProtocolProviderService protocolProvider : GeneralConfigPluginActivator.getProtocolProviders()) {
                            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
                            PresenceStatus status = presence.getPresenceStatus();
                            if (status.getStatus() < 50) continue;
                            this.lastStates.put(protocolProvider, status);
                            PresenceStatus newStatus = StatusUpdateThread.findAwayStatus(presence);
                            try {
                                if (newStatus == null) continue;
                                presence.publishPresenceStatus(newStatus, newStatus.getStatusName());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (IllegalStateException illegalStateException) {
                            }
                            catch (OperationFailedException operationFailedException) {
                                // empty catch block
                            }
                        }
                        timer = 3000;
                    }
                    this.lastPosition = currentPosition;
                }
                Thread.sleep(timer);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.run && timer > 0);
    }

    public void stop() {
        this.run = false;
    }
}

