/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.generalconfig.OpusConfigForm;
import net.java.sip.communicator.plugin.generalconfig.SIPConfigForm;
import net.java.sip.communicator.plugin.generalconfig.SilkConfigForm;
import net.java.sip.communicator.plugin.generalconfig.XMPPConfigForm;
import net.java.sip.communicator.plugin.generalconfig.autoaway.AutoAwayWatcher;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.service.systray.SystrayService;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class GeneralConfigPluginActivator
extends AbstractServiceDependentActivator
implements ServiceListener {
    private static final Logger logger = Logger.getLogger(GeneralConfigPluginActivator.class);
    private static ConfigurationService configService;
    private static SystrayService systrayService;
    public static BundleContext bundleContext;
    private static UIService uiService;
    private static AutoAwayWatcher runner;
    private static boolean startThreadIsCalled;
    private static ResourceManagementService resourceService;
    private static MessageHistoryService messageHistoryService;
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.DISABLED";
    private static final String SIP_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.sipconfig.DISABLED";
    private static final String XMPP_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.xmppconfig.DISABLED";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(Object dependentService) {
        uiService = (UIService)dependentService;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(DISABLED_PROP, false)) {
            ConfigurationUtils.loadGuiConfigurations();
            ((Dictionary)properties).put("FORM_TYPE", "GENERAL_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm("net.java.sip.communicator.plugin.generalconfig.GeneralConfigurationPanel", ((Object)((Object)this)).getClass().getClassLoader(), "plugin.generalconfig.PLUGIN_ICON", "service.gui.GENERAL", 0), properties);
        }
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(SIP_CONFIG_DISABLED_PROP, false)) {
            ((Dictionary)properties).put("FORM_TYPE", "ADVANCED_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(SIPConfigForm.class.getName(), ((Object)((Object)this)).getClass().getClassLoader(), null, "plugin.generalconfig.SIP_CALL_CONFIG", 52, true), properties);
        }
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(XMPP_CONFIG_DISABLED_PROP, false)) {
            ((Dictionary)properties).put("FORM_TYPE", "ADVANCED_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(XMPPConfigForm.class.getName(), ((Object)((Object)this)).getClass().getClassLoader(), null, "plugin.generalconfig.XMPP_CONFIG", 52, true), properties);
        }
        ((Dictionary)properties).put("FORM_TYPE", "ADVANCED_TYPE");
        bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(SilkConfigForm.class.getName(), ((Object)((Object)this)).getClass().getClassLoader(), null, "plugin.generalconfig.SILK_CONFIG", 0, true), properties);
        bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(OpusConfigForm.class.getName(), ((Object)((Object)this)).getClass().getClassLoader(), null, "plugin.generalconfig.OPUS_CONFIG", 0, true), properties);
        try {
            ServiceReference[] protocolRefs = bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
            if (protocolRefs != null && protocolRefs.length > 0) {
                Class<GeneralConfigPluginActivator> clazz = GeneralConfigPluginActivator.class;
                synchronized (GeneralConfigPluginActivator.class) {
                    if (!startThreadIsCalled) {
                        GeneralConfigPluginActivator.startThread();
                        startThreadIsCalled = true;
                    }
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                }
            } else {
                bundleContext.addServiceListener((ServiceListener)this);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error starting auto away thread", t);
        }
        {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"PREFERENCES PLUGIN... [REGISTERED]");
            }
            return;
        }
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public void stop(BundleContext bc) throws Exception {
        GeneralConfigPluginActivator.stopThread();
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            ServiceReference configReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configService = (ConfigurationService)bundleContext.getService(configReference);
        }
        return configService;
    }

    static SystrayService getSystrayService() {
        if (systrayService == null) {
            ServiceReference configReference = bundleContext.getServiceReference(SystrayService.class.getName());
            systrayService = (SystrayService)bundleContext.getService(configReference);
        }
        return systrayService;
    }

    static UIService getUIService() {
        return uiService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serviceChanged(ServiceEvent serviceEvent) {
        switch (serviceEvent.getType()) {
            case 1: 
            case 2: {
                Object service = bundleContext.getService(serviceEvent.getServiceReference());
                if (!(service instanceof ProtocolProviderService)) return;
                Class<GeneralConfigPluginActivator> clazz = GeneralConfigPluginActivator.class;
                synchronized (GeneralConfigPluginActivator.class) {
                    if (!startThreadIsCalled) {
                        GeneralConfigPluginActivator.startThread();
                        startThreadIsCalled = true;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    bundleContext.removeServiceListener((ServiceListener)this);
                    return;
                }
            }
        }
    }

    private static void startThread() {
        if (runner == null) {
            runner = new AutoAwayWatcher();
        }
    }

    private static void stopThread() {
        if (runner != null) {
            runner.stop();
            runner = null;
        }
    }

    public static ProtocolProviderService[] getProtocolProviders() {
        BundleContext bundleContext = GeneralConfigPluginActivator.bundleContext;
        ServiceReference[] serRefs = null;
        try {
            serRefs = bundleContext.getAllServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)ex);
        }
        if (serRefs == null || serRefs[0] == null) {
            return new ProtocolProviderService[0];
        }
        HashSet<ProtocolProviderService> pps = new HashSet<ProtocolProviderService>();
        for (ServiceReference serviceReference : serRefs) {
            ProtocolProviderService protocolProvider = (ProtocolProviderService)bundleContext.getService(serviceReference);
            pps.add(protocolProvider);
        }
        return pps.toArray(new ProtocolProviderService[0]);
    }

    public static ResourceManagementService getResources() {
        if (resourceService == null) {
            resourceService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourceService;
    }

    public static MessageHistoryService getMessageHistoryService() {
        if (messageHistoryService == null) {
            messageHistoryService = (MessageHistoryService)ServiceUtils.getService((BundleContext)bundleContext, MessageHistoryService.class);
        }
        return messageHistoryService;
    }

    public static JPanel createConfigSectionComponent(String labelText) {
        JLabel label = new JLabel(labelText);
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        label.setFont(label.getFont().deriveFont(1));
        TransparentPanel pnlSectionName = new TransparentPanel();
        pnlSectionName.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 21;
        c.gridwidth = 2;
        pnlSectionName.add((Component)label, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 2;
        pnlSectionName.add((Component)new JSeparator(), c);
        TransparentPanel pnlSection = new TransparentPanel(){
            private static final long serialVersionUID = 0L;

            public Component add(Component comp) {
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setAlignmentX(0.0f);
                }
                return super.add(comp);
            }
        };
        pnlSection.setLayout(new BoxLayout((Container)pnlSection, 1));
        pnlSection.add((Component)pnlSectionName);
        return pnlSection;
    }

    static {
        runner = null;
        startThreadIsCalled = false;
    }
}

