/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.secureim;

import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collection;
import java.util.Iterator;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.OscarTools;
import net.kano.joustsim.oscar.oscar.NoBuddyKeysException;
import net.kano.joustsim.oscar.oscar.service.icbm.EmptyMessageException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.DecryptedMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.InvalidSignatureException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.MultipleSignersException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.NoLocalKeysException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.SecureAimCodec;
import net.kano.joustsim.trust.CertificatePairHolder;
import net.kano.joustsim.trust.KeyPair;
import net.kano.joustsim.trust.PrivateKeys;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class SecureAimDecoder
extends SecureAimCodec {
    public synchronized DecryptedMessageInfo decryptMessage(ByteBlock encryptedData) throws CMSException, NoSuchProviderException, NoSuchAlgorithmException, InvalidSignatureException, NoBuddyKeysException, NoLocalKeysException, EmptyMessageException {
        boolean verified;
        CertificatePairHolder buddyCerts = this.getBuddyCerts();
        if (buddyCerts == null) {
            throw new NoBuddyKeysException();
        }
        X509Certificate signingCert = buddyCerts.getSigningCertificate();
        if (signingCert == null) {
            throw new NoBuddyKeysException();
        }
        PrivateKeys localKeys = this.getLocalKeys();
        if (localKeys == null) {
            throw new NoLocalKeysException();
        }
        KeyPair signingKeys = localKeys.getSigningKeys();
        if (signingKeys == null) {
            throw new NoLocalKeysException();
        }
        RSAPrivateKey signingKey = signingKeys.getPrivateKey();
        if (signingKey == null) {
            throw new NoLocalKeysException();
        }
        InputStream encin = ByteBlock.createInputStream(encryptedData);
        CMSEnvelopedData ced = new CMSEnvelopedData(encin);
        Collection recip = ced.getRecipientInfos().getRecipients();
        if (recip.isEmpty()) {
            throw new EmptyMessageException();
        }
        KeyTransRecipientInformation rinfo = (KeyTransRecipientInformation)recip.iterator().next();
        byte[] content = rinfo.getContent((Key)signingKey, "BC");
        OscarTools.HttpHeaderInfo hdrInfo = OscarTools.parseHttpHeader(ByteBlock.wrap(content));
        InputStream in = ByteBlock.createInputStream(hdrInfo.getData());
        CMSSignedData csd = new CMSSignedData(in);
        SignerInformationStore signerInfos = csd.getSignerInfos();
        Collection signers = signerInfos.getSigners();
        Iterator sit = signers.iterator();
        if (!sit.hasNext()) {
            throw new InvalidSignatureException(null);
        }
        SignerInformation si = (SignerInformation)sit.next();
        if (sit.hasNext()) {
            throw new MultipleSignersException();
        }
        try {
            verified = si.verify(signingCert, "BC");
        }
        catch (CertificateExpiredException e) {
            throw new InvalidSignatureException(e, si);
        }
        catch (CertificateNotYetValidException e) {
            throw new InvalidSignatureException(e, si);
        }
        if (!verified) {
            throw new InvalidSignatureException(si);
        }
        CMSProcessable signedContent = csd.getSignedContent();
        Object signedContentData = signedContent.getContent();
        if (!(signedContentData instanceof byte[])) {
            throw new EmptyMessageException();
        }
        ByteBlock data = ByteBlock.wrap((byte[])signedContentData);
        OscarTools.HttpHeaderInfo bodyInfo = OscarTools.parseHttpHeader(data);
        String msg = OscarTools.getInfoString(bodyInfo.getData(), bodyInfo.getHeaders().get("content-type"));
        if (msg == null) {
            throw new EmptyMessageException();
        }
        return new DecryptedMessageInfo(msg, buddyCerts);
    }
}

