/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class ServiceRedirect
extends ConnCommand {
    private static final int TYPE_FAMILY = 13;
    private static final int TYPE_HOST = 5;
    private static final int TYPE_COOKIE = 6;
    private final int family;
    private final String host;
    private final int port;
    private final ByteBlock cookie;

    protected ServiceRedirect(SnacPacket packet) {
        super(5);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(snacData);
        this.family = chain.getUShort(13);
        String hostString = chain.getString(5);
        if (hostString != null) {
            int colonPos = hostString.indexOf(58);
            if (colonPos != -1) {
                this.host = hostString.substring(0, colonPos);
                int portTmp = -1;
                String portString = hostString.substring(colonPos + 1);
                try {
                    portTmp = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.port = portTmp;
            } else {
                this.host = hostString;
                this.port = -1;
            }
        } else {
            this.host = null;
            this.port = -1;
        }
        this.cookie = chain.getLastTlv(6).getData();
    }

    public ServiceRedirect(int family, String host, ByteBlock cookie) {
        this(family, host, -1, cookie);
    }

    public ServiceRedirect(int family, String host, int port, ByteBlock cookie) {
        super(5);
        DefensiveTools.checkRange(family, "family", 0);
        this.family = family;
        this.host = host;
        this.port = port;
        this.cookie = cookie;
    }

    public final int getSnacFamily() {
        return this.family;
    }

    public final String getRedirectHost() {
        return this.host;
    }

    public int getRedirectPort() {
        return this.port;
    }

    public final ByteBlock getCookie() {
        return this.cookie;
    }

    public void writeData(OutputStream out) throws IOException {
        Tlv.getUShortInstance(13, this.family).write(out);
        if (this.host != null) {
            StringBuffer hostString = new StringBuffer();
            hostString.append(this.host);
            if (this.port != -1) {
                hostString.append(':');
                hostString.append(this.port);
            }
            Tlv.getStringInstance(5, hostString.toString()).write(out);
        }
        if (this.cookie != null) {
            new Tlv(6, this.cookie).write(out);
        }
    }

    public String toString() {
        return "ServiceRedirect: family=0x" + Integer.toHexString(this.family) + ", host=" + this.host + ", port=" + this.port + ", cookie=" + this.cookie.getLength() + " bytes";
    }
}

