/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.Hashtable;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderFactoryIcqImpl;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class IcqActivator
implements BundleActivator {
    private ServiceRegistration icqPpFactoryServReg = null;
    private ServiceRegistration aimPpFactoryServReg = null;
    static BundleContext bundleContext = null;
    private static ConfigurationService configurationService = null;
    private static ProtocolProviderFactoryIcqImpl icqProviderFactory = null;
    private static ProtocolProviderFactoryIcqImpl aimProviderFactory = null;
    private static ResourceManagementService resourceService;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        Hashtable<String, String> icqHashtable = new Hashtable<String, String>();
        icqHashtable.put("PROTOCOL_NAME", "ICQ");
        Hashtable<String, String> aimHashtable = new Hashtable<String, String>();
        aimHashtable.put("PROTOCOL_NAME", "AIM");
        icqProviderFactory = new ProtocolProviderFactoryIcqImpl(false);
        aimProviderFactory = new ProtocolProviderFactoryIcqImpl(true);
        this.icqPpFactoryServReg = context.registerService(ProtocolProviderFactory.class.getName(), (Object)icqProviderFactory, icqHashtable);
        this.aimPpFactoryServReg = context.registerService(ProtocolProviderFactory.class.getName(), (Object)aimProviderFactory, aimHashtable);
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configurationService = (ConfigurationService)bundleContext.getService(confReference);
        }
        return configurationService;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    static ProtocolProviderFactoryIcqImpl getIcqProtocolProviderFactory() {
        return icqProviderFactory;
    }

    static ProtocolProviderFactoryIcqImpl getAimProtocolProviderFactory() {
        return aimProviderFactory;
    }

    public void stop(BundleContext context) throws Exception {
        icqProviderFactory.stop();
        this.icqPpFactoryServReg.unregister();
        this.aimPpFactoryServReg.unregister();
    }

    public static ResourceManagementService getResources() {
        if (resourceService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(ResourceManagementService.class.getName());
            if (serviceReference == null) {
                return null;
            }
            resourceService = (ResourceManagementService)bundleContext.getService(serviceReference);
        }
        return resourceService;
    }
}

