/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.icq.ContactIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.MessageIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetAdHocMultiUserChatIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetPersistentPresenceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomParticipantPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomParticipantPresenceListener;
import net.java.sip.communicator.util.Logger;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatInvitation;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatMessage;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomManager;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomSession;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomSessionListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomUser;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatSessionState;

public class AdHocChatRoomIcqImpl
implements AdHocChatRoom {
    private static final Logger logger = Logger.getLogger(AdHocChatRoomIcqImpl.class);
    private Vector<AdHocChatRoomParticipantPresenceListener> memberListeners = new Vector();
    private Vector<AdHocChatRoomMessageListener> messageListeners = new Vector();
    private ChatInvitation chatInvitation = null;
    private ChatRoomSession chatRoomSession = null;
    private Hashtable<String, Contact> participants = new Hashtable();
    private OperationSetAdHocMultiUserChatIcqImpl opSetMuc = null;
    private ProtocolProviderServiceIcqImpl provider = null;
    private Hashtable<String, String> inviteUserList = new Hashtable();
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String defaultHtmlStartTag = "<HTML>";
    private static final String defaultHtmlEndTag = "</HTML>";
    private String chatRoomName = "";
    private String nickName = "";
    private String chatSubject = "";

    public AdHocChatRoomIcqImpl(ChatInvitation chatInvitation, ProtocolProviderServiceIcqImpl icqProvider) {
        this.chatRoomName = chatInvitation.getRoomName();
        this.chatInvitation = chatInvitation;
        this.provider = icqProvider;
        this.opSetMuc = (OperationSetAdHocMultiUserChatIcqImpl)this.provider.getOperationSet(OperationSetAdHocMultiUserChat.class);
    }

    public AdHocChatRoomIcqImpl(String roomName, ChatRoomSession chatRoomSession, ProtocolProviderServiceIcqImpl icqProvider) {
        this.chatRoomSession = chatRoomSession;
        this.chatRoomName = roomName;
        this.provider = icqProvider;
        this.opSetMuc = (OperationSetAdHocMultiUserChatIcqImpl)this.provider.getOperationSet(OperationSetAdHocMultiUserChat.class);
        this.chatRoomSession.addListener(new AdHocChatRoomSessionListenerImpl(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipantPresenceListener(AdHocChatRoomParticipantPresenceListener listener) {
        Vector<AdHocChatRoomParticipantPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            if (!this.memberListeners.contains(listener)) {
                this.memberListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(AdHocChatRoomMessageListener listener) {
        Vector<AdHocChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            if (!this.messageListeners.contains(listener)) {
                this.messageListeners.add(listener);
            }
        }
    }

    public Message createMessage(byte[] content, String contentType, String contentEncoding, String subject) {
        return new MessageIcqImpl(new String(content), contentType, contentEncoding, subject);
    }

    public Message createMessage(String messageText) {
        MessageIcqImpl msg = new MessageIcqImpl(messageText, "text/plain", "UTF-8", null);
        return msg;
    }

    public String getIdentifier() {
        return this.chatRoomName;
    }

    public List<Contact> getParticipants() {
        return new LinkedList<Contact>(this.participants.values());
    }

    public int getParticipantsCount() {
        return this.participants.size();
    }

    public String getName() {
        return this.chatRoomName;
    }

    public ProtocolProviderService getParentProvider() {
        return this.provider;
    }

    public String getSubject() {
        return this.chatSubject;
    }

    public String getUserNickname() {
        if (this.nickName == null) {
            this.nickName = this.provider.getInfoRetreiver().getNickName(this.provider.getAccountID().getUserID());
        }
        return this.nickName;
    }

    public void invite(String userAddress, String reason) {
        this.assertConnected();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Inviting " + userAddress + " for reason: " + reason));
        }
        if (this.chatRoomSession.getState().equals((Object)ChatSessionState.INROOM)) {
            this.chatRoomSession.invite(new Screenname(userAddress), reason);
        } else {
            this.inviteUserList.put(userAddress, reason);
        }
    }

    public void join() throws OperationFailedException {
        if (this.chatRoomSession == null && this.chatInvitation == null) {
            ChatRoomManager chatRoomManager = this.provider.getAimConnection().getChatRoomManager();
            this.chatRoomSession = chatRoomManager.joinRoom(this.getName());
            this.chatRoomSession.addListener(new AdHocChatRoomSessionListenerImpl(this));
        } else if (this.chatInvitation != null) {
            this.chatRoomSession = this.chatInvitation.accept();
            this.chatRoomSession.addListener(new AdHocChatRoomSessionListenerImpl(this));
        }
        this.opSetMuc.fireLocalUserPresenceEvent(this, "LocalUserJoined", null);
    }

    public void leave() {
        if (this.chatRoomSession != null) {
            this.chatRoomSession.close();
            this.chatRoomSession = null;
        }
        for (Map.Entry<String, Contact> memberEntry : this.participants.entrySet()) {
            Contact participant = memberEntry.getValue();
            this.fireParticipantPresenceEvent(participant, "ContactLeft", "Local user has left the chat room.");
        }
        this.participants.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipantPresenceListener(AdHocChatRoomParticipantPresenceListener listener) {
        Vector<AdHocChatRoomParticipantPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            this.memberListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(AdHocChatRoomMessageListener listener) {
        Vector<AdHocChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            this.messageListeners.remove(listener);
        }
    }

    public void sendMessage(Message message) throws OperationFailedException {
        this.assertConnected();
        try {
            this.chatRoomSession.sendMessage(message.getContent());
            AdHocChatRoomMessageDeliveredEvent msgDeliveredEvt = new AdHocChatRoomMessageDeliveredEvent((AdHocChatRoom)this, new Date(), message, 1);
            this.fireMessageEvent((EventObject)msgDeliveredEvt);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send a conference message.");
            }
            throw new OperationFailedException("Failed to send a conference message.", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessageEvent(EventObject evt) {
        Iterator<AdHocChatRoomMessageListener> listeners = null;
        Vector<AdHocChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            listeners = new ArrayList<AdHocChatRoomMessageListener>(this.messageListeners).iterator();
        }
        while (listeners.hasNext()) {
            AdHocChatRoomMessageListener listener = listeners.next();
            if (evt instanceof AdHocChatRoomMessageDeliveredEvent) {
                listener.messageDelivered((AdHocChatRoomMessageDeliveredEvent)evt);
                continue;
            }
            if (evt instanceof AdHocChatRoomMessageReceivedEvent) {
                listener.messageReceived((AdHocChatRoomMessageReceivedEvent)evt);
                continue;
            }
            if (!(evt instanceof AdHocChatRoomMessageDeliveryFailedEvent)) continue;
            listener.messageDeliveryFailed((AdHocChatRoomMessageDeliveryFailedEvent)evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireParticipantPresenceEvent(Contact member, String eventID, String eventReason) {
        AdHocChatRoomParticipantPresenceChangeEvent evt = new AdHocChatRoomParticipantPresenceChangeEvent((AdHocChatRoom)this, member, eventID, eventReason);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Iterator<AdHocChatRoomParticipantPresenceListener> listeners = null;
        Vector<AdHocChatRoomParticipantPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            listeners = new ArrayList<AdHocChatRoomParticipantPresenceListener>(this.memberListeners).iterator();
        }
        while (listeners.hasNext()) {
            AdHocChatRoomParticipantPresenceListener listener = listeners.next();
            listener.participantPresenceChanged(evt);
        }
    }

    private void updateMemberList(Set<ChatRoomUser> chatRoomUserSet, boolean removeMember) {
        for (ChatRoomUser user : chatRoomUserSet) {
            String uid = user.getScreenname().getFormatted();
            if (!(removeMember || this.participants.containsKey(uid) || uid.equals(this.provider.getAccountID().getUserID()))) {
                OperationSetPersistentPresenceIcqImpl presenceOpSet = (OperationSetPersistentPresenceIcqImpl)this.getParentProvider().getOperationSet(OperationSetPersistentPresence.class);
                ContactIcqImpl participant = presenceOpSet.getServerStoredContactList().findContactByScreenName(uid);
                this.participants.put(uid, (Contact)participant);
                this.fireParticipantPresenceEvent((Contact)participant, "ContactJoined", null);
            }
            if (!removeMember || !this.participants.containsKey(uid)) continue;
            Contact participant = this.participants.get(uid);
            this.participants.remove(uid);
            this.fireParticipantPresenceEvent(participant, "ContactLeft", null);
        }
    }

    private void assertConnected() throws IllegalStateException {
        if (this.provider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to communicate.");
        }
        if (!this.provider.isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
    }

    public Contact findParticipantForNickName(String nickName) {
        return this.participants.get(nickName);
    }

    private class AdHocChatRoomSessionListenerImpl
    implements ChatRoomSessionListener {
        private AdHocChatRoomIcqImpl chatRoom = null;

        public AdHocChatRoomSessionListenerImpl(AdHocChatRoomIcqImpl room) {
            this.chatRoom = room;
        }

        @Override
        public void handleIncomingMessage(ChatRoomSession chatRoomSession, ChatRoomUser chatRoomUser, ChatMessage chatMessage) {
            String msgBody;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Incoming multi user chat message received: " + chatMessage.getMessage()));
            }
            String msgContent = (msgBody = chatMessage.getMessage()).startsWith(AdHocChatRoomIcqImpl.defaultHtmlStartTag) ? msgBody.substring(msgBody.indexOf(AdHocChatRoomIcqImpl.defaultHtmlStartTag) + AdHocChatRoomIcqImpl.defaultHtmlStartTag.length(), msgBody.indexOf(AdHocChatRoomIcqImpl.defaultHtmlEndTag)) : msgBody;
            Message newMessage = AdHocChatRoomIcqImpl.this.createMessage(msgContent.getBytes(), AdHocChatRoomIcqImpl.HTML_MIME_TYPE, "UTF-8", null);
            String participantUID = chatRoomUser.getScreenname().getFormatted();
            if (participantUID.equals(AdHocChatRoomIcqImpl.this.nickName)) {
                return;
            }
            AdHocChatRoomMessageReceivedEvent msgReceivedEvent = new AdHocChatRoomMessageReceivedEvent((AdHocChatRoom)this.chatRoom, (Contact)AdHocChatRoomIcqImpl.this.participants.get(participantUID), new Date(), newMessage, 1);
            AdHocChatRoomIcqImpl.this.fireMessageEvent((EventObject)msgReceivedEvent);
        }

        @Override
        public void handleStateChange(ChatRoomSession chatRoomSession, ChatSessionState oldChatSessionState, ChatSessionState newChatSessionState) {
            block7: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ChatRoomSessionState changed to: " + (Object)((Object)newChatSessionState)));
                }
                if (AdHocChatRoomIcqImpl.this.chatInvitation == null && newChatSessionState.equals((Object)ChatSessionState.INROOM)) {
                    try {
                        this.chatRoom.join();
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug((Object)("Failed to join the chat room: " + e));
                    }
                }
            }
            if (AdHocChatRoomIcqImpl.this.inviteUserList != null && newChatSessionState.equals((Object)ChatSessionState.INROOM)) {
                for (Map.Entry entry : AdHocChatRoomIcqImpl.this.inviteUserList.entrySet()) {
                    this.chatRoom.invite((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (newChatSessionState.equals((Object)ChatSessionState.CLOSED) || newChatSessionState.equals((Object)ChatSessionState.FAILED)) {
                AdHocChatRoomIcqImpl.this.updateMemberList(chatRoomSession.getUsers(), true);
            }
        }

        @Override
        public void handleUsersJoined(ChatRoomSession chatRoomSession, Set<ChatRoomUser> chatRoomUserSet) {
            AdHocChatRoomIcqImpl.this.updateMemberList(chatRoomUserSet, false);
        }

        @Override
        public void handleUsersLeft(ChatRoomSession chatRoomSession, Set<ChatRoomUser> chatRoomUserSet) {
            AdHocChatRoomIcqImpl.this.updateMemberList(chatRoomUserSet, true);
        }
    }
}

