/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.nimbuzzavatars;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import net.java.sip.communicator.service.customavatar.CustomAvatarService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class NimbuzzAvatarsActivator
implements BundleActivator,
CustomAvatarService {
    static BundleContext bundleContext;
    private static final String AVATAR_DOWNLOAD_LINK = "http://avatar.nimbuzz.com/getAvatar?jid=";
    private static final String SERVICE_NAME = "nimbuzz.com";

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        bc.registerService(CustomAvatarService.class.getName(), (Object)this, null);
    }

    public void stop(BundleContext bc) throws Exception {
    }

    public byte[] getAvatar(String address) {
        if (address == null || !address.endsWith(SERVICE_NAME)) {
            return null;
        }
        try {
            int read;
            URL sourceURL = new URL(AVATAR_DOWNLOAD_LINK + address);
            URLConnection conn = sourceURL.openConnection();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = conn.getInputStream();
            byte[] b = new byte[1024];
            while ((read = in.read(b)) != -1) {
                out.write(b, 0, read);
            }
            in.close();
            return out.toByteArray();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

