/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;

public class Mode
implements Command {
    private static final int END_OF_MODE_COMMAND_PREFIX = 6;
    private IrcConnection connection;

    public Mode(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.connection = connection;
    }

    public void execute(String source, String line) {
        if (line.length() <= 6) {
            throw new IllegalArgumentException("Mode parameters are missing.");
        }
        String rawModeString = line.substring(6);
        if (rawModeString.trim().isEmpty()) {
            throw new IllegalArgumentException("The mode command needs mode parameters to function.");
        }
        this.connection.getClient().changeMode(source + " " + rawModeString);
    }

    public String help() {
        return "Usage: /mode <mode> [params ...]";
    }
}

