/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class SRTPCipherF8 {
    private static final int BLKLEN = 16;
    private byte[] encKey;
    private byte[] maskedKey;
    private BlockCipher cipher;

    public SRTPCipherF8(BlockCipher cipher) {
        this.cipher = cipher;
    }

    public void init(byte[] k_e, byte[] k_s) {
        int i;
        if (k_e.length != 16) {
            throw new IllegalArgumentException("k_e.length != BLKLEN");
        }
        if (k_s.length > k_e.length) {
            throw new IllegalArgumentException("k_s.length > k_e.length");
        }
        this.encKey = Arrays.copyOf(k_e, k_e.length);
        this.maskedKey = Arrays.copyOf(k_e, k_e.length);
        for (i = 0; i < k_s.length; ++i) {
            int n = i;
            this.maskedKey[n] = (byte)(this.maskedKey[n] ^ k_s[i]);
        }
        while (i < this.maskedKey.length) {
            int n = i++;
            this.maskedKey[n] = (byte)(this.maskedKey[n] ^ 0x55);
        }
    }

    public void process(byte[] data, int off, int len, byte[] iv) {
        if (iv.length != 16) {
            throw new IllegalArgumentException("iv.length != BLKLEN");
        }
        if (off < 0) {
            throw new IllegalArgumentException("off < 0");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (off + len > data.length) {
            throw new IllegalArgumentException("off + len > data.length");
        }
        F8Context f8ctx = new F8Context();
        f8ctx.ivAccent = new byte[16];
        this.cipher.init(true, (CipherParameters)new KeyParameter(this.maskedKey));
        this.cipher.processBlock(iv, 0, f8ctx.ivAccent, 0);
        this.cipher.init(true, (CipherParameters)new KeyParameter(this.encKey));
        f8ctx.J = 0L;
        f8ctx.S = new byte[16];
        Arrays.fill(f8ctx.S, (byte)0);
        int inLen = len;
        while (inLen >= 16) {
            this.processBlock(f8ctx, data, off, 16);
            inLen -= 16;
            off += 16;
        }
        if (inLen > 0) {
            this.processBlock(f8ctx, data, off, inLen);
        }
    }

    private void processBlock(F8Context f8ctx, byte[] inOut, int off, int len) {
        int i;
        for (i = 0; i < 16; ++i) {
            int n = i;
            f8ctx.S[n] = (byte)(f8ctx.S[n] ^ f8ctx.ivAccent[i]);
        }
        f8ctx.S[12] = (byte)((long)f8ctx.S[12] ^ f8ctx.J >> 24);
        f8ctx.S[13] = (byte)((long)f8ctx.S[13] ^ f8ctx.J >> 16);
        f8ctx.S[14] = (byte)((long)f8ctx.S[14] ^ f8ctx.J >> 8);
        f8ctx.S[15] = (byte)((long)f8ctx.S[15] ^ f8ctx.J);
        ++f8ctx.J;
        this.cipher.processBlock(f8ctx.S, 0, f8ctx.S, 0);
        for (i = 0; i < len; ++i) {
            int n = off + i;
            inOut[n] = (byte)(inOut[n] ^ f8ctx.S[i]);
        }
    }

    static class F8Context {
        public byte[] S;
        public byte[] ivAccent;
        long J;

        F8Context() {
        }
    }
}

