/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jitsi.service.neomedia.AbstractActiveSpeakerDetector;
import org.jitsi.util.ExecutorUtils;
import org.jitsi.util.Logger;
import org.json.simple.JSONObject;

public class DominantSpeakerIdentification
extends AbstractActiveSpeakerDetector {
    private static final double C1 = 3.0;
    private static final double C2 = 2.0;
    private static final double C3 = 0.0;
    private static final boolean DEBUG;
    private static final long DECISION_INTERVAL = 300L;
    private static final long DECISION_MAKER_IDLE_TIMEOUT = 15000L;
    public static final String DOMINANT_SPEAKER_PROPERTY_NAME;
    private static final long LEVEL_IDLE_TIMEOUT = 40L;
    private static final Logger logger;
    private static final int LONG_COUNT = 1;
    private static final int LONG_THRESHOLD = 4;
    private static final int MAX_LEVEL = 127;
    private static final int MIN_LEVEL = 0;
    private static final int MIN_LEVEL_WINDOW_LENGTH = 750;
    private static final double MIN_SPEECH_ACTIVITY_SCORE = 1.0E-10;
    private static final int MEDIUM_THRESHOLD = 7;
    private static final int N1 = 13;
    private static final int N1_SUBUNIT_LENGTH = 10;
    private static final int N2 = 5;
    private static final int N3 = 10;
    private static final long SPEAKER_IDLE_TIMEOUT = 3600000L;
    private static final ExecutorService threadPool;
    private DecisionMaker decisionMaker;
    private Long dominantSSRC;
    private long lastDecisionTime;
    private long lastLevelChangedTime;
    private long lastLevelIdleTime;
    private final PropertyChangeNotifier propertyChangeNotifier = new PropertyChangeNotifier();
    private final double[] relativeSpeechActivities = new double[3];
    private final Map<Long, Speaker> speakers = new HashMap<Long, Speaker>();

    private static long binomialCoefficient(int n, int r) {
        int m = n - r;
        if (r < m) {
            r = m;
        }
        long t = 1L;
        int i = n;
        int j = 1;
        while (i > r) {
            t = t * (long)i / (long)j;
            --i;
            ++j;
        }
        return t;
    }

    private static boolean computeBigs(byte[] littles, byte[] bigs, int threshold) {
        int bigLength = bigs.length;
        int littleLengthPerBig = littles.length / bigLength;
        boolean changed = false;
        int l = 0;
        for (int b = 0; b < bigLength; ++b) {
            byte sum = 0;
            int lEnd = l + littleLengthPerBig;
            while (l < lEnd) {
                if (littles[l] > threshold) {
                    sum = (byte)(sum + 1);
                }
                ++l;
            }
            if (bigs[b] == sum) continue;
            bigs[b] = sum;
            changed = true;
        }
        return changed;
    }

    private static double computeSpeechActivityScore(int vL, int nR, double p, double lambda) {
        double speechActivityScore = Math.log(DominantSpeakerIdentification.binomialCoefficient(nR, vL)) + (double)vL * Math.log(p) + (double)(nR - vL) * Math.log(1.0 - p) - Math.log(lambda) + lambda * (double)vL;
        if (speechActivityScore < 1.0E-10) {
            speechActivityScore = 1.0E-10;
        }
        return speechActivityScore;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeNotifier.addPropertyChangeListener(listener);
    }

    synchronized void decisionMakerExited(DecisionMaker decisionMaker) {
        if (this.decisionMaker == decisionMaker) {
            this.decisionMaker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject doGetJSON() {
        JSONObject jsonObject;
        if (DEBUG) {
            DominantSpeakerIdentification dominantSpeakerIdentification = this;
            synchronized (dominantSpeakerIdentification) {
                jsonObject = new JSONObject();
                long dominantSpeaker = this.getDominantSpeaker();
                jsonObject.put((Object)"dominantSpeaker", (Object)(dominantSpeaker == -1L ? null : Long.valueOf(dominantSpeaker)));
                Collection<Speaker> speakersCollection = this.speakers.values();
                JSONObject[] speakersArray = new JSONObject[this.speakers.size()];
                int i = 0;
                for (Speaker speaker : speakersCollection) {
                    JSONObject speakerJSONObject = new JSONObject();
                    speakerJSONObject.put((Object)"ssrc", (Object)speaker.ssrc);
                    speakerJSONObject.put((Object)"levels", (Object)speaker.getLevels());
                    speakersArray[i++] = speakerJSONObject;
                }
                jsonObject.put((Object)"speakers", (Object)speakersArray);
            }
        } else {
            jsonObject = null;
        }
        return jsonObject;
    }

    protected void firePropertyChange(String property, Long oldValue, Long newValue) {
        this.firePropertyChange(property, (Object)oldValue, (Object)newValue);
        if (DOMINANT_SPEAKER_PROPERTY_NAME.equals(property)) {
            long ssrc = newValue == null ? -1L : newValue;
            this.fireActiveSpeakerChanged(ssrc);
        }
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertyChangeNotifier.firePropertyChange(property, oldValue, newValue);
    }

    public long getDominantSpeaker() {
        Long dominantSSRC = this.dominantSSRC;
        return dominantSSRC == null ? -1L : dominantSSRC;
    }

    private synchronized Speaker getOrCreateSpeaker(long ssrc) {
        Long key = ssrc;
        Speaker speaker = this.speakers.get(key);
        if (speaker == null) {
            speaker = new Speaker(ssrc);
            this.speakers.put(key, speaker);
            this.maybeStartDecisionMaker();
        }
        return speaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void levelChanged(long ssrc, int level) {
        Speaker speaker;
        long now = System.currentTimeMillis();
        DominantSpeakerIdentification dominantSpeakerIdentification = this;
        synchronized (dominantSpeakerIdentification) {
            speaker = this.getOrCreateSpeaker(ssrc);
            if (this.lastLevelChangedTime < now) {
                this.lastLevelChangedTime = now;
                this.maybeStartDecisionMaker();
            }
        }
        if (speaker != null) {
            speaker.levelChanged(level, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDecision() {
        Long oldDominantSpeakerValue = null;
        Long newDominantSpeakerValue = null;
        DominantSpeakerIdentification dominantSpeakerIdentification = this;
        synchronized (dominantSpeakerIdentification) {
            Long newDominantSSRC;
            int speakerCount = this.speakers.size();
            if (speakerCount == 0) {
                newDominantSSRC = null;
            } else if (speakerCount == 1) {
                newDominantSSRC = this.speakers.keySet().iterator().next();
            } else {
                Speaker dominantSpeaker;
                Speaker speaker = dominantSpeaker = this.dominantSSRC == null ? null : this.speakers.get(this.dominantSSRC);
                if (dominantSpeaker == null) {
                    Map.Entry<Long, Speaker> s = this.speakers.entrySet().iterator().next();
                    dominantSpeaker = s.getValue();
                    newDominantSSRC = s.getKey();
                } else {
                    newDominantSSRC = null;
                }
                dominantSpeaker.evaluateSpeechActivityScores();
                double[] relativeSpeechActivities = this.relativeSpeechActivities;
                double newDominantC2 = 2.0;
                for (Map.Entry<Long, Speaker> s : this.speakers.entrySet()) {
                    Speaker speaker2 = s.getValue();
                    if (speaker2 == dominantSpeaker) continue;
                    speaker2.evaluateSpeechActivityScores();
                    for (int interval = 0; interval < relativeSpeechActivities.length; ++interval) {
                        relativeSpeechActivities[interval] = Math.log(speaker2.getSpeechActivityScore(interval) / dominantSpeaker.getSpeechActivityScore(interval));
                    }
                    double c1 = relativeSpeechActivities[0];
                    double c2 = relativeSpeechActivities[1];
                    double c3 = relativeSpeechActivities[2];
                    if (!(c1 > 3.0) || !(c2 > 2.0) || !(c3 > 0.0) || !(c2 > newDominantC2)) continue;
                    newDominantC2 = c2;
                    newDominantSSRC = s.getKey();
                }
            }
            if (newDominantSSRC != null && !newDominantSSRC.equals(this.dominantSSRC)) {
                oldDominantSpeakerValue = this.dominantSSRC;
                newDominantSpeakerValue = this.dominantSSRC = newDominantSSRC;
            }
        }
        if (newDominantSpeakerValue != null && !newDominantSpeakerValue.equals(oldDominantSpeakerValue)) {
            this.firePropertyChange(DOMINANT_SPEAKER_PROPERTY_NAME, oldDominantSpeakerValue, newDominantSpeakerValue);
        }
    }

    private synchronized void maybeStartDecisionMaker() {
        if (this.decisionMaker == null && !this.speakers.isEmpty()) {
            DecisionMaker decisionMaker = new DecisionMaker(this);
            boolean scheduled = false;
            this.decisionMaker = decisionMaker;
            try {
                threadPool.execute(decisionMaker);
                scheduled = true;
            }
            finally {
                if (!scheduled && this.decisionMaker == decisionMaker) {
                    this.decisionMaker = null;
                }
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeNotifier.removePropertyChangeListener(listener);
    }

    private long runInDecisionMaker() {
        long now = System.currentTimeMillis();
        long levelIdleTimeout = 40L - (now - this.lastLevelIdleTime);
        long sleep = 0L;
        if (levelIdleTimeout <= 0L) {
            if (this.lastLevelIdleTime != 0L) {
                this.timeoutIdleLevels(now);
            }
            this.lastLevelIdleTime = now;
        } else {
            sleep = levelIdleTimeout;
        }
        long decisionTimeout = 300L - (now - this.lastDecisionTime);
        if (decisionTimeout <= 0L) {
            this.lastDecisionTime = now;
            this.makeDecision();
            decisionTimeout = 300L - (System.currentTimeMillis() - now);
        }
        if (decisionTimeout > 0L && sleep > decisionTimeout) {
            sleep = decisionTimeout;
        }
        return sleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long runInDecisionMaker(DecisionMaker decisionMaker) {
        DominantSpeakerIdentification dominantSpeakerIdentification = this;
        synchronized (dominantSpeakerIdentification) {
            long idle;
            if (this.decisionMaker != decisionMaker) {
                return -1L;
            }
            if (0L < this.lastDecisionTime && (idle = this.lastDecisionTime - this.lastLevelChangedTime) >= 15000L) {
                return -1L;
            }
        }
        return this.runInDecisionMaker();
    }

    private synchronized void timeoutIdleLevels(long now) {
        Iterator<Map.Entry<Long, Speaker>> i = this.speakers.entrySet().iterator();
        while (i.hasNext()) {
            Speaker speaker = i.next().getValue();
            long idle = now - speaker.getLastLevelChangedTime();
            if (3600000L < idle && (this.dominantSSRC == null || speaker.ssrc != this.dominantSSRC)) {
                i.remove();
                continue;
            }
            if (40L >= idle) continue;
            speaker.levelTimedOut();
        }
    }

    static {
        DOMINANT_SPEAKER_PROPERTY_NAME = DominantSpeakerIdentification.class.getName() + ".dominantSpeaker";
        logger = Logger.getLogger(DominantSpeakerIdentification.class);
        threadPool = ExecutorUtils.newCachedThreadPool(true, "DominantSpeakerIdentification");
        DEBUG = logger.isDebugEnabled();
    }

    private static class Speaker {
        private final byte[] immediates = new byte[50];
        private double immediateSpeechActivityScore = 1.0E-10;
        private long lastLevelChangedTime = System.currentTimeMillis();
        private final byte[] levels;
        private final byte[] longs = new byte[1];
        private double longSpeechActivityScore = 1.0E-10;
        private final byte[] mediums = new byte[10];
        private double mediumSpeechActivityScore = 1.0E-10;
        private byte minLevel = 0;
        private byte nextMinLevel = 0;
        private int nextMinLevelWindowLength;
        public final long ssrc;

        public Speaker(long ssrc) {
            this.ssrc = ssrc;
            this.levels = new byte[this.immediates.length];
        }

        private boolean computeImmediates() {
            byte[] immediates = this.immediates;
            byte[] levels = this.levels;
            byte minLevel = (byte)(this.minLevel + 10);
            boolean changed = false;
            for (int i = 0; i < immediates.length; ++i) {
                byte immediate;
                byte level = levels[i];
                if (level < minLevel) {
                    level = 0;
                }
                if (immediates[i] == (immediate = (byte)(level / 10))) continue;
                immediates[i] = immediate;
                changed = true;
            }
            return changed;
        }

        private boolean computeLongs() {
            return DominantSpeakerIdentification.computeBigs(this.mediums, this.longs, 4);
        }

        private boolean computeMediums() {
            return DominantSpeakerIdentification.computeBigs(this.immediates, this.mediums, 7);
        }

        private void evaluateImmediateSpeechActivityScore() {
            this.immediateSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.immediates[0], 13, 0.5, 0.78);
        }

        private void evaluateLongSpeechActivityScore() {
            this.longSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.longs[0], 10, 0.5, 47.0);
        }

        private void evaluateMediumSpeechActivityScore() {
            this.mediumSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.mediums[0], 5, 0.5, 24.0);
        }

        synchronized void evaluateSpeechActivityScores() {
            if (this.computeImmediates()) {
                this.evaluateImmediateSpeechActivityScore();
                if (this.computeMediums()) {
                    this.evaluateMediumSpeechActivityScore();
                    if (this.computeLongs()) {
                        this.evaluateLongSpeechActivityScore();
                    }
                }
            }
        }

        public synchronized long getLastLevelChangedTime() {
            return this.lastLevelChangedTime;
        }

        byte[] getLevels() {
            byte[] src = this.levels;
            byte[] dst = new byte[src.length];
            int s = src.length - 1;
            for (int d = 0; d < dst.length; ++d) {
                dst[d] = src[s];
                --s;
            }
            return dst;
        }

        double getSpeechActivityScore(int interval) {
            switch (interval) {
                case 0: {
                    return this.immediateSpeechActivityScore;
                }
                case 1: {
                    return this.mediumSpeechActivityScore;
                }
                case 2: {
                    return this.longSpeechActivityScore;
                }
            }
            throw new IllegalArgumentException("interval " + interval);
        }

        public void levelChanged(int level) {
            this.levelChanged(level, System.currentTimeMillis());
        }

        public synchronized void levelChanged(int level, long time) {
            if (this.lastLevelChangedTime <= time) {
                this.lastLevelChangedTime = time;
                byte b = level < 0 ? (byte)0 : (level > 127 ? (byte)127 : (byte)((byte)level));
                System.arraycopy(this.levels, 0, this.levels, 1, this.levels.length - 1);
                this.levels[0] = b;
                this.updateMinLevel(b);
            }
        }

        public synchronized void levelTimedOut() {
            this.levelChanged(0, this.lastLevelChangedTime);
        }

        private void updateMinLevel(byte level) {
            if (level != 0) {
                if (this.minLevel == 0 || this.minLevel > level) {
                    this.minLevel = level;
                    this.nextMinLevel = 0;
                    this.nextMinLevelWindowLength = 0;
                } else if (this.nextMinLevel == 0) {
                    this.nextMinLevel = level;
                    this.nextMinLevelWindowLength = 1;
                } else {
                    if (this.nextMinLevel > level) {
                        this.nextMinLevel = level;
                    }
                    ++this.nextMinLevelWindowLength;
                    if (this.nextMinLevelWindowLength >= 750) {
                        double newMinLevel = Math.sqrt((double)this.minLevel * (double)this.nextMinLevel);
                        if (newMinLevel < 0.0) {
                            newMinLevel = 0.0;
                        } else if (newMinLevel > 127.0) {
                            newMinLevel = 127.0;
                        }
                        this.minLevel = (byte)newMinLevel;
                        this.nextMinLevel = 0;
                        this.nextMinLevelWindowLength = 0;
                    }
                }
            }
        }
    }

    private class PropertyChangeNotifier
    extends org.jitsi.util.event.PropertyChangeNotifier {
        private PropertyChangeNotifier() {
        }

        @Override
        public void firePropertyChange(String property, Object oldValue, Object newValue) {
            super.firePropertyChange(property, oldValue, newValue);
        }

        @Override
        protected Object getPropertyChangeSource(String property, Object oldValue, Object newValue) {
            return DominantSpeakerIdentification.this;
        }
    }

    private static class DecisionMaker
    implements Runnable {
        private final WeakReference<DominantSpeakerIdentification> algorithm;

        public DecisionMaker(DominantSpeakerIdentification algorithm) {
            this.algorithm = new WeakReference<DominantSpeakerIdentification>(algorithm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                DominantSpeakerIdentification algorithm;
                block5: while (true) {
                    while (true) {
                        if ((algorithm = (DominantSpeakerIdentification)this.algorithm.get()) == null) {
                            break block10;
                        }
                        long sleep = algorithm.runInDecisionMaker(this);
                        if (sleep < 0L) {
                            break block10;
                        }
                        if (sleep <= 0L) continue;
                        algorithm = null;
                        try {
                            Thread.sleep(sleep);
                            continue block5;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    algorithm = (DominantSpeakerIdentification)this.algorithm.get();
                    if (algorithm != null) {
                        algorithm.decisionMakerExited(this);
                    }
                }
            }
        }
    }
}

