/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.contactinfo;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.plugin.contactinfo.ContactInfoActivator;
import net.java.sip.communicator.plugin.contactinfo.ContactInfoDialog;
import net.java.sip.communicator.plugin.contactinfo.Resources;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.gui.AbstractPluginComponent;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.resources.ImageID;

public class ContactInfoMenuItem
extends AbstractPluginComponent
implements ActionListener {
    private AbstractButton menuItem = null;
    private MetaContact metaContact;
    private static final int CONTACT_INFO_BUTTON_IX = 50;

    public ContactInfoMenuItem(PluginComponentFactory parentFactory) {
        this(Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU, parentFactory);
    }

    public ContactInfoMenuItem(Container container, PluginComponentFactory parentFactory) {
        super(container, parentFactory);
    }

    public void setCurrentContact(MetaContact metaContact) {
        this.metaContact = metaContact;
    }

    public void setCurrentContact(Contact contact) {
        if (this.metaContact == null) {
            MetaContactListService mcs = ContactInfoActivator.getContactListService();
            this.metaContact = mcs.findMetaContactByContact(contact);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.metaContact == null) {
            return;
        }
        ContactInfoDialog cinfoDialog = new ContactInfoDialog(this.metaContact);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        cinfoDialog.setLocation(screenSize.width / 2 - cinfoDialog.getWidth() / 2, screenSize.height / 2 - cinfoDialog.getHeight() / 2);
        cinfoDialog.setVisible(true);
    }

    public Object getComponent() {
        return this.getMenuItem();
    }

    public String getName() {
        return this.getMenuItem().getText();
    }

    private AbstractButton getMenuItem() {
        if (this.menuItem == null) {
            if (this.getContainer().equals((Object)Container.CONTAINER_CHAT_TOOL_BAR)) {
                this.menuItem = new SIPCommButton(null, (Image)ContactInfoActivator.getImageLoaderService().getImage(new ImageID("plugin.contactinfo.CONTACT_INFO_TOOLBAR"))){

                    public int getIndex() {
                        return 50;
                    }
                };
                this.menuItem.setPreferredSize(new Dimension(25, 25));
                this.menuItem.setToolTipText(Resources.getString("service.gui.CONTACT_INFO"));
            } else if (this.getContainer().equals((Object)Container.CONTAINER_CALL_DIALOG)) {
                this.menuItem = new SIPCommButton(null, (Image)ContactInfoActivator.getImageLoaderService().getImage(new ImageID("plugin.contactinfo.CONTACT_INFO_CALL_WINDOW"))){

                    public int getIndex() {
                        return 50;
                    }
                };
                this.menuItem.setPreferredSize(new Dimension(44, 38));
                this.menuItem.setToolTipText(Resources.getString("service.gui.CONTACT_INFO"));
            } else {
                this.menuItem = new JMenuItem(Resources.getString("service.gui.CONTACT_INFO"), new ImageIcon(Resources.getImage("plugin.contactinfo.CONTACT_INFO_ICON")));
            }
            this.menuItem.addActionListener(this);
        }
        return this.menuItem;
    }
}

