/*
 * Decompiled with CFR 0.152.
 */
package mork;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import mork.DefaultExceptionHandler;
import mork.Dict;
import mork.Event;
import mork.EventListener;
import mork.ExceptionHandler;
import mork.MorkParser;
import mork.Row;
import mork.Table;

public class MorkDocument
implements EventListener {
    private List<Dict> dicts = new LinkedList<Dict>();
    private List<Row> rows = new LinkedList<Row>();
    private List<Table> tables = new LinkedList<Table>();

    public MorkDocument(Reader reader) {
        this(reader, new DefaultExceptionHandler());
    }

    public MorkDocument(Reader reader, ExceptionHandler exceptionHandler) {
        MorkParser parser = new MorkParser();
        parser.setExceptionHandler(exceptionHandler);
        parser.setIgnoreTransactionFailures(true);
        parser.addEventListener(this);
        parser.parse(reader);
    }

    @Override
    public void onEvent(Event event) {
        switch (event.eventType) {
            case END_DICT: {
                Dict dict = new Dict("<" + event.value + ">", this.dicts);
                this.dicts.add(dict);
                break;
            }
            case ROW: {
                Row row = new Row("[" + event.value + "]", this.dicts);
                this.rows.add(row);
                break;
            }
            case TABLE: {
                Table table = new Table("{" + event.value + "}", this.dicts);
                this.tables.add(table);
                break;
            }
            case GROUP_COMMIT: {
                MorkParser parser = new MorkParser();
                parser.addEventListener(this);
                parser.parse(new StringReader(event.value));
                break;
            }
            case BEGIN_DICT: 
            case BEGIN_DICT_METAINFO: 
            case END_DICT_METAINFO: 
            case COMMENT: 
            case END_OF_FILE: 
            case CELL: 
            case BEGIN_TABLE: 
            case BEGIN_METATABLE: 
            case END_METATABLE: {
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented event: " + (Object)((Object)event.eventType) + " for content " + event.value);
            }
        }
    }

    public List<Dict> getDicts() {
        return this.dicts;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public List<Table> getTables() {
        return this.tables;
    }
}

