/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.net;

import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sip.address.SipURI;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.service.certificate.CertificateMatcher;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;

public class RFC5922Matcher
implements CertificateMatcher {
    public static final String PNAME_STRICT_RFC5922 = "net.java.sip.communicator.sip.tls.STRICT_RFC5922";
    private ProtocolProviderServiceSipImpl provider;
    private static final Logger logger = Logger.getLogger(CertificateMatcher.class);

    public RFC5922Matcher(ProtocolProviderServiceSipImpl provider) {
        this.provider = provider;
    }

    public void verify(Iterable<String> identitiesToTest, X509Certificate cert) throws CertificateException {
        boolean strict = SipActivator.getConfigurationService().getBoolean(PNAME_STRICT_RFC5922, false);
        boolean oneMatched = false;
        Iterable<String> certIdentities = this.extractCertIdentities(cert);
        for (String identity : identitiesToTest) {
            for (String dnsName : certIdentities) {
                try {
                    if (NetworkUtils.compareDnsNames((String)dnsName, (String)identity) == 0) {
                        return;
                    }
                    if (strict || !dnsName.startsWith("*.") || identity.indexOf(".") >= identity.lastIndexOf(".") || NetworkUtils.compareDnsNames((String)dnsName.substring(2), (String)identity.substring(identity.indexOf(".") + 1)) != 0) continue;
                    return;
                }
                catch (ParseException parseException) {
                }
            }
        }
        if (!oneMatched) {
            throw new CertificateException("None of <" + identitiesToTest + "> matched by the rules of RFC5922 to the cert with CN=" + cert.getSubjectDN());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Iterable<String> extractCertIdentities(X509Certificate cert) {
        ArrayList<String> certIdentities = new ArrayList<String>();
        Collection<List<?>> subjAltNames = null;
        try {
            subjAltNames = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException ex) {
            logger.error((Object)"Error parsing TLS certificate", (Throwable)ex);
        }
        Integer dnsNameType = 2;
        Integer uriNameType = 6;
        if (subjAltNames != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("found subjAltNames: " + subjAltNames));
            }
            for (List<?> altName : subjAltNames) {
                if (!altName.get(0).equals(uriNameType)) continue;
                try {
                    SipURI altNameUri = this.provider.getAddressFactory().createSipURI((String)altName.get(1));
                    if (!"sip".equals(altNameUri.getScheme()) || altNameUri.getUser() != null) continue;
                    String altHostName = altNameUri.getHost();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("found uri " + altName.get(1) + ", hostName " + altHostName));
                    }
                    certIdentities.add(altHostName);
                }
                catch (ParseException e) {
                    logger.error((Object)("certificate contains invalid uri: " + altName.get(1)));
                }
            }
            if (!certIdentities.isEmpty()) return certIdentities;
            for (List<?> altName : subjAltNames) {
                if (!altName.get(0).equals(dnsNameType)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("found dns " + altName.get(1)));
                }
                certIdentities.add(altName.get(1).toString());
            }
            return certIdentities;
        } else {
            String dname = cert.getSubjectDN().getName();
            String cname = "";
            try {
                Pattern EXTRACT_CN = Pattern.compile(".*CN\\s*=\\s*([\\w*\\.]+).*");
                Matcher matcher = EXTRACT_CN.matcher(dname);
                if (!matcher.matches()) return certIdentities;
                cname = matcher.group(1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("found CN: " + cname + " from DN: " + dname));
                }
                certIdentities.add(cname);
                return certIdentities;
            }
            catch (Exception ex) {
                logger.error((Object)"exception while extracting CN", (Throwable)ex);
            }
        }
        return certIdentities;
    }
}

