/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.contactlist;

import java.util.Iterator;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockPersistentPresenceOperationSet;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MclSlickFixture
extends TestCase {
    public static BundleContext bundleContext = null;
    public MetaContactListService metaClService = null;
    public static MockProvider mockProvider = null;
    public static MockPersistentPresenceOperationSet mockPresOpSet = null;
    public static ServiceRegistration mockPrServiceRegistration = null;
    public static MockProvider replacementMockPr = null;
    public static MockProvider mockP1 = new MockProvider("mockP1");
    public static MockContactGroup mockP1Grp1 = new MockContactGroup("MockP1.Grp1", mockP1);
    public static MockContactGroup subMockP1Grp = new MockContactGroup("Mock1.SubProtoGroup", mockP1);
    public static MockContact emilP1 = new MockContact("emil@MockP1", mockP1);
    public static MockContact subEmilP1 = new MockContact("subemil@MockP1", mockP1);
    public static MetaContactGroup metaP1Grp1 = null;
    public static MockPersistentPresenceOperationSet mockPresOpSetP1 = null;
    public static ServiceRegistration mockP1ServiceRegistration = null;
    public static MockProvider replacementMockP1 = null;
    public static MockProvider mockP2 = new MockProvider("mockP2");
    public static MockContactGroup mockP2Grp1 = new MockContactGroup("MockP2.Grp1", mockP2);
    public static MockContact emilP2 = new MockContact("emil@MockP2", mockP2);
    public static MetaContactGroup metaP2Grp1 = null;
    public static MockPersistentPresenceOperationSet mockPresOpSetP2 = null;
    public static ServiceRegistration mockP2ServiceRegistration = null;
    public static MockProvider replacementMockP2 = null;

    public MclSlickFixture(Object obj) {
    }

    public void setUp() {
        ServiceReference ref = bundleContext.getServiceReference(MetaContactListService.class.getName());
        this.metaClService = (MetaContactListService)bundleContext.getService(ref);
    }

    public void tearDown() {
    }

    static void assertGroupEquals(MockContactGroup expectedGroup, MetaContactGroup actualGroup, boolean ignoreEmptyMetaGroups) {
        MclSlickFixture.assertNotNull((String)("Group " + expectedGroup.getGroupName() + " was returned by the MetaContactListService implementation but was not in the expected contact list."), (Object)actualGroup);
        MclSlickFixture.assertEquals((String)("Group " + expectedGroup.getGroupName() + ",  number of member contacts: "), (int)expectedGroup.countContacts(), (int)actualGroup.countChildContacts());
        if (!ignoreEmptyMetaGroups) {
            MclSlickFixture.assertEquals((String)("Group " + expectedGroup.getGroupName() + ", numbber of subgroups: "), (int)expectedGroup.countSubgroups(), (int)actualGroup.countSubgroups());
        } else {
            int emptyMetaGroups = 0;
            for (int i = 0; i < actualGroup.countSubgroups(); ++i) {
                if (actualGroup.getMetaContactSubgroup(i).countContactGroups() != 0) continue;
                ++emptyMetaGroups;
            }
            MclSlickFixture.assertEquals((String)("Group " + expectedGroup.getGroupName() + ", numbber of subgroups: "), (int)expectedGroup.countSubgroups(), (int)(actualGroup.countSubgroups() - emptyMetaGroups));
        }
        Iterator expectedSubgroups = expectedGroup.subgroups();
        while (expectedSubgroups.hasNext()) {
            MockContactGroup expectedSubGroup = (MockContactGroup)expectedSubgroups.next();
            MetaContactGroup actualSubGroup = actualGroup.getMetaContactSubgroup(expectedSubGroup.getGroupName());
            MclSlickFixture.assertGroupEquals(expectedSubGroup, actualSubGroup, ignoreEmptyMetaGroups);
        }
        Iterator actualContactsIter = actualGroup.getChildContacts();
        while (actualContactsIter.hasNext()) {
            MetaContact actualMetaContact = (MetaContact)actualContactsIter.next();
            MclSlickFixture.assertEquals((String)"Number of protocol specific contacts in a MetaContact", (int)1, (int)actualMetaContact.getContactCount());
            MclSlickFixture.assertTrue((String)("No contacts were encapsulated by MetaContact: " + actualMetaContact), (boolean)actualMetaContact.getContacts().hasNext());
            Contact actualProtoContact = (Contact)actualMetaContact.getContacts().next();
            MclSlickFixture.assertNotNull((String)"getContactForProvider returned null for MockProvider", (Object)actualProtoContact);
            Contact expectedProtoContact = expectedGroup.getContact(actualProtoContact.getAddress());
            MclSlickFixture.assertNotNull((String)("Contact " + actualMetaContact.getDisplayName() + " was returned by the MetaContactListService implementation but was not in the expected contact list."), (Object)expectedProtoContact);
        }
    }

    static {
        subMockP1Grp.addContact(subEmilP1);
        mockP1Grp1.addContact(emilP1);
        mockP1Grp1.addSubgroup(subMockP1Grp);
        mockPresOpSetP1 = (MockPersistentPresenceOperationSet)mockP1.getOperationSet(OperationSetPresence.class);
        mockPresOpSetP1.addMockGroup(mockP1Grp1);
        mockP2Grp1.addContact(emilP2);
        mockPresOpSetP2 = (MockPersistentPresenceOperationSet)mockP2.getOperationSet(OperationSetPresence.class);
        mockPresOpSetP2.addMockGroup(mockP2Grp1);
    }
}

