/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.msghistory;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.msghistory.MessageHistoryActivator;
import net.java.sip.communicator.impl.msghistory.MessageSourceService;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.msghistory.MessageSourceContactPresenceStatus;
import net.java.sip.communicator.service.muc.ChatRoomPresenceStatus;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import net.java.sip.communicator.util.DataObject;

public class MessageSourceContact
extends DataObject
implements SourceContact,
Comparable<MessageSourceContact> {
    private final MessageSourceService service;
    private String address = null;
    private String displayName = null;
    private ProtocolProviderService ppService = null;
    private PresenceStatus status = GlobalStatusEnum.OFFLINE;
    private byte[] image = null;
    private String messageContent = null;
    private final List<ContactDetail> contactDetails = new LinkedList<ContactDetail>();
    private Contact contact = null;
    private ChatRoom room = null;
    private Date timestamp = null;
    public static final String TODAY_DATE_FORMAT = "HH:mm', '";
    public static final String PAST_DATE_FORMAT = "MMM d', '";

    public ProtocolProviderService getProtocolProviderService() {
        return this.ppService;
    }

    MessageSourceContact(EventObject source, MessageSourceService service) {
        this.service = service;
        this.update(source);
    }

    private void updateMessageContent() {
        this.messageContent = this.isToday(this.timestamp) ? new SimpleDateFormat(TODAY_DATE_FORMAT).format(this.timestamp) + this.messageContent : new SimpleDateFormat(PAST_DATE_FORMAT).format(this.timestamp) + this.messageContent;
        if (this.messageContent != null && this.messageContent.length() > 60) {
            this.messageContent = this.messageContent.substring(0, 60);
            this.messageContent = this.messageContent + "...";
        }
    }

    private boolean isToday(Date timestamp) {
        Calendar today = Calendar.getInstance();
        Calendar tsCalendar = Calendar.getInstance();
        tsCalendar.setTime(timestamp);
        return today.get(1) == tsCalendar.get(1) && today.get(6) == tsCalendar.get(6);
    }

    void update(EventObject source) {
        if (source instanceof MessageDeliveredEvent) {
            MessageDeliveredEvent e = (MessageDeliveredEvent)source;
            this.contact = e.getDestinationContact();
            this.address = this.contact.getAddress();
            this.updateDisplayName();
            this.ppService = this.contact.getProtocolProvider();
            this.image = this.contact.getImage();
            this.status = this.contact.getPresenceStatus();
            this.messageContent = e.getSourceMessage().getContent();
            this.timestamp = e.getTimestamp();
        } else if (source instanceof MessageReceivedEvent) {
            MessageReceivedEvent e = (MessageReceivedEvent)source;
            this.contact = e.getSourceContact();
            this.address = this.contact.getAddress();
            this.updateDisplayName();
            this.ppService = this.contact.getProtocolProvider();
            this.image = this.contact.getImage();
            this.status = this.contact.getPresenceStatus();
            this.messageContent = e.getSourceMessage().getContent();
            this.timestamp = e.getTimestamp();
        } else if (source instanceof ChatRoomMessageDeliveredEvent) {
            ChatRoomMessageDeliveredEvent e = (ChatRoomMessageDeliveredEvent)source;
            this.room = e.getSourceChatRoom();
            this.address = this.room.getIdentifier();
            this.displayName = this.room.getName();
            this.ppService = this.room.getParentProvider();
            this.image = null;
            this.status = this.room.isJoined() ? ChatRoomPresenceStatus.CHAT_ROOM_ONLINE : ChatRoomPresenceStatus.CHAT_ROOM_OFFLINE;
            this.messageContent = e.getMessage().getContent();
            this.timestamp = e.getTimestamp();
        } else if (source instanceof ChatRoomMessageReceivedEvent) {
            ChatRoomMessageReceivedEvent e = (ChatRoomMessageReceivedEvent)source;
            this.room = e.getSourceChatRoom();
            this.address = this.room.getIdentifier();
            this.displayName = this.room.getName();
            this.ppService = this.room.getParentProvider();
            this.image = null;
            this.status = this.room.isJoined() ? ChatRoomPresenceStatus.CHAT_ROOM_ONLINE : ChatRoomPresenceStatus.CHAT_ROOM_OFFLINE;
            this.messageContent = e.getMessage().getContent();
            this.timestamp = e.getTimestamp();
        }
        if (this.service.isSMSEnabled()) {
            this.status = MessageSourceContactPresenceStatus.MSG_SRC_CONTACT_ONLINE;
        }
        this.updateMessageContent();
    }

    public String toString() {
        return "MessageSourceContact{address='" + this.address + '\'' + ", ppService=" + this.ppService + '}';
    }

    void initDetails(EventObject source) {
        if (source instanceof MessageDeliveredEvent) {
            this.initDetails(false, ((MessageDeliveredEvent)source).getDestinationContact());
        } else if (source instanceof MessageReceivedEvent) {
            this.initDetails(false, ((MessageReceivedEvent)source).getSourceContact());
        } else if (source instanceof ChatRoomMessageDeliveredEvent || source instanceof ChatRoomMessageReceivedEvent) {
            this.initDetails(true, null);
        }
    }

    void initDetails(boolean isChatRoom, Contact contact) {
        if (!isChatRoom && contact != null) {
            this.updateDisplayName();
        }
        ContactDetail contactDetail = new ContactDetail(this.address, this.displayName);
        ProtocolProviderService preferredProvider = this.ppService;
        OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)preferredProvider.getOperationSet(OperationSetContactCapabilities.class);
        Map opsetCapabilities = null;
        if (capOpSet != null && contact != null) {
            opsetCapabilities = capOpSet.getSupportedOperationSets(contact);
        }
        if (preferredProvider != null) {
            Hashtable<Class, ProtocolProviderService> preferredProviders = new Hashtable<Class, ProtocolProviderService>();
            LinkedList<Class> supportedOpSets = new LinkedList<Class>();
            for (Class opset : preferredProvider.getSupportedOperationSetClasses()) {
                if (opset.equals(OperationSetPresence.class) || opset.equals(OperationSetPersistentPresence.class) || (isChatRoom || this.service.isSMSEnabled()) && opset.equals(OperationSetBasicInstantMessaging.class) || !isChatRoom && opsetCapabilities != null && !opsetCapabilities.containsKey(opset.getName())) continue;
                preferredProviders.put(opset, preferredProvider);
                supportedOpSets.add(opset);
            }
            contactDetail.setPreferredProviders(preferredProviders);
            contactDetail.setSupportedOpSets(supportedOpSets);
        }
        this.contactDetails.clear();
        this.contactDetails.add(contactDetail);
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return MessageHistoryActivator.getResources().getI18NString("service.gui.UNKNOWN");
    }

    public String getContactAddress() {
        if (this.address != null) {
            return this.address;
        }
        return null;
    }

    public ContactSourceService getContactSource() {
        return this.service;
    }

    public String getDisplayDetails() {
        return this.messageContent;
    }

    public List<ContactDetail> getContactDetails() {
        return new LinkedList<ContactDetail>(this.contactDetails);
    }

    public List<ContactDetail> getContactDetails(Class<? extends OperationSet> operationSet) {
        LinkedList<ContactDetail> res = new LinkedList<ContactDetail>();
        for (ContactDetail det : this.contactDetails) {
            if (det.getPreferredProtocolProvider(operationSet) == null) continue;
            res.add(det);
        }
        return res;
    }

    public List<ContactDetail> getContactDetails(ContactDetail.Category category) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Categories are not supported for message source contact history.");
    }

    public ContactDetail getPreferredContactDetail(Class<? extends OperationSet> operationSet) {
        return this.contactDetails.get(0);
    }

    public byte[] getImage() {
        return this.image;
    }

    public boolean isDefaultImage() {
        return this.image == null;
    }

    public void setContactAddress(String contactAddress) {
    }

    public PresenceStatus getPresenceStatus() {
        return this.status;
    }

    public void setStatus(PresenceStatus status) {
        this.status = status;
    }

    public int getIndex() {
        return this.service.getIndex(this);
    }

    public Contact getContact() {
        return this.contact;
    }

    public ChatRoom getRoom() {
        return this.room;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private void updateDisplayName() {
        if (this.contact == null) {
            return;
        }
        MetaContact metaContact = MessageHistoryActivator.getContactListService().findMetaContactByContact(this.contact);
        if (metaContact == null) {
            return;
        }
        this.displayName = metaContact.getDisplayName();
    }

    @Override
    public int compareTo(MessageSourceContact o) {
        if (o == null || o.getTimestamp() == null) {
            return 1;
        }
        return o.getTimestamp().compareTo(this.getTimestamp());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageSourceContact that = (MessageSourceContact)o;
        if (!this.address.equals(that.address)) {
            return false;
        }
        return this.ppService.equals(that.ppService);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.ppService.hashCode();
        return result;
    }
}

