/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.busylampfield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.java.sip.communicator.plugin.busylampfield.BLFContactSourceService;
import net.java.sip.communicator.plugin.busylampfield.BLFPresenceStatus;
import net.java.sip.communicator.plugin.busylampfield.BLFSourceContact;
import net.java.sip.communicator.service.contactsource.AbstractContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyBLF;

public class BLFContactQuery
extends AbstractContactQuery<BLFContactSourceService> {
    private String queryString;
    private final List<SourceContact> results;

    public BLFContactQuery(BLFContactSourceService parentService, Collection<OperationSetTelephonyBLF.Line> monitoredLines, String queryString, int contactCount) {
        super((ContactSourceService)parentService);
        this.queryString = queryString;
        this.results = new ArrayList<SourceContact>();
        for (OperationSetTelephonyBLF.Line line : monitoredLines) {
            this.addLine(line, false);
        }
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List<SourceContact> getQueryResults() {
        return this.results;
    }

    public void start() {
        for (SourceContact sc : this.results) {
            this.fireContactReceived(sc, false);
        }
    }

    void addLine(OperationSetTelephonyBLF.Line line, boolean fireEvent) {
        for (SourceContact sc : this.results) {
            BLFSourceContact blfSC = (BLFSourceContact)sc;
            if (!blfSC.getLine().equals((Object)line)) continue;
            return;
        }
        BLFSourceContact sc = new BLFSourceContact(this.getContactSource(), line);
        this.results.add((SourceContact)sc);
        if (fireEvent) {
            this.fireContactReceived((SourceContact)sc, false);
        }
    }

    void updateLineStatus(OperationSetTelephonyBLF.Line line, int status) {
        for (SourceContact sc : this.results) {
            BLFSourceContact blfSC = (BLFSourceContact)sc;
            if (!blfSC.getLine().equals((Object)line)) continue;
            blfSC.setPresenceStatus(this.getPresenceStatus(status));
            this.fireContactChanged((SourceContact)blfSC);
            break;
        }
    }

    private BLFPresenceStatus getPresenceStatus(int status) {
        switch (status) {
            case 2: {
                return BLFPresenceStatus.BLF_BUSY;
            }
            case 0: {
                return BLFPresenceStatus.BLF_OFFLINE;
            }
            case 1: {
                return BLFPresenceStatus.BLF_RINGING;
            }
            case 3: {
                return BLFPresenceStatus.BLF_FREE;
            }
        }
        return null;
    }
}

