/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.notificationconfiguration;

import java.io.File;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileFilter;
import org.jitsi.util.SoundFileUtils;

public class SoundFilter
extends SipCommFileFilter {
    private String[] soundFormats = null;

    public SoundFilter() {
    }

    public SoundFilter(String[] soundFormats) {
        if (soundFormats != null) {
            this.soundFormats = new String[soundFormats.length];
            System.arraycopy(soundFormats, 0, this.soundFormats, 0, soundFormats.length);
        }
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return SoundFileUtils.isSoundFile((File)f, (String[])this.soundFormats);
    }

    public String getDescription() {
        String desc = "Sound File (";
        if (this.soundFormats != null) {
            for (int i = 0; i < this.soundFormats.length; ++i) {
                if (i != 0) {
                    desc = desc + ", ";
                }
                desc = desc + "*." + this.soundFormats[i];
            }
        } else {
            desc = desc + "*.au, *.mid, *.mod, *.mp2, *.mp3, *.ogg, *.ram, *.wav, *.wma";
        }
        desc = desc + ")";
        return desc;
    }
}

