/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.msghistory;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.impl.protocol.mock.MockBasicInstantMessaging;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockMultiUserChat;
import net.java.sip.communicator.impl.protocol.mock.MockPersistentPresenceOperationSet;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.slick.msghistory.MsgHistoryServiceLick;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class TestMsgHistoryServiceMultiChat
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestMsgHistoryServiceMultiChat.class);
    static final String TEST_CONTACT_NAME_1 = "Mincho_Penchev_the_fisrt";
    static final String TEST_CONTACT_NAME_2 = "Mincho_Penchev_the_second";
    static final String TEST_ROOM_NAME = "test_room";
    public static MockProvider mockProvider = null;
    public static MockPersistentPresenceOperationSet mockPresOpSet = null;
    public static MockBasicInstantMessaging mockBImOpSet = null;
    public static MockMultiUserChat mockMultiChat = null;
    private static ServiceReference msgHistoryServiceRef = null;
    public static MessageHistoryService msgHistoryService = null;
    public static HistoryService historyService = null;
    private static MockContact testContact = null;
    private static ServiceReference metaCLref = null;
    private static MetaContactListService metaClService = null;
    private static MetaContact testMetaContact = null;
    public static ServiceRegistration mockPrServiceRegistration = null;
    private static Message[] messagesToSend = null;
    private static Date controlDate1 = null;
    private static Date controlDate2 = null;
    private static Object lock = new Object();

    public TestMsgHistoryServiceMultiChat(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestMsgHistoryServiceMultiChat("readRecordsFromMultiChat"));
        return suite;
    }

    protected void setUp() throws Exception {
        this.setupContact();
        msgHistoryService.eraseLocallyStoredHistory();
        this.writeRecordsToMultiChat();
    }

    protected void tearDown() throws Exception {
        metaClService.purgeLocallyStoredContactListCopy();
    }

    public void setupContact() {
        System.setProperty("HistoryServiceDirectory", "test-msghistory");
        mockProvider = new MockProvider("MessageHistoryMockUser");
        Map supportedOperationSets = mockProvider.getSupportedOperationSets();
        mockPresOpSet = (MockPersistentPresenceOperationSet)supportedOperationSets.get(OperationSetPersistentPresence.class.getName());
        mockBImOpSet = (MockBasicInstantMessaging)supportedOperationSets.get(OperationSetBasicInstantMessaging.class.getName());
        mockMultiChat = (MockMultiUserChat)supportedOperationSets.get(OperationSetMultiUserChat.class.getName());
        msgHistoryServiceRef = MsgHistoryServiceLick.bc.getServiceReference(MessageHistoryService.class.getName());
        msgHistoryService = (MessageHistoryService)MsgHistoryServiceLick.bc.getService(msgHistoryServiceRef);
        ServiceReference historyServiceRef = MsgHistoryServiceLick.bc.getServiceReference(HistoryService.class.getName());
        historyService = (HistoryService)MsgHistoryServiceLick.bc.getService(historyServiceRef);
        MockContactGroup root = (MockContactGroup)mockPresOpSet.getServerStoredContactListRoot();
        testContact = new MockContact(TEST_CONTACT_NAME_1, mockProvider);
        root.addContact(testContact);
        metaCLref = MsgHistoryServiceLick.bc.getServiceReference(MetaContactListService.class.getName());
        metaClService = (MetaContactListService)MsgHistoryServiceLick.bc.getService(metaCLref);
        System.setProperty("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        Hashtable<String, String> mockProvProperties = new Hashtable<String, String>();
        mockProvProperties.put("PROTOCOL_NAME", mockProvider.getProtocolName());
        mockProvProperties.put("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        mockPrServiceRegistration = MsgHistoryServiceLick.bc.registerService(ProtocolProviderService.class.getName(), (Object)mockProvider, mockProvProperties);
        logger.debug((Object)"Registered a mock protocol provider! ");
        testMetaContact = metaClService.getRoot().getMetaContact((ProtocolProviderService)mockProvider, TEST_CONTACT_NAME_1);
        metaClService.addNewContactToMetaContact((ProtocolProviderService)mockProvider, testMetaContact, TEST_CONTACT_NAME_2);
        messagesToSend = new Message[]{mockBImOpSet.createMessage("test message word1-" + Math.random()), mockBImOpSet.createMessage("test message word2" + Math.random()), mockBImOpSet.createMessage("test message word3" + Math.random()), mockBImOpSet.createMessage("test message word4" + Math.random()), mockBImOpSet.createMessage("test message word5" + Math.random()), mockBImOpSet.createMessage("Hello \u0002World\u0002!"), mockBImOpSet.createMessage("less than < this, greater than > and an ampersand &")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitWrite(long timeout) {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void writeRecordsToMultiChat() {
        try {
            ChatRoom room = mockMultiChat.createChatRoom(TEST_ROOM_NAME, null);
            room.join();
            room.sendMessage(messagesToSend[0]);
            TestMsgHistoryServiceMultiChat.waitWrite(1000L);
            controlDate1 = new Date();
            logger.info((Object)("controlDate1:" + controlDate1.getTime()));
            TestMsgHistoryServiceMultiChat.waitWrite(1000L);
            room.sendMessage(messagesToSend[1]);
            TestMsgHistoryServiceMultiChat.waitWrite(100L);
            room.sendMessage(messagesToSend[2]);
            TestMsgHistoryServiceMultiChat.waitWrite(1000L);
            controlDate2 = new Date();
            logger.info((Object)("controlDate2:" + controlDate2.getTime()));
            TestMsgHistoryServiceMultiChat.waitWrite(1000L);
            room.sendMessage(messagesToSend[3]);
            TestMsgHistoryServiceMultiChat.waitWrite(1000L);
            room.sendMessage(messagesToSend[4]);
            TestMsgHistoryServiceMultiChat.waitWrite(1000L);
        }
        catch (OperationFailedException ex) {
            TestMsgHistoryServiceMultiChat.fail((String)("Failed to create room : " + ex.getMessage()));
            logger.error((Object)"Failed to create room", (Throwable)ex);
        }
        catch (OperationNotSupportedException ex) {
            TestMsgHistoryServiceMultiChat.fail((String)("Failed to create room : " + ex.getMessage()));
            logger.error((Object)"Failed to create room", (Throwable)ex);
        }
    }

    public void readRecordsFromMultiChat() {
        ChatRoom room = null;
        try {
            room = mockMultiChat.findRoom(TEST_ROOM_NAME);
        }
        catch (Exception ex) {
            TestMsgHistoryServiceMultiChat.fail((String)("Cannot find room!" + ex.getMessage()));
        }
        Collection rs = msgHistoryService.findByKeyword(room, "test");
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found findByKeyword ", (!rs.isEmpty() ? 1 : 0) != 0);
        List<String> msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Messages too few - findByKeyword", (msgs.size() >= 5 ? 1 : 0) != 0);
        rs = msgHistoryService.findByKeyword(room, "Test", false);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found findByKeyword caseINsensitive search", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Messages too few - findByKeyword", (msgs.size() >= 5 ? 1 : 0) != 0);
        rs = msgHistoryService.findByKeyword(room, "Test", true);
        TestMsgHistoryServiceMultiChat.assertFalse((String)"Something found by findByKeyword casesensitive search", (!rs.isEmpty() ? 1 : 0) != 0);
        rs = msgHistoryService.findByEndDate(room, controlDate2);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found findByEndDate", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Messages too few - findByEndDate", (msgs.size() >= 3 ? 1 : 0) != 0);
        rs = msgHistoryService.findByKeywords(room, new String[]{"test", "word2"});
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found findByKeywords", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Messages too few - findByKeywords", (msgs.size() >= 1 ? 1 : 0) != 0);
        rs = msgHistoryService.findByKeywords(room, new String[]{"test1", "word2"});
        TestMsgHistoryServiceMultiChat.assertFalse((String)"Something found findByKeywords", (!rs.isEmpty() ? 1 : 0) != 0);
        rs = msgHistoryService.findByPeriod(room, controlDate1, controlDate2);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found findByPeriod", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertEquals((String)"Messages must be 2", (int)2, (int)msgs.size());
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        rs = msgHistoryService.findByPeriod(room, controlDate1, controlDate2, new String[]{"word2"});
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found findByPeriod", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertEquals((String)"Messages must be 1", (int)1, (int)msgs.size());
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        rs = msgHistoryService.findByStartDate(room, controlDate2);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found findByStartDate", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertEquals((String)"Messages must be 2", (int)2, (int)msgs.size());
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[4].getContent()));
        rs = msgHistoryService.findLast(room, 3);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found 8", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertEquals((String)"Messages must be 3", (int)3, (int)msgs.size());
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[4].getContent()));
        rs = msgHistoryService.findFirstMessagesAfter(room, controlDate1, 3);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found 9", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertEquals((String)"Messages must be 3", (int)3, (int)msgs.size());
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        rs = msgHistoryService.findLastMessagesBefore(room, controlDate2, 3);
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Nothing found 10", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getChatMessages(rs);
        TestMsgHistoryServiceMultiChat.assertEquals((String)"Messages must be 3", (int)3, (int)msgs.size());
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[0].getContent()));
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        TestMsgHistoryServiceMultiChat.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
    }

    private List<String> getMessages(Collection<EventObject> rs) {
        Vector<String> result = new Vector<String>();
        for (EventObject item : rs) {
            if (item instanceof MessageDeliveredEvent) {
                result.add(((MessageDeliveredEvent)item).getSourceMessage().getContent());
                continue;
            }
            if (!(item instanceof MessageReceivedEvent)) continue;
            result.add(((MessageReceivedEvent)item).getSourceMessage().getContent());
        }
        return result;
    }

    private List<String> getChatMessages(Collection<EventObject> rs) {
        Vector<String> result = new Vector<String>();
        for (EventObject item : rs) {
            if (item instanceof ChatRoomMessageDeliveredEvent) {
                result.add(((ChatRoomMessageDeliveredEvent)item).getMessage().getContent());
                continue;
            }
            if (!(item instanceof ChatRoomMessageReceivedEvent)) continue;
            result.add(((ChatRoomMessageReceivedEvent)item).getMessage().getContent());
        }
        return result;
    }
}

