/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.event.TypingNotificationEvent;
import net.java.sip.communicator.service.protocol.event.TypingNotificationsListener;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmBuddyInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingListener;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingState;

public class TestOperationSetTypingNotifications
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetTypingNotifications.class);
    private IcqSlickFixture fixture = new IcqSlickFixture();
    private OperationSetTypingNotifications opSetTypingNotifs = null;
    private OperationSetPresence opSetPresence = null;

    public TestOperationSetTypingNotifications(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets = this.fixture.provider.getSupportedOperationSets();
        if (supportedOperationSets == null || supportedOperationSets.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this ICQ implementation. ");
        }
        this.opSetTypingNotifs = (OperationSetTypingNotifications)supportedOperationSets.get(OperationSetTypingNotifications.class.getName());
        if (this.opSetTypingNotifs == null) {
            throw new NullPointerException("No implementation for typing notifications was found");
        }
        this.opSetPresence = (OperationSetPresence)supportedOperationSets.get(OperationSetPresence.class.getName());
        if (this.opSetPresence == null) {
            throw new NullPointerException("An implementation of the ICQ service must provide an implementation of at least one of the PresenceOperationSets");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetTypingNotifications("firstTestTypingNotificationsEventDelivery"));
        suite.addTest((Test)new TestOperationSetTypingNotifications("thenTestSendTypingNotification"));
        return suite;
    }

    public void firstTestTypingNotificationsEventDelivery() {
        TypingEventCollector evtCollector = new TypingEventCollector();
        this.opSetTypingNotifs.addTypingNotificationsListener((TypingNotificationsListener)evtCollector);
        IcqSlickFixture.testerAgent.sendTypingNotification(this.fixture.ourUserID, TypingState.TYPING);
        evtCollector.waitForEvent(10000L);
        this.opSetTypingNotifs.removeTypingNotificationsListener((TypingNotificationsListener)evtCollector);
        TestOperationSetTypingNotifications.assertTrue((String)"Number of typing events received was zero.", (evtCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        TypingNotificationEvent evt = (TypingNotificationEvent)evtCollector.collectedEvents.get(0);
        TestOperationSetTypingNotifications.assertEquals((String)"Source of the typing notification event", (String)IcqSlickFixture.testerAgent.getIcqUIN(), (String)evt.getSourceContact().getAddress());
        TestOperationSetTypingNotifications.assertEquals((String)"Source of the typing notification event", (int)1, (int)evt.getTypingState());
    }

    public void thenTestSendTypingNotification() {
        JoustSimTypingEventCollector evtCollector = new JoustSimTypingEventCollector();
        Contact contactToNotify = this.opSetPresence.findContactByID(IcqSlickFixture.testerAgent.getIcqUIN());
        IcqSlickFixture.testerAgent.addTypingStateInfoListenerForBuddy(contactToNotify.getAddress(), evtCollector);
        this.opSetTypingNotifs.sendTypingNotification(contactToNotify, 1);
        IcqSlickFixture.testerAgent.removeTypingStateInfoListenerForBuddy(contactToNotify.getAddress(), evtCollector);
    }

    private class JoustSimTypingEventCollector
    implements IcbmListener,
    TypingListener {
        private List<TypingInfo> collectedTypingInfo = new LinkedList<TypingInfo>();

        private JoustSimTypingEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gotTypingState(Conversation conversation, TypingInfo typingInfo) {
            logger.debug((Object)(conversation.getBuddy() + " sent typing info: " + (Object)((Object)typingInfo.getTypingState())));
            JoustSimTypingEventCollector joustSimTypingEventCollector = this;
            synchronized (joustSimTypingEventCollector) {
                this.collectedTypingInfo.add(typingInfo);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            JoustSimTypingEventCollector joustSimTypingEventCollector = this;
            synchronized (joustSimTypingEventCollector) {
                if (this.collectedTypingInfo.size() > 0) {
                    logger.trace((Object)("evt already received. " + this.collectedTypingInfo));
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        @Override
        public void buddyInfoUpdated(IcbmService service, Screenname buddy, IcbmBuddyInfo info) {
        }

        @Override
        public void conversationClosed(Conversation c) {
        }

        @Override
        public void gotMessage(Conversation c, MessageInfo minfo) {
        }

        @Override
        public void gotOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        @Override
        public void sentOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        @Override
        public void canSendMessageChanged(Conversation c, boolean canSend) {
        }

        @Override
        public void conversationOpened(Conversation c) {
        }

        @Override
        public void newConversation(IcbmService service, Conversation conv) {
        }

        @Override
        public void sentMessage(Conversation c, MessageInfo minfo) {
        }

        @Override
        public void sendAutomaticallyFailed(IcbmService service, Message message, Set<Conversation> triedConversations) {
        }
    }

    private class TypingEventCollector
    implements TypingNotificationsListener {
        private List<EventObject> collectedEvents = new LinkedList<EventObject>();

        private TypingEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void typingNotificationReceived(TypingNotificationEvent event) {
            logger.debug((Object)("Received a typing notification: " + event));
            TypingEventCollector typingEventCollector = this;
            synchronized (typingEventCollector) {
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }

        public void typingNotificationDeliveryFailed(TypingNotificationEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            TypingEventCollector typingEventCollector = this;
            synchronized (typingEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }
    }
}

