/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Dictionary;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.pluginmanager.PluginManagerActivator;
import net.java.sip.communicator.plugin.pluginmanager.Resources;
import org.osgi.framework.Bundle;

public class PluginListCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 0L;
    private static final Color SELECTED_START_COLOR = new Color(Resources.getColor("service.gui.LIST_SELECTION_COLOR"));
    private static final Color SELECTED_END_COLOR = new Color(Resources.getColor("service.gui.GRADIENT_LIGHT_COLOR"));
    private JLabel nameVersionLabel = new JLabel();
    private JLabel descriptionLabel = new JLabel();
    private JLabel stateLabel = new JLabel();
    private boolean isSelected = false;
    private final ImageIcon[] stateIconCache = new ImageIcon[5];

    public PluginListCellRenderer() {
        super(new BorderLayout(8, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setBackground(Color.WHITE);
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new GridLayout(2, 1));
        mainPanel.add(this.nameVersionLabel);
        mainPanel.add(this.descriptionLabel);
        this.add((Component)mainPanel, "Center");
        this.add((Component)this.stateLabel, "West");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        Bundle bundle = (Bundle)value;
        Dictionary headers = bundle.getHeaders();
        Object bundleName = headers.get("Bundle-Name");
        Object bundleVersion = headers.get("Bundle-Version");
        Object bundleDescription = headers.get("Bundle-Description");
        ImageIcon stateIcon = this.getStateIcon(bundle.getState());
        StringBuilder sb = new StringBuilder();
        sb.append("<html><nobr><b>");
        sb.append(bundleName != null ? bundleName.toString() : "unknown");
        sb.append("</b> ");
        sb.append(bundleVersion != null ? bundleVersion.toString() : "");
        if (PluginManagerActivator.isSystemBundle(bundle)) {
            sb.append(" <b>(");
            sb.append(Resources.getString("plugin.pluginmanager.SYSTEM"));
            sb.append(")</b>");
        }
        sb.append("</nobr></html>");
        this.nameVersionLabel.setText(sb.toString());
        if (bundleDescription != null) {
            this.descriptionLabel.setText(bundleDescription.toString());
        } else {
            this.descriptionLabel.setText("");
        }
        if (stateIcon != null) {
            this.stateLabel.setIcon(stateIcon);
        }
        this.isSelected = isSelected;
        return this;
    }

    private ImageIcon getStateIcon(int state) {
        String imageID;
        int cacheIndex;
        switch (state) {
            case 2: {
                cacheIndex = 0;
                imageID = "plugin.pluginmanager.INSTALLED_STATE";
                break;
            }
            case 4: {
                cacheIndex = 1;
                imageID = "plugin.pluginmanager.DEACTIVATED_STATE";
                break;
            }
            case 8: {
                cacheIndex = 2;
                imageID = "plugin.pluginmanager.STARTING_STATE";
                break;
            }
            case 16: {
                cacheIndex = 3;
                imageID = "plugin.pluginmanager.STOPPING_STATE";
                break;
            }
            case 32: {
                cacheIndex = 4;
                imageID = "plugin.pluginmanager.ACTIVATE_STATE";
                break;
            }
            default: {
                return null;
            }
        }
        ImageIcon stateIcon = this.stateIconCache[cacheIndex];
        if (stateIcon == null) {
            this.stateIconCache[cacheIndex] = stateIcon = Resources.getResources().getImage(imageID);
        }
        return stateIcon;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        try {
            this.internalPaintComponent(g);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics g) {
        AntialiasingManager.activateAntialiasing((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isSelected) {
            GradientPaint p = new GradientPaint(width / 2, 0.0f, SELECTED_START_COLOR, width / 2, height, SELECTED_END_COLOR);
            g2.setPaint(p);
            g2.fillRoundRect(1, 1, width, height - 1, 7, 7);
        }
        g2.setColor(SELECTED_START_COLOR);
        g2.drawLine(0, height - 1, width, height - 1);
    }
}

