/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.negotiators;

import com.ircclouds.irc.api.CapabilityNegotiator;
import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.commands.CapCmd;
import com.ircclouds.irc.api.commands.CapEndCmd;
import com.ircclouds.irc.api.commands.CapReqCmd;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.domain.messages.interfaces.IMessage;
import com.ircclouds.irc.api.listeners.VariousMessageListenerAdapter;
import com.ircclouds.irc.api.negotiators.SaslContext;
import com.ircclouds.irc.api.negotiators.api.Relay;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslNegotiator
extends VariousMessageListenerAdapter
implements CapabilityNegotiator {
    private static final Logger LOG = LoggerFactory.getLogger(SaslNegotiator.class);
    private static final String SASL_CAPABILITY_ID = "sasl";
    private static final Pattern CAPABILITY_ACK = Pattern.compile("\\sCAP\\s+([^\\s]+)\\s+ACK\\s+:([\\w-_]+(?:\\s+[\\w-_]+)*)\\s*$", 0);
    private static final Pattern CAPABILITY_NAK = Pattern.compile("\\sCAP\\s+([^\\s]+)\\s+NAK");
    private static final Pattern AUTHENTICATE_CONFIRMATION = Pattern.compile("AUTHENTICATE\\s+(\\+)\\s*$", 0);
    private static final int RPL_LOGGEDIN = 900;
    private static final int RPL_LOGGEDOUT = 901;
    private static final int ERR_NICKLOCKED = 902;
    private static final int RPL_SASLSUCCESS = 903;
    private static final int ERR_SASLFAIL = 904;
    private static final int ERR_SASLTOOLONG = 905;
    private static final int ERR_SASLABORTED = 906;
    private static final int ERR_SASLALREADY = 907;
    private static final int RPL_SASLMECHS = 908;
    private final String user;
    private final String pass;
    private final String authzid;
    private SaslContext state;
    private IRCApi irc;

    public SaslNegotiator(String user, String pass, String authzid) {
        if (user == null) {
            throw new IllegalArgumentException("user cannot be null");
        }
        this.user = user;
        if (pass == null) {
            throw new IllegalArgumentException("pass cannot be null");
        }
        this.pass = pass;
        this.authzid = authzid;
    }

    @Override
    public CapCmd initiate(IRCApi irc) {
        if (irc == null) {
            throw new IllegalArgumentException("irc instance is required");
        }
        this.irc = irc;
        this.state = new SaslContext(new Relay(){

            @Override
            public void send(String msg) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CLIENT: {}", (Object)msg);
                }
                SaslNegotiator.this.irc.rawMessage(msg);
            }
        });
        return new CapReqCmd(SASL_CAPABILITY_ID, new String[0]);
    }

    @Override
    public void onMessage(IMessage msg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SERVER: {}", (Object)msg.asRaw());
        }
        String rawmsg = msg.asRaw();
        Matcher capAck = CAPABILITY_ACK.matcher(rawmsg);
        Matcher capNak = CAPABILITY_NAK.matcher(rawmsg);
        Matcher confirmation = AUTHENTICATE_CONFIRMATION.matcher(rawmsg);
        try {
            if (capAck.find() && this.saslAcknowledged(capAck.group(2))) {
                this.state.init();
            } else if (capNak.find()) {
                this.irc.rawMessage(new CapEndCmd().asString());
            } else if (confirmation.find()) {
                this.state.confirm(confirmation.group(1), this.authzid, this.user, this.pass);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Error occurred during CAP negotiation. Prematurely ending CAP negotiation phase and continuing IRC registration as is.", (Throwable)e);
            this.irc.rawMessage(new CapEndCmd().asString());
        }
    }

    private boolean saslAcknowledged(String acknowledged) {
        String[] caps;
        for (String cap : caps = acknowledged.split("\\s+")) {
            if (!SASL_CAPABILITY_ID.equals(cap)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onServerNumericMessage(ServerNumericMessage msg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SERVER: {}", (Object)msg.asRaw());
        }
        try {
            switch (msg.getNumericCode()) {
                case 900: {
                    this.state.loggedIn();
                    break;
                }
                case 903: {
                    this.state.success();
                    this.irc.rawMessage(new CapEndCmd().asString());
                    break;
                }
                case 904: {
                    this.state.fail();
                    break;
                }
                case 902: {
                    LOG.error("SASL account locked. Aborting authentication procedure.");
                    this.state.abort();
                    this.irc.rawMessage(new CapEndCmd().asString());
                    break;
                }
                case 905: {
                    this.state.abort();
                    break;
                }
                case 906: 
                case 907: {
                    this.irc.rawMessage(new CapEndCmd().asString());
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error("Error occurred during CAP negotiation. Ending CAP negotiation phase and continuing registration as is.", (Throwable)e);
            this.irc.rawMessage(new CapEndCmd().asString());
        }
    }
}

