/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.bouncycastle.crypto.BlockCipher;
import org.jitsi.impl.neomedia.transform.srtp.BlockCipherAdapter;
import org.jitsi.impl.neomedia.transform.srtp.BlockCipherFactory;

public class SecurityProviderBlockCipherFactory
implements BlockCipherFactory {
    private final Provider provider;
    private final String transformation;

    public SecurityProviderBlockCipherFactory(String transformation, Provider provider) {
        if (transformation == null) {
            throw new NullPointerException("transformation");
        }
        if (transformation.length() == 0) {
            throw new IllegalArgumentException("transformation");
        }
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        this.transformation = transformation;
        this.provider = provider;
    }

    public SecurityProviderBlockCipherFactory(String transformation, String providerName) {
        this(transformation, Security.getProvider(providerName));
    }

    @Override
    public BlockCipher createBlockCipher(int keySize) throws Exception {
        return new BlockCipherAdapter(Cipher.getInstance(this.transformation.replaceFirst("<size>", Integer.toString(keySize * 8)), this.provider));
    }
}

