/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.speex;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.speex.JNIEncoder;
import org.jitsi.impl.neomedia.codec.audio.speex.Speex;

public class JNIDecoder
extends AbstractCodec2 {
    private static final Format[] SUPPORTED_INPUT_FORMATS;
    private static final Format[] SUPPORTED_OUTPUT_FORMATS;
    private long bits = 0L;
    private long duration = 0L;
    private int frameSize = 0;
    private int sampleRate = 0;
    private long state = 0L;

    public JNIDecoder() {
        super("Speex JNI Decoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
    }

    @Override
    protected void doClose() {
        if (this.state != 0L) {
            Speex.speex_decoder_destroy(this.state);
            this.state = 0L;
            this.sampleRate = 0;
            this.frameSize = 0;
            this.duration = 0L;
        }
        Speex.speex_bits_destroy(this.bits);
        this.bits = 0L;
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.bits = Speex.speex_bits_init();
        if (this.bits == 0L) {
            throw new ResourceUnavailableException("speex_bits_init");
        }
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        boolean inputBufferNotConsumed;
        int outputLength;
        int inputLength;
        Format inputFormat = inputBuffer.getFormat();
        if (inputFormat != null && inputFormat != this.inputFormat && !inputFormat.equals((Object)this.inputFormat) && null == this.setInputFormat(inputFormat)) {
            return 1;
        }
        inputFormat = this.inputFormat;
        AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
        int inputSampleRate = (int)inputAudioFormat.getSampleRate();
        if (this.state != 0L && this.sampleRate != inputSampleRate) {
            Speex.speex_decoder_destroy(this.state);
            this.state = 0L;
            this.sampleRate = 0;
            this.frameSize = 0;
        }
        if (this.state == 0L) {
            long mode = Speex.speex_lib_get_mode(inputSampleRate == 16000 ? 1 : (inputSampleRate == 32000 ? 2 : 0));
            if (mode == 0L) {
                return 1;
            }
            this.state = Speex.speex_decoder_init(mode);
            if (this.state == 0L) {
                return 1;
            }
            if (Speex.speex_decoder_ctl(this.state, 0, 1) != 0) {
                return 1;
            }
            if (Speex.speex_decoder_ctl(this.state, 24, inputSampleRate) != 0) {
                return 1;
            }
            int frameSize = Speex.speex_decoder_ctl(this.state, 3);
            if (frameSize < 0) {
                return 1;
            }
            this.sampleRate = inputSampleRate;
            this.frameSize = frameSize * 2;
            this.duration = frameSize * 1000 * 1000000 / this.sampleRate;
        }
        if ((inputLength = inputBuffer.getLength()) > 0) {
            byte[] input = (byte[])inputBuffer.getData();
            int inputOffset = inputBuffer.getOffset();
            Speex.speex_bits_read_from(this.bits, input, inputOffset, inputLength);
            inputLength = 0;
            inputBuffer.setLength(inputLength);
            inputBuffer.setOffset(inputOffset + inputLength);
        }
        if ((outputLength = this.frameSize) > 0) {
            byte[] output = JNIDecoder.validateByteArraySize(outputBuffer, outputLength, false);
            if (0 == Speex.speex_decode_int(this.state, this.bits, output, 0)) {
                outputBuffer.setDuration(this.duration);
                outputBuffer.setFormat(this.getOutputFormat());
                outputBuffer.setLength(outputLength);
                outputBuffer.setOffset(0);
                inputBufferNotConsumed = Speex.speex_bits_remaining(this.bits) > 0;
            } else {
                outputBuffer.setLength(0);
                this.discardOutputBuffer(outputBuffer);
                inputBufferNotConsumed = false;
            }
        } else {
            outputBuffer.setLength(0);
            this.discardOutputBuffer(outputBuffer);
            inputBufferNotConsumed = false;
        }
        if (inputLength < 1 && !inputBufferNotConsumed) {
            return 0;
        }
        return 2;
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
        return new Format[]{new AudioFormat("LINEAR", inputAudioFormat.getSampleRate(), 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
    }

    @Override
    public Format setInputFormat(Format format) {
        Format inputFormat = super.setInputFormat(format);
        if (inputFormat != null) {
            int outputChannels;
            double outputSampleRate;
            if (this.outputFormat == null) {
                outputSampleRate = -1.0;
                outputChannels = -1;
            } else {
                AudioFormat outputAudioFormat = (AudioFormat)this.outputFormat;
                outputSampleRate = outputAudioFormat.getSampleRate();
                outputChannels = outputAudioFormat.getChannels();
            }
            AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
            double inputSampleRate = inputAudioFormat.getSampleRate();
            int inputChannels = inputAudioFormat.getChannels();
            if (outputSampleRate != inputSampleRate || outputChannels != inputChannels) {
                this.setOutputFormat((Format)new AudioFormat("LINEAR", inputSampleRate, 16, inputChannels, 0, 1, -1, -1.0, Format.byteArray));
            }
        }
        return inputFormat;
    }

    static {
        SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
        Speex.assertSpeexIsFunctional();
        double[] SUPPORTED_INPUT_SAMPLE_RATES = JNIEncoder.SUPPORTED_INPUT_SAMPLE_RATES;
        int supportedInputCount = SUPPORTED_INPUT_SAMPLE_RATES.length;
        SUPPORTED_INPUT_FORMATS = new Format[supportedInputCount];
        for (int i = 0; i < supportedInputCount; ++i) {
            JNIDecoder.SUPPORTED_INPUT_FORMATS[i] = new AudioFormat("speex/rtp", SUPPORTED_INPUT_SAMPLE_RATES[i], -1, 1, 0, 1, -1, -1.0, Format.byteArray);
        }
    }
}

