/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.authorization;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.skin.Skinnable;

public class RequestAuthorizationDialog
extends SIPCommDialog
implements ActionListener,
Skinnable {
    public static final int UNDEFINED_RETURN_CODE = -1;
    public static final int OK_RETURN_CODE = 1;
    public static final int CANCEL_RETURN_CODE = 0;
    private JTextArea infoTextArea = new JTextArea();
    private JLabel requestLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.TYPE_YOUR_REQUEST") + ": ");
    private JTextField requestField = new JTextField();
    private JPanel requestPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private String cancelString = GuiActivator.getResources().getI18NString("service.gui.CANCEL");
    private JButton requestButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.REQUEST"));
    private JButton cancelButton = new JButton(this.cancelString);
    private JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel northPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 0));
    private JPanel titlePanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private JLabel iconLabel = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.AUTHORIZATION_ICON)));
    private JLabel titleLabel = new JLabel();
    private String title = GuiActivator.getResources().getI18NString("service.gui.REQUEST_AUTHORIZATION");
    private Object lock = new Object();
    private int returnCode = -1;

    public RequestAuthorizationDialog(MainFrame mainFrame, Contact contact, AuthorizationRequest request) {
        super((Frame)((Object)mainFrame));
        this.setModal(false);
        this.setTitle(this.title);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText(this.title);
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(font.deriveFont(1, font.getSize2D() + 6.0f));
        this.mainPanel.setPreferredSize(new Dimension(400, 230));
        this.infoTextArea.setText(GuiActivator.getResources().getI18NString("service.gui.REQUEST_AUTHORIZATION_MSG", new String[]{contact.getDisplayName()}));
        this.infoTextArea.setFont(Constants.FONT.deriveFont(1, 12.0f));
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setOpaque(false);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setEditable(false);
        this.titlePanel.add(this.titleLabel);
        this.titlePanel.add(this.infoTextArea);
        this.northPanel.add((Component)this.iconLabel, "West");
        this.northPanel.add((Component)this.titlePanel, "Center");
        this.requestPanel.add((Component)this.requestLabel, "West");
        this.requestPanel.add((Component)this.requestField, "Center");
        this.requestButton.setName("request");
        this.cancelButton.setName("cancel");
        this.requestButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonsPanel.add(this.requestButton);
        this.buttonsPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.requestButton);
        this.requestButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REQUEST"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.requestPanel, "Center");
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.getContentPane().add(this.mainPanel);
    }

    public void showDialog() {
        this.setVisible(true);
        this.requestField.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReturnCode() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.returnCode == -1) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String name = button.getName();
        Object object = this.lock;
        synchronized (object) {
            if (name.equals("request")) {
                this.returnCode = 1;
            } else if (name.equals("cancel")) {
                this.returnCode = 0;
            }
            this.lock.notify();
        }
        this.dispose();
    }

    public String getRequestReason() {
        return this.requestField.getText();
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    public void loadSkin() {
        this.iconLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.AUTHORIZATION_ICON)));
    }
}

