/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.AlertUIServiceImpl;
import net.java.sip.communicator.impl.gui.UIServiceImpl;
import net.java.sip.communicator.impl.gui.main.account.Account;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.utils.ImageLoaderServiceImpl;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.service.callhistory.CallHistoryService;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.DemuxContactSourceService;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.desktop.DesktopService;
import net.java.sip.communicator.service.globaldisplaydetails.GlobalDisplayDetailsService;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.AlertUIService;
import net.java.sip.communicator.service.gui.ImageLoaderService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import net.java.sip.communicator.service.metahistory.MetaHistoryService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusService;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.service.replacement.directimage.DirectImageReplacementService;
import net.java.sip.communicator.service.replacement.smilies.SmiliesReplacementService;
import net.java.sip.communicator.service.shutdown.ShutdownService;
import net.java.sip.communicator.service.systray.SystrayService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class GuiActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(GuiActivator.class);
    private static UIServiceImpl uiService = null;
    public static BundleContext bundleContext;
    private static ConfigurationService configService;
    private static MetaHistoryService metaHistoryService;
    private static MetaContactListService metaCListService;
    private static CallHistoryService callHistoryService;
    private static AudioNotifierService audioNotifierService;
    private static BrowserLauncherService browserLauncherService;
    private static SystrayService systrayService;
    private static ResourceManagementService resourcesService;
    private static KeybindingsService keybindingsService;
    private static FileAccessService fileAccessService;
    private static DesktopService desktopService;
    private static MediaService mediaService;
    private static SmiliesReplacementService smiliesService;
    private static DirectImageReplacementService directImageService;
    private static GlobalStatusService globalStatusService;
    private static AccountManager accountManager;
    private static NotificationService notificationService;
    private static List<ContactSourceService> contactSources;
    private static SecurityAuthority securityAuthority;
    private static DemuxContactSourceService demuxContactSourceService;
    private static GlobalDisplayDetailsService globalDisplayDetailsService;
    private static AlertUIService alertUIService;
    private static CredentialsStorageService credentialsService;
    private static MUCService mucService;
    private static MessageHistoryService messageHistoryService;
    private static final Map<Object, ProtocolProviderFactory> providerFactoriesMap;
    private static final Map<String, ReplacementService> replacementSourcesMap;
    private static PhoneNumberI18nService phoneNumberI18nService;
    public static boolean isStarted;
    private static TreeContactList contactList;

    public void start(BundleContext bContext) throws Exception {
        isStarted = true;
        bundleContext = bContext;
        ConfigurationUtils.loadGuiConfigurations();
        try {
            alertUIService = new AlertUIServiceImpl();
            bundleContext.registerService(AlertUIService.class.getName(), (Object)alertUIService, null);
            bundleContext.registerService(ImageLoaderService.class.getName(), (Object)new ImageLoaderServiceImpl(), null);
            uiService = new UIServiceImpl();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    uiService.loadApplicationGui();
                    GuiActivator.getConfigurationService().addPropertyChangeListener((PropertyChangeListener)uiService);
                    bundleContext.addServiceListener((ServiceListener)uiService);
                    new Thread(){

                        @Override
                        public void run() {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)"UI Service...[  STARTED ]");
                            }
                            bundleContext.registerService(UIService.class.getName(), (Object)uiService, null);
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)"UI Service ...[REGISTERED]");
                            }
                            bundleContext.registerService(ShutdownService.class.getName(), (Object)uiService, null);
                        }
                    }.start();
                }
            });
            logger.logEntry();
        }
        finally {
            logger.logExit();
        }
    }

    public void stop(BundleContext bContext) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"UI Service ...[STOPPED]");
        }
        isStarted = false;
        GuiActivator.getConfigurationService().removePropertyChangeListener((PropertyChangeListener)uiService);
        bContext.removeServiceListener((ServiceListener)uiService);
        alertUIService.dispose();
    }

    public static Map<Object, ProtocolProviderFactory> getProtocolProviderFactories() {
        Collection serRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderFactory.class);
        if (!serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(serRef);
                providerFactoriesMap.put(serRef.getProperty("PROTOCOL_NAME"), providerFactory);
            }
        }
        return providerFactoriesMap;
    }

    public static AccountManager getAccountManager() {
        if (accountManager == null) {
            accountManager = (AccountManager)ServiceUtils.getService((BundleContext)bundleContext, AccountManager.class);
        }
        return accountManager;
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configService;
    }

    public static MetaHistoryService getMetaHistoryService() {
        if (metaHistoryService == null) {
            metaHistoryService = (MetaHistoryService)ServiceUtils.getService((BundleContext)bundleContext, MetaHistoryService.class);
        }
        return metaHistoryService;
    }

    public static MetaContactListService getContactListService() {
        if (metaCListService == null) {
            metaCListService = (MetaContactListService)ServiceUtils.getService((BundleContext)bundleContext, MetaContactListService.class);
        }
        return metaCListService;
    }

    public static CallHistoryService getCallHistoryService() {
        if (callHistoryService == null) {
            callHistoryService = (CallHistoryService)ServiceUtils.getService((BundleContext)bundleContext, CallHistoryService.class);
        }
        return callHistoryService;
    }

    public static AudioNotifierService getAudioNotifier() {
        if (audioNotifierService == null) {
            audioNotifierService = (AudioNotifierService)ServiceUtils.getService((BundleContext)bundleContext, AudioNotifierService.class);
        }
        return audioNotifierService;
    }

    public static BrowserLauncherService getBrowserLauncher() {
        if (browserLauncherService == null) {
            browserLauncherService = (BrowserLauncherService)ServiceUtils.getService((BundleContext)bundleContext, BrowserLauncherService.class);
        }
        return browserLauncherService;
    }

    public static GlobalStatusService getGlobalStatusService() {
        if (globalStatusService == null) {
            globalStatusService = (GlobalStatusService)ServiceUtils.getService((BundleContext)bundleContext, GlobalStatusService.class);
        }
        return globalStatusService;
    }

    public static UIServiceImpl getUIService() {
        return uiService;
    }

    public static AlertUIService getAlertUIService() {
        return alertUIService;
    }

    public static SystrayService getSystrayService() {
        if (systrayService == null) {
            systrayService = (SystrayService)ServiceUtils.getService((BundleContext)bundleContext, SystrayService.class);
        }
        return systrayService;
    }

    public static KeybindingsService getKeybindingsService() {
        if (keybindingsService == null) {
            keybindingsService = (KeybindingsService)ServiceUtils.getService((BundleContext)bundleContext, KeybindingsService.class);
        }
        return keybindingsService;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resourcesService;
    }

    public static FileAccessService getFileAccessService() {
        if (fileAccessService == null) {
            fileAccessService = (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
        }
        return fileAccessService;
    }

    public static DesktopService getDesktopService() {
        if (desktopService == null) {
            desktopService = (DesktopService)ServiceUtils.getService((BundleContext)bundleContext, DesktopService.class);
        }
        return desktopService;
    }

    public static MediaService getMediaService() {
        if (mediaService == null) {
            mediaService = (MediaService)ServiceUtils.getService((BundleContext)bundleContext, MediaService.class);
        }
        return mediaService;
    }

    public static DemuxContactSourceService getDemuxContactSourceService() {
        if (demuxContactSourceService == null) {
            demuxContactSourceService = (DemuxContactSourceService)ServiceUtils.getService((BundleContext)bundleContext, DemuxContactSourceService.class);
        }
        return demuxContactSourceService;
    }

    public static GlobalDisplayDetailsService getGlobalDisplayDetailsService() {
        if (globalDisplayDetailsService == null) {
            globalDisplayDetailsService = (GlobalDisplayDetailsService)ServiceUtils.getService((BundleContext)bundleContext, GlobalDisplayDetailsService.class);
        }
        return globalDisplayDetailsService;
    }

    public static List<ContactSourceService> getContactSources() {
        contactSources = new Vector<ContactSourceService>();
        Collection serRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ContactSourceService.class);
        if (!serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                ContactSourceService contactSource = (ContactSourceService)bundleContext.getService(serRef);
                contactSources.add(contactSource);
            }
        }
        return contactSources;
    }

    public static Map<String, ReplacementService> getReplacementSources() {
        Collection serRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ReplacementService.class);
        if (!serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                ReplacementService replacementSources = (ReplacementService)bundleContext.getService(serRef);
                replacementSourcesMap.put((String)serRef.getProperty("SOURCE"), replacementSources);
            }
        }
        return replacementSourcesMap;
    }

    public static SmiliesReplacementService getSmiliesReplacementSource() {
        if (smiliesService == null) {
            smiliesService = (SmiliesReplacementService)ServiceUtils.getService((BundleContext)bundleContext, SmiliesReplacementService.class);
        }
        return smiliesService;
    }

    public static DirectImageReplacementService getDirectImageReplacementSource() {
        if (directImageService == null) {
            directImageService = (DirectImageReplacementService)ServiceUtils.getService((BundleContext)bundleContext, DirectImageReplacementService.class);
        }
        return directImageService;
    }

    public static SecurityAuthority getSecurityAuthority() {
        if (securityAuthority == null) {
            securityAuthority = (SecurityAuthority)ServiceUtils.getService((BundleContext)bundleContext, SecurityAuthority.class);
        }
        return securityAuthority;
    }

    public static NotificationService getNotificationService() {
        if (notificationService == null) {
            notificationService = (NotificationService)ServiceUtils.getService((BundleContext)bundleContext, NotificationService.class);
        }
        return notificationService;
    }

    public static SecurityAuthority getSecurityAuthority(String protocolName) {
        String osgiFilter = "(PROTOCOL_NAME=" + protocolName + ")";
        SecurityAuthority securityAuthority = null;
        try {
            Collection serRefs = bundleContext.getServiceReferences(SecurityAuthority.class, osgiFilter);
            if (!serRefs.isEmpty()) {
                ServiceReference serRef = (ServiceReference)serRefs.iterator().next();
                securityAuthority = (SecurityAuthority)bundleContext.getService(serRef);
            }
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)("GuiActivator : " + (Object)((Object)ex)));
        }
        return securityAuthority;
    }

    public static void setContactList(TreeContactList list) {
        contactList = list;
    }

    public static TreeContactList getContactList() {
        return contactList;
    }

    public static Account[] getAccounts(List<ProtocolProviderService> providers) {
        Iterator<ProtocolProviderService> accountsIter = providers.iterator();
        ArrayList<Account> accounts = new ArrayList<Account>();
        while (accountsIter.hasNext()) {
            accounts.add(new Account(accountsIter.next()));
        }
        return accounts.toArray(new Account[accounts.size()]);
    }

    public static ProtocolProviderService getPreferredAccount() {
        String prefWName = GuiActivator.getResources().getSettingsString("impl.gui.PREFERRED_ACCOUNT_WIZARD");
        if (prefWName == null || prefWName.length() <= 0) {
            return null;
        }
        Collection accountWizardRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, AccountRegistrationWizard.class);
        if (accountWizardRefs != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + accountWizardRefs.size() + " already installed providers."));
            }
            for (ServiceReference accountWizardRef : accountWizardRefs) {
                AccountRegistrationWizard wizard = (AccountRegistrationWizard)bundleContext.getService(accountWizardRef);
                if (!wizard.getClass().getName().equals(prefWName)) continue;
                for (ProtocolProviderFactory providerFactory : GuiActivator.getProtocolProviderFactories().values()) {
                    for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                        ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
                        ProtocolProviderService protocolProvider = (ProtocolProviderService)bundleContext.getService(serRef);
                        if (!protocolProvider.getAccountID().getProtocolDisplayName().equals(wizard.getProtocolName())) continue;
                        return protocolProvider;
                    }
                }
            }
        }
        return null;
    }

    public static CredentialsStorageService getCredentialsStorageService() {
        if (credentialsService == null) {
            credentialsService = (CredentialsStorageService)ServiceUtils.getService((BundleContext)bundleContext, CredentialsStorageService.class);
        }
        return credentialsService;
    }

    public static MUCService getMUCService() {
        if (mucService == null) {
            mucService = (MUCService)ServiceUtils.getService((BundleContext)bundleContext, MUCService.class);
        }
        return mucService;
    }

    public static MessageHistoryService getMessageHistoryService() {
        if (messageHistoryService == null) {
            messageHistoryService = (MessageHistoryService)ServiceUtils.getService((BundleContext)bundleContext, MessageHistoryService.class);
        }
        return messageHistoryService;
    }

    public static PhoneNumberI18nService getPhoneNumberI18nService() {
        if (phoneNumberI18nService == null) {
            phoneNumberI18nService = (PhoneNumberI18nService)ServiceUtils.getService((BundleContext)bundleContext, PhoneNumberI18nService.class);
        }
        return phoneNumberI18nService;
    }

    static {
        providerFactoriesMap = new Hashtable<Object, ProtocolProviderFactory>();
        replacementSourcesMap = new Hashtable<String, ReplacementService>();
        isStarted = false;
    }
}

