/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts;

import com.google.gdata.data.Link;
import com.google.gdata.data.contacts.ContactEntry;
import com.google.gdata.data.extensions.Email;
import com.google.gdata.data.extensions.Im;
import com.google.gdata.data.extensions.Name;
import com.google.gdata.data.extensions.PhoneNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsEntry;

public class GoogleContactsEntryImpl
implements GoogleContactsEntry {
    private static final String GOOGLETALK_PROTOCOL = "http://schemas.google.com/g/2005#GOOGLE_TALK";
    private static final String AIM_PROTOCOL = "http://schemas.google.com/g/2005#AIM";
    private static final String SKYPE_PROTOCOL = "http://schemas.google.com/g/2005#SKYPE";
    private static final String ICQ_PROTOCOL = "http://schemas.google.com/g/2005#ICQ";
    private static final String JABBER_PROTOCOL = "http://schemas.google.com/g/2005#JABBER";
    private String fullName = null;
    private String familyName = null;
    private String givenName = null;
    private final List<String> homeMails = new ArrayList<String>();
    private final List<String> workMails = new ArrayList<String>();
    private final List<String> homePhones = new ArrayList<String>();
    private final List<String> workPhones = new ArrayList<String>();
    private final List<String> mobilePhones = new ArrayList<String>();
    private final Map<String, GoogleContactsEntry.IMProtocol> imAddresses = new HashMap<String, GoogleContactsEntry.IMProtocol>();
    private String photoLink = null;
    private Link googlePhotoLink = null;

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getGivenName() {
        return this.givenName;
    }

    @Override
    public List<String> getAllMails() {
        ArrayList<String> mails = new ArrayList<String>();
        for (String mail : this.homeMails) {
            mails.add(mail);
        }
        for (String mail : this.workMails) {
            mails.add(mail);
        }
        return mails;
    }

    @Override
    public void addHomeMail(String mail) {
        this.homeMails.add(mail);
    }

    @Override
    public List<String> getHomeMails() {
        return this.homeMails;
    }

    @Override
    public void addWorkMails(String mail) {
        this.workMails.add(mail);
    }

    @Override
    public List<String> getWorkMails() {
        return this.workMails;
    }

    @Override
    public List<String> getAllPhones() {
        ArrayList<String> phones = new ArrayList<String>();
        for (String phone : this.mobilePhones) {
            phones.add(phone);
        }
        for (String phone : this.homePhones) {
            phones.add(phone);
        }
        for (String phone : this.workPhones) {
            phones.add(phone);
        }
        return phones;
    }

    @Override
    public void addWorkPhone(String telephoneNumber) {
        this.workPhones.add(telephoneNumber);
    }

    @Override
    public List<String> getWorkPhones() {
        return this.workPhones;
    }

    @Override
    public void addMobilePhone(String telephoneNumber) {
        this.mobilePhones.add(telephoneNumber);
    }

    @Override
    public List<String> getMobilePhones() {
        return this.mobilePhones;
    }

    @Override
    public void addHomePhone(String telephoneNumber) {
        this.homePhones.add(telephoneNumber);
    }

    @Override
    public List<String> getHomePhones() {
        return this.homePhones;
    }

    @Override
    public String getPhoto() {
        return this.photoLink;
    }

    public Link getPhotoLink() {
        return this.googlePhotoLink;
    }

    @Override
    public Map<String, GoogleContactsEntry.IMProtocol> getIMAddresses() {
        return this.imAddresses;
    }

    @Override
    public void addIMAddress(String imAddress, GoogleContactsEntry.IMProtocol protocol) {
        this.imAddresses.put(imAddress, protocol);
    }

    public void setField(ContactEntry contact) {
        Name name = contact.getName();
        if (name != null) {
            if (name.hasFullName()) {
                this.fullName = name.getFullName().getValue();
            }
            if (name.hasFamilyName()) {
                this.familyName = name.getFamilyName().getValue();
            }
            if (name.hasGivenName()) {
                this.givenName = name.getGivenName().getValue();
            }
        }
        this.googlePhotoLink = contact.getContactPhotoLink();
        this.photoLink = this.googlePhotoLink.getHref();
        for (Email mail : contact.getEmailAddresses()) {
            if (mail.getRel() == null) {
                this.homeMails.add(mail.getAddress());
                continue;
            }
            if (mail.getRel().contains("#home")) {
                this.homeMails.add(mail.getAddress());
                continue;
            }
            if (mail.getRel().contains("#work")) {
                this.workMails.add(mail.getAddress());
                continue;
            }
            this.homeMails.add(mail.getAddress());
        }
        for (PhoneNumber phone : contact.getPhoneNumbers()) {
            if (phone.getRel() == null) {
                this.homePhones.add(phone.getPhoneNumber());
                continue;
            }
            if (phone.getRel().contains("#work")) {
                this.workPhones.add(phone.getPhoneNumber());
                continue;
            }
            if (phone.getRel().contains("#mobile")) {
                this.mobilePhones.add(phone.getPhoneNumber());
                continue;
            }
            if (phone.getRel().contains("#home")) {
                this.homePhones.add(phone.getPhoneNumber());
                continue;
            }
            this.homePhones.add(phone.getPhoneNumber());
        }
        for (Im imAddress : contact.getImAddresses()) {
            String protocol = imAddress.getProtocol();
            GoogleContactsEntry.IMProtocol proto = protocol == null ? GoogleContactsEntry.IMProtocol.OTHER : (protocol.equals(GOOGLETALK_PROTOCOL) ? GoogleContactsEntry.IMProtocol.GOOGLETALK : (protocol.equals(AIM_PROTOCOL) ? GoogleContactsEntry.IMProtocol.AIM : (protocol.equals(SKYPE_PROTOCOL) ? GoogleContactsEntry.IMProtocol.SKYPE : (protocol.equals(ICQ_PROTOCOL) ? GoogleContactsEntry.IMProtocol.ICQ : (protocol.equals(JABBER_PROTOCOL) ? GoogleContactsEntry.IMProtocol.JABBER : GoogleContactsEntry.IMProtocol.OTHER)))));
            this.imAddresses.put(imAddress.getAddress(), proto);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.fullName != null) {
            buffer.append("Full name: ");
            buffer.append(this.fullName);
            buffer.append("\n");
        }
        if (this.givenName != null || this.familyName != null) {
            buffer.append("Display name: ");
            buffer.append(this.givenName != null ? this.givenName : "");
            buffer.append(" ");
            buffer.append(this.familyName != null ? this.familyName : "");
            buffer.append("\n");
        }
        if (this.getAllMails().size() > 0) {
            buffer.append("Mail:\n");
            for (String string : this.getAllMails()) {
                buffer.append("\t");
                buffer.append(string);
                buffer.append("\n");
            }
        }
        if (this.workPhones.size() > 0) {
            buffer.append("Work phones:\n");
            for (String string : this.workPhones) {
                buffer.append("\t");
                buffer.append(string);
                buffer.append("\n");
            }
        }
        if (this.homePhones.size() > 0) {
            buffer.append("Home phones:\n");
            for (String string : this.homePhones) {
                buffer.append("\t");
                buffer.append(string);
                buffer.append("\n");
            }
        }
        if (this.mobilePhones.size() > 0) {
            buffer.append("Mobile phones:\n");
            for (String string : this.mobilePhones) {
                buffer.append("\t");
                buffer.append(string);
                buffer.append("\n");
            }
        }
        if (this.imAddresses.size() > 0) {
            buffer.append("IM addresses:\n");
            for (Map.Entry entry : this.imAddresses.entrySet()) {
                buffer.append("\t");
                buffer.append((String)entry.getKey());
                buffer.append(" (");
                buffer.append(entry.getValue());
                buffer.append(")\n");
            }
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

