/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.input;

import com.google.gdata.model.Element;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.ContentCreationException;
import com.google.gdata.wireformats.ContentValidationException;
import com.google.gdata.wireformats.WireFormat;
import com.google.gdata.wireformats.WireFormatParser;
import com.google.gdata.wireformats.input.CharacterParser;
import com.google.gdata.wireformats.input.InputProperties;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class ElementParser<T>
extends CharacterParser<T> {
    public static <T> ElementParser<T> of(AltFormat altFormat, Class<T> resultType) {
        Preconditions.checkArgument(altFormat.getWireFormat() != null, "No wire format defined for " + altFormat);
        return new ElementParser<T>(altFormat, resultType);
    }

    protected ElementParser(AltFormat altFormat, Class<T> resultType) {
        super(altFormat, resultType);
    }

    @Override
    public <R extends T> R parse(Reader inputReader, InputProperties inProps, Class<R> resultClass) throws IOException, ServiceException {
        Preconditions.checkNotNull(inProps.getRootMetadata(), "No element metadata");
        R result = this.createResult(resultClass);
        if (result instanceof Element) {
            Element element = (Element)result;
            WireFormat format = this.altFormat.getWireFormat();
            try {
                WireFormatParser parser = format.createParser(inProps, inputReader, Charset.forName(this.getCharset(inProps)));
                result = resultClass.cast(parser.parse(element));
            }
            catch (IllegalCharsetNameException ice) {
                throw new ParseException("Invalid charset:" + this.getCharset(inProps), (Throwable)ice);
            }
            catch (UnsupportedCharsetException uce) {
                throw new ParseException("Invalid charset:" + this.getCharset(inProps), (Throwable)uce);
            }
            catch (ContentCreationException e) {
                throw new ParseException("Unable to create element to parse into.", (Throwable)e);
            }
            catch (ContentValidationException e) {
                throw new ParseException("Error trying to parse element.", (Throwable)e);
            }
        } else {
            throw new ContentCreationException("Result class is not an Element type: " + resultClass);
        }
        return result;
    }
}

