/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IEntry;
import com.google.gdata.util.ErrorDomain;
import com.google.gdata.util.GenerateUtil;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.net.HttpURLConnection;

public class VersionConflictException
extends ServiceException {
    private IEntry currentEntry;

    public VersionConflictException() {
        super("Version conflict");
        this.currentEntry = null;
        this.setHttpErrorCodeOverride(409);
    }

    public VersionConflictException(IEntry currentEntry) {
        super("Version conflict");
        this.currentEntry = currentEntry;
        this.setHttpErrorCodeOverride(409);
    }

    public VersionConflictException(IEntry currentEntry, Throwable cause) {
        super("Version conflict", cause);
        this.currentEntry = currentEntry;
        this.setHttpErrorCodeOverride(409);
    }

    public VersionConflictException(HttpURLConnection httpConn) throws IOException {
        super(httpConn);
    }

    public VersionConflictException(ErrorDomain.ErrorCode errorCode) {
        super(errorCode);
        this.setHttpErrorCodeOverride(409);
    }

    public VersionConflictException(ErrorDomain.ErrorCode errorCode, Throwable cause) {
        super(errorCode, cause);
        this.setHttpErrorCodeOverride(409);
    }

    public IEntry getCurrentEntry() {
        return this.currentEntry;
    }

    public void setCurrentEntry(IEntry entry) {
        this.currentEntry = entry;
    }

    public void generate(ExtensionProfile extProfile, XmlWriter xw) throws IOException {
        GenerateUtil.generateAtom(xw, this.currentEntry, extProfile);
    }
}

