/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.PriorityTable;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.wizard.EncryptionConfigurationTableModel;
import net.java.sip.communicator.service.protocol.SecurityAccountRegistration;
import net.java.sip.communicator.util.UtilActivator;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.SDesControl;
import org.jitsi.service.neomedia.SrtpControlType;

public class SecurityPanel
extends TransparentPanel
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 0L;
    private final SecurityAccountRegistration regform;
    private JPanel pnlAdvancedSettings;
    private JCheckBox enableDefaultEncryption;
    private JCheckBox enableSipZrtpAttribute;
    private JComboBox<SavpOption> cboSavpOption;
    private JTable tabCiphers;
    private CipherTableModel cipherModel;
    private JLabel cmdExpandAdvancedSettings;
    private EncryptionConfigurationTableModel encryptionConfigurationTableModel;
    private PriorityTable encryptionProtocolPreferences;
    private boolean displaySavpOtions;

    public SecurityPanel(SecurityAccountRegistration regform, boolean displaySavpOptions) {
        super(new BorderLayout(10, 10));
        this.regform = regform;
        this.displaySavpOtions = displaySavpOptions;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        TransparentPanel mainPanel = new TransparentPanel();
        this.add((Component)((Object)mainPanel), "North");
        ((Container)((Object)mainPanel)).setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 21;
        c.fill = 2;
        this.enableDefaultEncryption = new SIPCommCheckBox(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.ENABLE_DEFAULT_ENCRYPTION"), this.regform.isDefaultEncryption());
        this.enableDefaultEncryption.addActionListener(this);
        ((Container)((Object)mainPanel)).add(this.enableDefaultEncryption, c);
        JLabel lblWarning = new JLabel();
        lblWarning.setBorder(new EmptyBorder(10, 5, 10, 0));
        lblWarning.setText(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.SECURITY_WARNING", new String[]{UtilActivator.getResources().getSettingsString("service.gui.APPLICATION_NAME")}));
        ++c.gridy;
        ((Container)((Object)mainPanel)).add(lblWarning, c);
        this.cmdExpandAdvancedSettings = new JLabel();
        this.cmdExpandAdvancedSettings.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.cmdExpandAdvancedSettings.setIcon(UtilActivator.getResources().getImage("service.gui.icons.RIGHT_ARROW_ICON"));
        this.cmdExpandAdvancedSettings.setText(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.SHOW_ADVANCED"));
        this.cmdExpandAdvancedSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SecurityPanel.this.cmdExpandAdvancedSettings.setIcon(UtilActivator.getResources().getImage(SecurityPanel.this.pnlAdvancedSettings.isVisible() ? "service.gui.icons.RIGHT_ARROW_ICON" : "service.gui.icons.DOWN_ARROW_ICON"));
                SecurityPanel.this.pnlAdvancedSettings.setVisible(!SecurityPanel.this.pnlAdvancedSettings.isVisible());
                SecurityPanel.this.pnlAdvancedSettings.revalidate();
            }
        });
        ++c.gridy;
        ((Container)((Object)mainPanel)).add(this.cmdExpandAdvancedSettings, c);
        this.pnlAdvancedSettings = new TransparentPanel();
        this.pnlAdvancedSettings.setLayout(new GridBagLayout());
        this.pnlAdvancedSettings.setVisible(false);
        ++c.gridy;
        ((Container)((Object)mainPanel)).add(this.pnlAdvancedSettings, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        this.pnlAdvancedSettings.add((Component)new JSeparator(), c);
        JLabel lblEncryptionProtocolPreferences = new JLabel();
        lblEncryptionProtocolPreferences.setText(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.ENCRYPTION_PROTOCOL_PREFERENCES"));
        ++c.gridy;
        this.pnlAdvancedSettings.add((Component)lblEncryptionProtocolPreferences, c);
        int nbEncryptionProtocols = SecurityAccountRegistration.ENCRYPTION_PROTOCOLS.size();
        String[] encryptions = new String[nbEncryptionProtocols];
        boolean[] selectedEncryptions = new boolean[nbEncryptionProtocols];
        this.encryptionConfigurationTableModel = new EncryptionConfigurationTableModel(encryptions, selectedEncryptions);
        this.loadEncryptionProtocols(new HashMap<String, Integer>(), new HashMap<String, Boolean>());
        this.encryptionProtocolPreferences = new PriorityTable(this.encryptionConfigurationTableModel, 60);
        this.encryptionConfigurationTableModel.addTableModelListener(this);
        ++c.gridy;
        this.pnlAdvancedSettings.add((Component)((Object)this.encryptionProtocolPreferences), c);
        JLabel lblZrtpOption = new JLabel();
        lblZrtpOption.setBorder(new EmptyBorder(5, 5, 5, 0));
        lblZrtpOption.setText(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.ZRTP_OPTION"));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.pnlAdvancedSettings.add((Component)lblZrtpOption, c);
        c.gridx = 1;
        this.pnlAdvancedSettings.add((Component)new JSeparator(), c);
        this.enableSipZrtpAttribute = new SIPCommCheckBox(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.ENABLE_SIPZRTP_ATTRIBUTE"), this.regform.isSipZrtpAttribute());
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.pnlAdvancedSettings.add((Component)this.enableSipZrtpAttribute, c);
        JLabel lblSDesOption = new JLabel();
        lblSDesOption.setBorder(new EmptyBorder(5, 5, 5, 0));
        lblSDesOption.setText(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.SDES_OPTION"));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.pnlAdvancedSettings.add((Component)lblSDesOption, c);
        c.gridx = 1;
        this.pnlAdvancedSettings.add((Component)new JSeparator(), c);
        JLabel lblCipherInfo = new JLabel();
        lblCipherInfo.setText(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.CIPHER_SUITES"));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.pnlAdvancedSettings.add((Component)lblCipherInfo, c);
        this.cipherModel = new CipherTableModel(this.regform.getSDesCipherSuites());
        this.tabCiphers = new JTable(this.cipherModel);
        this.tabCiphers.setShowGrid(false);
        this.tabCiphers.setTableHeader(null);
        TableColumnModel tableColumnModel = this.tabCiphers.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getMinWidth());
        JScrollPane scrollPane = new JScrollPane(this.tabCiphers);
        scrollPane.setPreferredSize(new Dimension(this.tabCiphers.getWidth(), 100));
        ++c.gridy;
        this.pnlAdvancedSettings.add((Component)scrollPane, c);
        c.gridx = 0;
        c.gridwidth = 1;
        JLabel lblSavpOption = new JLabel();
        lblSavpOption.setBorder(new EmptyBorder(5, 5, 5, 0));
        lblSavpOption.setText(UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.SAVP_OPTION"));
        if (this.displaySavpOtions) {
            ++c.gridy;
            this.pnlAdvancedSettings.add((Component)lblSavpOption, c);
        }
        c.gridx = 1;
        if (this.displaySavpOtions) {
            this.pnlAdvancedSettings.add((Component)new JSeparator(), c);
        }
        this.cboSavpOption = new JComboBox<SavpOption>(new SavpOption[]{new SavpOption(0), new SavpOption(1), new SavpOption(2)});
        c.gridx = 0;
        c.gridwidth = 2;
        c.insets = new Insets(0, 20, 0, 0);
        if (this.displaySavpOtions) {
            ++c.gridy;
            this.pnlAdvancedSettings.add(this.cboSavpOption, c);
        }
    }

    public boolean commitPanel(SecurityAccountRegistration registration) {
        registration.setDefaultEncryption(this.enableDefaultEncryption.isSelected());
        registration.setEncryptionProtocols(this.encryptionConfigurationTableModel.getEncryptionProtocols());
        registration.setEncryptionProtocolStatus(this.encryptionConfigurationTableModel.getEncryptionProtocolStatus());
        registration.setSipZrtpAttribute(this.enableSipZrtpAttribute.isSelected());
        registration.setSavpOption(((SavpOption)this.cboSavpOption.getSelectedItem()).option);
        registration.setSDesCipherSuites(this.cipherModel.getEnabledCiphers());
        return true;
    }

    public void loadAccount(SecurityAccountRegistration securityAccReg) {
        this.enableDefaultEncryption.setSelected(securityAccReg.isDefaultEncryption());
        Map encryptionProtocols = securityAccReg.getEncryptionProtocols();
        Map encryptionProtocolStatus = securityAccReg.getEncryptionProtocolStatus();
        this.loadEncryptionProtocols(encryptionProtocols, encryptionProtocolStatus);
        this.enableSipZrtpAttribute.setSelected(securityAccReg.isSipZrtpAttribute());
        this.cboSavpOption.setSelectedIndex(securityAccReg.getSavpOption());
        this.cipherModel.loadData(securityAccReg.getSDesCipherSuites());
        this.loadStates();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.enableDefaultEncryption) {
            this.loadStates();
        } else if (e.getSource() == this.cmdExpandAdvancedSettings) {
            this.pnlAdvancedSettings.setVisible(!this.pnlAdvancedSettings.isVisible());
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getSource() == this.encryptionConfigurationTableModel) {
            this.loadStates();
        }
    }

    private void loadStates() {
        boolean b = this.enableDefaultEncryption.isSelected();
        this.cboSavpOption.setEnabled(b);
        this.encryptionProtocolPreferences.setEnabled(b);
        this.enableSipZrtpAttribute.setEnabled(b && this.encryptionConfigurationTableModel.isEnabledLabel("ZRTP"));
        this.tabCiphers.setEnabled(b && this.encryptionConfigurationTableModel.isEnabledLabel("SDES"));
    }

    private void loadEncryptionProtocols(Map<String, Integer> encryptionProtocols, Map<String, Boolean> encryptionProtocolStatus) {
        Object[] result = SecurityAccountRegistration.loadEncryptionProtocols(encryptionProtocols, encryptionProtocolStatus);
        String[] encryptions = (String[])result[0];
        boolean[] selectedEncryptions = (boolean[])result[1];
        this.encryptionConfigurationTableModel.init(encryptions, selectedEncryptions);
    }

    private static class CipherTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 0L;
        private List<Entry> data = new ArrayList<Entry>();
        private final String defaultCiphers = UtilActivator.getConfigurationService().getString("net.java.sip.communicator.service.neomedia.SDES_CIPHER_SUITES");

        CipherTableModel(String ciphers) {
            this.loadData(ciphers);
        }

        public void loadData(String ciphers) {
            this.data.clear();
            if (this.defaultCiphers == null) {
                return;
            }
            if (ciphers == null) {
                ciphers = this.defaultCiphers;
            }
            MediaService ms = DesktopUtilActivator.getMediaService();
            SDesControl srtp = (SDesControl)ms.createSrtpControl(SrtpControlType.SDES);
            for (String cipher : srtp.getSupportedCryptoSuites()) {
                this.data.add(new Entry(cipher, ciphers.contains(cipher)));
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Entry e = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return e.enabled;
                }
                case 1: {
                    return e.cipher;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && value instanceof Boolean) {
                Entry e = this.data.get(rowIndex);
                e.enabled = (Boolean)value;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        String getEnabledCiphers() {
            StringBuilder sb = new StringBuilder();
            for (Entry e : this.data) {
                if (!e.enabled.booleanValue()) continue;
                sb.append(e.cipher);
                sb.append(',');
            }
            if (sb.length() == 0) {
                return sb.toString();
            }
            return sb.substring(0, sb.length() - 1);
        }
    }

    private static class Entry {
        String cipher;
        Boolean enabled;

        public Entry(String cipher, boolean enabled) {
            this.cipher = cipher;
            this.enabled = enabled;
        }
    }

    private static class SavpOption {
        int option;

        SavpOption(int option) {
            this.option = option;
        }

        public String toString() {
            return UtilActivator.getResources().getI18NString("plugin.sipaccregwizz.SAVP_OPTION_" + this.option);
        }
    }
}

