/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.skinmanager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.skinmanager.SkinSelector;
import org.osgi.framework.Bundle;

public class SkinSelectorRenderer
extends TransparentPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 0L;
    public static final String SEPARATOR = "separator";
    private JLabel nameLabel = new JLabel();
    private JLabel descriptionLabel = new JLabel();
    JSeparator separator = new JSeparator();

    public SkinSelectorRenderer() {
        super((LayoutManager)new BorderLayout(5, 5));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        if (value.equals(SEPARATOR)) {
            this.add(this.separator, "Center");
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            return this;
        }
        if (value.equals(SkinSelector.ADD_TEXT)) {
            this.add(new JLabel(SkinSelector.ADD_TEXT));
        } else if (value.equals(SkinSelector.DEFAULT_TEXT)) {
            this.initBundleView();
            this.nameLabel.setText(SkinSelector.DEFAULT_TEXT);
            this.descriptionLabel.setText(SkinSelector.DEFAULT_DESCRIPTION_TEXT);
        } else if (value instanceof Bundle) {
            URL res;
            this.initBundleView();
            Bundle bundle = (Bundle)value;
            try {
                res = bundle.getResource("info.properties");
            }
            catch (Throwable ex) {
                res = null;
            }
            String bundleName = "unknown";
            String bundleDescription = "";
            if (res != null) {
                Properties props = new Properties();
                try {
                    props.load(res.openStream());
                    String disp = props.getProperty("display_name");
                    if (disp != null) {
                        bundleName = disp;
                    }
                    if ((disp = props.getProperty("version")) != null) {
                        bundleName = bundleName + " " + disp;
                    }
                    disp = props.getProperty("author");
                    String desc = props.getProperty("description");
                    String bundString = "";
                    if (disp != null) {
                        bundString = disp;
                    }
                    if (desc != null) {
                        if (disp != null) {
                            bundString = bundString + " - ";
                        }
                        bundString = bundString + desc;
                    }
                    if (!bundString.equals("")) {
                        bundleDescription = bundString;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.nameLabel.setText(bundleName.toString());
            this.descriptionLabel.setText(bundleDescription);
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }

    private void initBundleView() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        mainPanel.setOpaque(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.nameLabel.setIconTextGap(2);
        this.nameLabel.setFont(this.getFont().deriveFont(1));
        mainPanel.add((Component)this.nameLabel, "North");
        mainPanel.add((Component)this.descriptionLabel, "South");
        this.add(mainPanel, "North");
    }
}

