/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.contactlist;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.contactlist.MclSlickFixture;
import net.java.sip.communicator.slick.contactlist.MetaContactListServiceLick;

public class TestMetaContact
extends TestCase {
    MclSlickFixture fixture = new MclSlickFixture(((Object)((Object)this)).getClass().getName());
    MetaContact metaContact = null;
    MockContact mockContact = null;

    public TestMetaContact(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        this.mockContact = MetaContactListServiceLick.subLevelContact;
        this.metaContact = this.fixture.metaClService.findMetaContactByContact((Contact)this.mockContact);
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        this.fixture = null;
        super.tearDown();
    }

    public void testGetContact() {
        Contact actualReturn = this.metaContact.getContact(this.mockContact.getAddress(), (ProtocolProviderService)MclSlickFixture.mockProvider);
        TestMetaContact.assertNotNull((String)"getContact() return null.", (Object)actualReturn);
        TestMetaContact.assertSame((String)"getContact() did not return the right proto group.", (Object)this.mockContact, (Object)actualReturn);
    }

    public void testGetContactCount() {
        TestMetaContact.assertEquals((String)"getContactCount()", (int)1, (int)this.metaContact.getContactCount());
    }

    public void testGetContacts() {
        Iterator childContacts = this.metaContact.getContacts();
        TestMetaContact.assertNotNull((String)"getContacts() returned a null iterator.", (Object)childContacts);
        TestMetaContact.assertTrue((String)"getContacts() returned an empty iterator.", (boolean)childContacts.hasNext());
        TestMetaContact.assertSame((String)("The iterator returned by getContacts() (" + this.mockContact.getAddress() + ")did not contain the right mock contact"), (Object)this.mockContact, childContacts.next());
    }

    public void testGetContactsForProvider() {
        Iterator childContacts = this.metaContact.getContactsForProvider((ProtocolProviderService)MclSlickFixture.mockProvider);
        TestMetaContact.assertNotNull((String)"getContactsForProvider() returned a null iterator.", (Object)childContacts);
        TestMetaContact.assertTrue((String)"getContactsForProvider() returned an empty iterator.", (boolean)childContacts.hasNext());
        TestMetaContact.assertSame((String)("The iterator returned by getContactsForProvider() (" + this.mockContact.getAddress() + ")did not contain the right mock contact"), (Object)this.mockContact, childContacts.next());
    }

    public void testGetDefaultContact() {
        Contact actualReturn = this.metaContact.getDefaultContact();
        TestMetaContact.assertNotNull((String)"getDefaultContact() return null.", (Object)actualReturn);
        TestMetaContact.assertSame((String)"getDefaultContact() did not return the right proto group.", (Object)actualReturn, (Object)this.mockContact);
    }

    public void testGetDisplayName() {
        TestMetaContact.assertEquals((String)"getDisplayName()", (String)this.mockContact.getDisplayName(), (String)this.metaContact.getDisplayName());
    }

    public void testGetMetaUID() {
        String metaUID = this.metaContact.getMetaUID();
        TestMetaContact.assertNotNull((String)"getMetaUID() did not seem to return a valid UID", (Object)metaUID);
        TestMetaContact.assertTrue((String)"getMetaUID() did not seem to return a valid UID", (metaUID.trim().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        this.verifyCompareToForAllContactsInGroupAndSubgroups(this.fixture.metaClService.getRoot());
    }

    public void verifyCompareToForAllContactsInGroupAndSubgroups(MetaContactGroup group) {
        Iterator contacts = group.getChildContacts();
        MetaContact previousContact = null;
        int previousContactIsOnlineStatus = 0;
        while (contacts.hasNext()) {
            MetaContact currentContact = (MetaContact)contacts.next();
            Iterator protoContacts = currentContact.getContacts();
            int currentContactIsOnlineStatus = 0;
            while (protoContacts.hasNext()) {
                if (!((Contact)protoContacts.next()).getPresenceStatus().isOnline()) continue;
                currentContactIsOnlineStatus = 1;
            }
            if (previousContact != null) {
                TestMetaContact.assertTrue((String)(previousContact + " with status=" + previousContactIsOnlineStatus + " was wrongfully before " + currentContact + " with status=" + currentContactIsOnlineStatus), (previousContactIsOnlineStatus >= currentContactIsOnlineStatus ? 1 : 0) != 0);
                if (previousContactIsOnlineStatus == currentContactIsOnlineStatus) {
                    TestMetaContact.assertTrue((String)("The display name: " + previousContact.getDisplayName() + " should be considered less than " + currentContact.getDisplayName()), (previousContact.getDisplayName().compareToIgnoreCase(currentContact.getDisplayName()) <= 0 ? 1 : 0) != 0);
                }
            }
            previousContact = currentContact;
            previousContactIsOnlineStatus = currentContactIsOnlineStatus;
        }
        Iterator subgroups = group.getSubgroups();
        while (subgroups.hasNext()) {
            this.verifyCompareToForAllContactsInGroupAndSubgroups((MetaContactGroup)subgroups.next());
        }
    }

    public void testDetails() {
        String name = "test_detail_name";
        String detail_1 = "detail_1";
        String detail_2 = "detail_2";
        String detail_3 = "detail_3";
        this.metaContact.addDetail(name, detail_1);
        List ds = this.metaContact.getDetails(name);
        TestMetaContact.assertTrue((String)"Must contain one detail", (1 == ds.size() ? 1 : 0) != 0);
        TestMetaContact.assertTrue((String)"The result details does not contain the desired", (boolean)ds.contains(detail_1));
        this.metaContact.changeDetail(name, detail_1, detail_2);
        ds = this.metaContact.getDetails(name);
        TestMetaContact.assertEquals((String)"Must contain one detail", (int)1, (int)ds.size());
        TestMetaContact.assertTrue((String)"The result details does not contain the desired", (boolean)ds.contains(detail_2));
        this.metaContact.removeDetail(name, detail_2);
        ds = this.metaContact.getDetails(name);
        TestMetaContact.assertEquals((String)"Must contain no details", (int)0, (int)ds.size());
        this.metaContact.addDetail(name, detail_1);
        this.metaContact.addDetail(name, detail_2);
        this.metaContact.addDetail(name, detail_3);
        ds = this.metaContact.getDetails(name);
        TestMetaContact.assertEquals((String)"Must contain three detail", (int)3, (int)ds.size());
        TestMetaContact.assertTrue((String)"The result details does not contain the desired", (boolean)ds.contains(detail_1));
        TestMetaContact.assertTrue((String)"The result details does not contain the desired", (boolean)ds.contains(detail_2));
        TestMetaContact.assertTrue((String)"The result details does not contain the desired", (boolean)ds.contains(detail_3));
        this.metaContact.removeDetails(name);
        ds = this.metaContact.getDetails(name);
        TestMetaContact.assertEquals((String)"Must contain no details", (int)0, (int)ds.size());
    }
}

