/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.contactlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.sip.communicator.impl.contactlist.ContactlistActivator;
import net.java.sip.communicator.impl.contactlist.MclStorageManager;
import net.java.sip.communicator.impl.contactlist.MetaContactGroupImpl;
import net.java.sip.communicator.impl.contactlist.MetaContactImpl;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListException;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.contactlist.event.MetaContactAvatarUpdateEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactGroupEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.contactlist.event.MetaContactModifiedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactMovedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactPropertyChangeEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactRenamedEvent;
import net.java.sip.communicator.service.contactlist.event.ProtoContactEvent;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactCapabilitiesEvent;
import net.java.sip.communicator.service.protocol.event.ContactCapabilitiesListener;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.util.xml.XMLException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MetaContactListServiceImpl
implements MetaContactListService,
ServiceListener,
ContactPresenceStatusListener,
ContactCapabilitiesListener {
    private static final Logger logger = Logger.getLogger(MetaContactListServiceImpl.class);
    private BundleContext bundleContext = null;
    private final Map<String, ProtocolProviderService> currentlyInstalledProviders = new Hashtable<String, ProtocolProviderService>();
    final MetaContactGroupImpl rootMetaGroup;
    private final ContactListSubscriptionListener clSubscriptionEventHandler = new ContactListSubscriptionListener();
    private final ContactListGroupListener clGroupEventHandler = new ContactListGroupListener();
    public static final int CONTACT_LIST_MODIFICATION_TIMEOUT = 10000;
    private final List<MetaContactListListener> metaContactListListeners = new Vector<MetaContactListListener>();
    private final Hashtable<String, List<ProtocolProviderService>> groupEventIgnoreList = new Hashtable();
    private final Hashtable<String, List<ProtocolProviderService>> contactEventIgnoreList = new Hashtable();
    private final MclStorageManager storageManager = new MclStorageManager();

    public MetaContactListServiceImpl() {
        this.rootMetaGroup = new MetaContactGroupImpl(this, ContactlistActivator.getResources().getI18NString("service.gui.CONTACTS"), "RootMetaContactGroup");
    }

    public void start(BundleContext bc) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting the meta contact list implementation.");
        }
        this.bundleContext = bc;
        try {
            this.storageManager.start(this.bundleContext, this);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed loading the stored contact list.", (Throwable)ex);
        }
        bc.addServiceListener((ServiceListener)this);
        Collection ppsRefs = ServiceUtils.getServiceReferences((BundleContext)bc, ProtocolProviderService.class);
        if (!ppsRefs.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + ppsRefs.size() + " already installed providers."));
            }
            for (ServiceReference ppsRef : ppsRefs) {
                ProtocolProviderService pps = (ProtocolProviderService)bc.getService(ppsRef);
                this.handleProviderAdded(pps);
            }
        }
    }

    public void stop(BundleContext bc) {
        this.storageManager.storeContactListAndStopStorageManager();
        bc.removeServiceListener((ServiceListener)this);
        for (ProtocolProviderService pp : this.currentlyInstalledProviders.values()) {
            OperationSetPersistentPresence opSetPersPresence = (OperationSetPersistentPresence)pp.getOperationSet(OperationSetPersistentPresence.class);
            if (opSetPersPresence != null) {
                opSetPersPresence.removeContactPresenceStatusListener((ContactPresenceStatusListener)this);
                opSetPersPresence.removeSubscriptionListener((SubscriptionListener)this.clSubscriptionEventHandler);
                opSetPersPresence.removeServerStoredGroupChangeListener((ServerStoredGroupListener)this.clGroupEventHandler);
                continue;
            }
            OperationSetPresence opSetPresence = (OperationSetPresence)pp.getOperationSet(OperationSetPresence.class);
            if (opSetPresence == null) continue;
            opSetPresence.removeContactPresenceStatusListener((ContactPresenceStatusListener)this);
            opSetPresence.removeSubscriptionListener((SubscriptionListener)this.clSubscriptionEventHandler);
        }
        this.currentlyInstalledProviders.clear();
        this.storageManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetaContactListListener(MetaContactListListener listener) {
        List<MetaContactListListener> list = this.metaContactListListeners;
        synchronized (list) {
            if (!this.metaContactListListeners.contains(listener)) {
                this.metaContactListListeners.add(listener);
            }
        }
    }

    public void addNewContactToMetaContact(ProtocolProviderService provider, MetaContact metaContact, String contactID) throws MetaContactListException {
        this.addNewContactToMetaContact(provider, metaContact, contactID, true);
    }

    public void addNewContactToMetaContact(ProtocolProviderService provider, MetaContact metaContact, String contactID, boolean fireEvent) throws MetaContactListException {
        MetaContactGroup parentMetaGroup = this.findParentMetaContactGroup(metaContact);
        if (parentMetaGroup == null) {
            throw new MetaContactListException("orphan Contact: " + metaContact, null, 2);
        }
        this.addNewContactToMetaContact(provider, parentMetaGroup, metaContact, contactID, fireEvent);
    }

    private void addNewContactToMetaContact(ProtocolProviderService provider, MetaContactGroup parentMetaGroup, MetaContact metaContact, String contactID, boolean fireEvent) throws MetaContactListException {
        OperationSetPersistentPresence opSetPersPresence = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
        if (opSetPersPresence == null) {
            return;
        }
        if (!(metaContact instanceof MetaContactImpl)) {
            throw new IllegalArgumentException(metaContact + " is not an instance of MetaContactImpl");
        }
        ContactGroup parentProtoGroup = this.resolveProtoPath(provider, (MetaContactGroupImpl)parentMetaGroup);
        if (parentProtoGroup == null) {
            throw new MetaContactListException("Could not obtain proto group parent for " + metaContact, null, 2);
        }
        BlockingSubscriptionEventRetriever evtRetriever = new BlockingSubscriptionEventRetriever(contactID);
        this.addContactToEventIgnoreList(contactID, provider);
        opSetPersPresence.addSubscriptionListener((SubscriptionListener)evtRetriever);
        opSetPersPresence.addServerStoredGroupChangeListener((ServerStoredGroupListener)evtRetriever);
        try {
            if (parentMetaGroup.equals(this.rootMetaGroup)) {
                opSetPersPresence.subscribe(contactID);
            } else {
                opSetPersPresence.subscribe(parentProtoGroup, contactID);
            }
            evtRetriever.waitForEvent(10000L);
        }
        catch (OperationFailedException ex) {
            if (ex.getErrorCode() == 5) {
                throw new MetaContactListException("failed to create contact " + contactID, (Exception)((Object)ex), 3);
            }
            if (ex.getErrorCode() == 18) {
                throw new MetaContactListException("failed to create contact " + contactID, (Exception)((Object)ex), 8);
            }
            throw new MetaContactListException("failed to create contact " + contactID, (Exception)((Object)ex), 2);
        }
        catch (Exception ex) {
            throw new MetaContactListException("failed to create contact " + contactID, ex, 2);
        }
        finally {
            this.removeContactFromEventIgnoreList(contactID, provider);
            opSetPersPresence.removeSubscriptionListener((SubscriptionListener)evtRetriever);
        }
        if (evtRetriever.evt == null) {
            throw new MetaContactListException("Failed to create a contact with address: " + contactID, null, 2);
        }
        if (evtRetriever.evt instanceof SubscriptionEvent && ((SubscriptionEvent)evtRetriever.evt).getEventID() == 3) {
            throw new MetaContactListException("Failed to create a contact with address: " + contactID + " " + ((SubscriptionEvent)evtRetriever.evt).getErrorReason(), null, 5);
        }
        ((MetaContactImpl)metaContact).addProtoContact(evtRetriever.sourceContact);
        if (fireEvent) {
            this.fireProtoContactEvent(evtRetriever.sourceContact, "ProtoContactAdded", null, metaContact);
        }
        ((MetaContactGroupImpl)parentMetaGroup).addMetaContact((MetaContactImpl)metaContact);
    }

    private ContactGroup resolveProtoPath(ProtocolProviderService protoProvider, MetaContactGroupImpl metaGroup) {
        Iterator<ContactGroup> contactGroupsForProv = metaGroup.getContactGroupsForProvider(protoProvider);
        if (contactGroupsForProv.hasNext()) {
            return contactGroupsForProv.next();
        }
        MetaContactGroupImpl parentMetaGroup = (MetaContactGroupImpl)this.findParentMetaContactGroup(metaGroup);
        if (parentMetaGroup == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolve failed at group" + metaGroup));
            }
            throw new NullPointerException("Internal Error. Orphan group.");
        }
        OperationSetPersistentPresence opSetPersPresence = (OperationSetPersistentPresence)protoProvider.getOperationSet(OperationSetPersistentPresence.class);
        if (opSetPersPresence == null) {
            return null;
        }
        ContactGroup parentProtoGroup = parentMetaGroup.getParentMetaContactGroup() == null ? opSetPersPresence.getServerStoredContactListRoot() : this.resolveProtoPath(protoProvider, parentMetaGroup);
        BlockingGroupEventRetriever evtRetriever = new BlockingGroupEventRetriever(metaGroup.getGroupName());
        opSetPersPresence.addServerStoredGroupChangeListener((ServerStoredGroupListener)evtRetriever);
        this.addGroupToEventIgnoreList(metaGroup.getGroupName(), protoProvider);
        try {
            opSetPersPresence.createServerStoredContactGroup(parentProtoGroup, metaGroup.getGroupName());
            evtRetriever.waitForEvent(10000L);
        }
        catch (Exception ex) {
            throw new MetaContactListException("failed to create contact group " + metaGroup.getGroupName(), ex, 2);
        }
        finally {
            this.removeGroupFromEventIgnoreList(metaGroup.getGroupName(), protoProvider);
            opSetPersPresence.removeServerStoredGroupChangeListener((ServerStoredGroupListener)evtRetriever);
        }
        if (evtRetriever.evt == null) {
            throw new MetaContactListException("Failed to create a proto group named: " + metaGroup.getGroupName(), null, 2);
        }
        metaGroup.addProtoGroup(evtRetriever.evt.getSourceGroup());
        this.fireMetaContactGroupEvent(metaGroup, evtRetriever.evt.getSourceProvider(), evtRetriever.evt.getSourceGroup(), 6);
        return evtRetriever.evt.getSourceGroup();
    }

    public MetaContactGroup findParentMetaContactGroup(MetaContactGroup child) {
        return this.findParentMetaContactGroup(this.rootMetaGroup, child);
    }

    private MetaContactGroup findParentMetaContactGroup(MetaContactGroupImpl root, MetaContactGroup child) {
        return child.getParentMetaContactGroup();
    }

    public MetaContactGroup findParentMetaContactGroup(MetaContact child) {
        if (!(child instanceof MetaContactImpl)) {
            throw new IllegalArgumentException(child + " is not a MetaContactImpl instance.");
        }
        return ((MetaContactImpl)child).getParentGroup();
    }

    public MetaContact createMetaContact(ProtocolProviderService provider, MetaContactGroup metaContactGroup, String contactID) throws MetaContactListException {
        if (!(metaContactGroup instanceof MetaContactGroupImpl)) {
            throw new IllegalArgumentException(metaContactGroup + " is not an instance of MetaContactGroupImpl");
        }
        MetaContactImpl newMetaContact = new MetaContactImpl();
        this.addNewContactToMetaContact(provider, metaContactGroup, newMetaContact, contactID, false);
        this.fireMetaContactEvent(newMetaContact, this.findParentMetaContactGroup(newMetaContact), 1);
        return newMetaContact;
    }

    public MetaContactGroup createMetaContactGroup(MetaContactGroup parent, String groupName) throws MetaContactListException {
        if (!(parent instanceof MetaContactGroupImpl)) {
            throw new IllegalArgumentException(parent + " is not an instance of MetaContactGroupImpl");
        }
        Iterator subgroups = parent.getSubgroups();
        while (subgroups.hasNext()) {
            MetaContactGroup group = (MetaContactGroup)subgroups.next();
            if (!group.getGroupName().equals(groupName)) continue;
            throw new MetaContactListException("Parent " + parent.getGroupName() + " already contains a group called " + groupName, (Exception)new CloneNotSupportedException("just testing nested exc-s"), 4);
        }
        MetaContactGroupImpl newMetaGroup = new MetaContactGroupImpl(this, groupName);
        ((MetaContactGroupImpl)parent).addSubgroup(newMetaGroup);
        this.fireMetaContactGroupEvent(newMetaGroup, null, null, 1);
        return newMetaGroup;
    }

    public void renameMetaContactGroup(MetaContactGroup group, String newGroupName) {
        ((MetaContactGroupImpl)group).setGroupName(newGroupName);
        Iterator groups = group.getContactGroups();
        while (groups.hasNext()) {
            ContactGroup protoGroup = (ContactGroup)groups.next();
            OperationSetPersistentPresence opSetPresence = (OperationSetPersistentPresence)protoGroup.getProtocolProvider().getOperationSet(OperationSetPersistentPresence.class);
            if (opSetPresence == null) continue;
            try {
                opSetPresence.renameServerStoredContactGroup(protoGroup, newGroupName);
            }
            catch (Throwable t) {
                logger.error((Object)("Error renaming protocol group: " + protoGroup), t);
            }
        }
        this.fireMetaContactGroupEvent(group, null, null, 7);
    }

    public MetaContactGroup getRoot() {
        return this.rootMetaGroup;
    }

    public void renameMetaContact(MetaContact metaContact, String newDisplayName) throws IllegalArgumentException {
        this.renameMetaContact(metaContact, newDisplayName, true);
    }

    private void renameMetaContact(MetaContact metaContact, String newDisplayName, boolean isUserDefined) throws IllegalArgumentException {
        if (!(metaContact instanceof MetaContactImpl)) {
            throw new IllegalArgumentException(metaContact + " is not a MetaContactImpl instance.");
        }
        String oldDisplayName = metaContact.getDisplayName();
        ((MetaContactImpl)metaContact).setDisplayName(newDisplayName);
        if (isUserDefined) {
            ((MetaContactImpl)metaContact).setDisplayNameUserDefined(true);
        }
        Iterator contacts = metaContact.getContacts();
        while (contacts.hasNext()) {
            Contact protoContact = (Contact)contacts.next();
            OperationSetPersistentPresence opSetPresence = (OperationSetPersistentPresence)protoContact.getProtocolProvider().getOperationSet(OperationSetPersistentPresence.class);
            if (opSetPresence == null) continue;
            try {
                opSetPresence.setDisplayName(protoContact, newDisplayName);
            }
            catch (Throwable t) {
                logger.error((Object)("Error renaming protocol contact: " + protoContact), t);
            }
        }
        this.fireMetaContactEvent((MetaContactPropertyChangeEvent)new MetaContactRenamedEvent(metaContact, oldDisplayName, newDisplayName));
        this.fireMetaContactGroupEvent(this.findParentMetaContactGroup(metaContact), null, null, 4);
    }

    public void clearUserDefinedDisplayName(MetaContact metaContact) throws IllegalArgumentException {
        if (!(metaContact instanceof MetaContactImpl)) {
            throw new IllegalArgumentException(metaContact + " is not a MetaContactImpl instance.");
        }
        ((MetaContactImpl)metaContact).setDisplayNameUserDefined(false);
        if (metaContact.getContactCount() == 1) {
            this.renameMetaContact(metaContact, metaContact.getDefaultContact().getDisplayName(), false);
        } else {
            this.fireMetaContactEvent((MetaContactPropertyChangeEvent)new MetaContactRenamedEvent(metaContact, metaContact.getDisplayName(), metaContact.getDisplayName()));
        }
    }

    public void changeMetaContactAvatar(MetaContact metaContact, Contact protoContact, byte[] newAvatar) throws IllegalArgumentException {
        if (!(metaContact instanceof MetaContactImpl)) {
            throw new IllegalArgumentException(metaContact + " is not a MetaContactImpl instance.");
        }
        byte[] oldAvatar = metaContact.getAvatar(true);
        ((MetaContactImpl)metaContact).cacheAvatar(protoContact, newAvatar);
        this.fireMetaContactEvent((MetaContactPropertyChangeEvent)new MetaContactAvatarUpdateEvent(metaContact, oldAvatar, newAvatar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveContact(Contact contact, MetaContactGroup newParentMetaGroup) throws MetaContactListException {
        if (contact.getPersistableAddress() == null) {
            logger.info((Object)"Contact cannot be moved! This contact doesn't have persistant address.");
            return;
        }
        if (contact.getPersistableAddress() == null) {
            logger.info((Object)"Contact cannot be moved! This contact doesn't have persistant address.");
            return;
        }
        ProtocolProviderService provider = contact.getProtocolProvider();
        OperationSetMultiUserChat opSetMUC = (OperationSetMultiUserChat)provider.getOperationSet(OperationSetMultiUserChat.class);
        if (opSetMUC != null && opSetMUC.isPrivateMessagingContact(contact.getAddress())) {
            MetaContactImpl metaContactImpl = new MetaContactImpl();
            MetaContactGroupImpl newParentMetaGroupImpl = (MetaContactGroupImpl)newParentMetaGroup;
            newParentMetaGroupImpl.addMetaContact(metaContactImpl);
            this.fireMetaContactEvent(metaContactImpl, newParentMetaGroupImpl, 1);
            this.addNewContactToMetaContact(provider, metaContactImpl, contact.getPersistableAddress());
            return;
        }
        OperationSetPersistentPresence opSetPresence = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
        if (opSetPresence == null) {
            // empty if block
        }
        MetaContactImpl currentParentMetaContact = (MetaContactImpl)this.findMetaContactByContact(contact);
        ContactGroup parentProtoGroup = this.resolveProtoPath(contact.getProtocolProvider(), (MetaContactGroupImpl)newParentMetaGroup);
        try {
            if (contact.getParentContactGroup() != parentProtoGroup && opSetPresence != null) {
                opSetPresence.moveContactToGroup(contact, parentProtoGroup);
            }
            currentParentMetaContact.removeProtoContact(contact);
        }
        catch (OperationFailedException ex) {
            throw new MetaContactListException(ex.getMessage(), 7);
        }
        MetaContactImpl metaContactImpl = null;
        Contact contact2 = contact;
        synchronized (contact2) {
            MetaContact checkContact = this.findMetaContactByContact(contact);
            if (checkContact == null) {
                metaContactImpl = new MetaContactImpl();
                ((MetaContactGroupImpl)newParentMetaGroup).addMetaContact(metaContactImpl);
                metaContactImpl.addProtoContact(contact);
            }
        }
        if (metaContactImpl != null) {
            this.fireMetaContactEvent(metaContactImpl, newParentMetaGroup, 1);
            this.fireProtoContactEvent(contact, "ProtoContactMoved", currentParentMetaContact, metaContactImpl);
        }
        if (currentParentMetaContact.getContactCount() == 0) {
            MetaContactGroupImpl parentMetaGroup = currentParentMetaContact.getParentGroup();
            parentMetaGroup.removeMetaContact(currentParentMetaContact);
            this.fireMetaContactEvent(currentParentMetaContact, parentMetaGroup, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveContact(Contact contact, MetaContact newParentMetaContact) throws MetaContactListException {
        if (contact.getPersistableAddress() == null) {
            logger.info((Object)"Contact cannot be moved! This contact doesn't have persistant address.");
            return;
        }
        ProtocolProviderService provider = contact.getProtocolProvider();
        OperationSetMultiUserChat opSetMUC = (OperationSetMultiUserChat)provider.getOperationSet(OperationSetMultiUserChat.class);
        if (opSetMUC != null && opSetMUC.isPrivateMessagingContact(contact.getAddress())) {
            this.addNewContactToMetaContact(provider, newParentMetaContact, contact.getPersistableAddress());
            return;
        }
        OperationSetPersistentPresence opSetPresence = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
        if (opSetPresence == null) {
            // empty if block
        }
        if (!(newParentMetaContact instanceof MetaContactImpl)) {
            throw new IllegalArgumentException(newParentMetaContact + " is not a MetaContactImpl instance.");
        }
        MetaContactImpl currentParentMetaContact = (MetaContactImpl)this.findMetaContactByContact(contact);
        MetaContactGroup newParentGroup = this.findParentMetaContactGroup(newParentMetaContact);
        ContactGroup parentProtoGroup = this.resolveProtoPath(contact.getProtocolProvider(), (MetaContactGroupImpl)newParentGroup);
        try {
            if (contact.getParentContactGroup() != parentProtoGroup && opSetPresence != null) {
                opSetPresence.moveContactToGroup(contact, parentProtoGroup);
            }
            currentParentMetaContact.removeProtoContact(contact);
        }
        catch (OperationFailedException ex) {
            throw new MetaContactListException(ex.getMessage(), 7);
        }
        Contact ex = contact;
        synchronized (ex) {
            MetaContact checkContact = this.findMetaContactByContact(contact);
            if (checkContact == null) {
                ((MetaContactImpl)newParentMetaContact).addProtoContact(contact);
            }
        }
        if (newParentMetaContact.containsContact(contact)) {
            this.fireProtoContactEvent(contact, "ProtoContactMoved", currentParentMetaContact, newParentMetaContact);
        }
        if (currentParentMetaContact.getContactCount() == 0) {
            MetaContactGroupImpl parentMetaGroup = currentParentMetaContact.getParentGroup();
            parentMetaGroup.removeMetaContact(currentParentMetaContact);
            this.fireMetaContactEvent(currentParentMetaContact, parentMetaGroup, 2);
        }
    }

    public void moveMetaContact(MetaContact metaContact, MetaContactGroup newMetaGroup) throws MetaContactListException, IllegalArgumentException {
        if (!(newMetaGroup instanceof MetaContactGroupImpl)) {
            throw new IllegalArgumentException(newMetaGroup + " is not a MetaContactGroupImpl instance");
        }
        if (!(metaContact instanceof MetaContactImpl)) {
            throw new IllegalArgumentException(metaContact + " is not a MetaContactImpl instance");
        }
        MetaContactGroupImpl currentParent = (MetaContactGroupImpl)this.findParentMetaContactGroup(metaContact);
        if (currentParent != null) {
            currentParent.removeMetaContact((MetaContactImpl)metaContact);
        }
        ((MetaContactGroupImpl)newMetaGroup).addMetaContact((MetaContactImpl)metaContact);
        try {
            Iterator contacts = metaContact.getContacts();
            while (contacts.hasNext()) {
                Contact protoContact = (Contact)contacts.next();
                ContactGroup protoGroup = this.resolveProtoPath(protoContact.getProtocolProvider(), (MetaContactGroupImpl)newMetaGroup);
                OperationSetPersistentPresence opSetPresence = (OperationSetPersistentPresence)protoContact.getProtocolProvider().getOperationSet(OperationSetPersistentPresence.class);
                if (opSetPresence == null) continue;
                if (newMetaGroup.equals(this.getRoot())) {
                    opSetPresence.moveContactToGroup(protoContact, opSetPresence.getServerStoredContactListRoot());
                    continue;
                }
                opSetPresence.moveContactToGroup(protoContact, protoGroup);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot move contact", (Throwable)ex);
            ((MetaContactGroupImpl)newMetaGroup).removeMetaContact((MetaContactImpl)metaContact);
            currentParent.addMetaContact((MetaContactImpl)metaContact);
            throw new MetaContactListException(ex.getMessage(), 7);
        }
        this.fireMetaContactEvent((MetaContactPropertyChangeEvent)new MetaContactMovedEvent(metaContact, (MetaContactGroup)currentParent, newMetaGroup));
    }

    public void removeContact(Contact contact) throws MetaContactListException {
        OperationSetPresence opSetPresence = (OperationSetPresence)contact.getProtocolProvider().getOperationSet(OperationSetPresence.class);
        if (opSetPresence == null && (opSetPresence = (OperationSetPresence)contact.getProtocolProvider().getOperationSet(OperationSetPersistentPresence.class)) == null) {
            throw new IllegalStateException("Cannot remove a contact from a provider with no presence operation set.");
        }
        try {
            opSetPresence.unsubscribe(contact);
        }
        catch (Exception ex) {
            String errorTxt = "Failed to remove " + contact + " from its protocol provider. ";
            if (ex instanceof OperationFailedException) {
                errorTxt = errorTxt + ex.getMessage();
            }
            throw new MetaContactListException(errorTxt, ex, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaContactListListener(MetaContactListListener listener) {
        List<MetaContactListListener> list = this.metaContactListListeners;
        synchronized (list) {
            this.metaContactListListeners.remove(listener);
        }
    }

    public void removeMetaContact(MetaContact metaContact) throws MetaContactListException {
        Iterator protoContactsIter = metaContact.getContacts();
        while (protoContactsIter.hasNext()) {
            this.removeContact((Contact)protoContactsIter.next());
        }
    }

    public void removeMetaContactGroup(MetaContactGroup groupToRemove) throws MetaContactListException {
        if (!(groupToRemove instanceof MetaContactGroupImpl)) {
            throw new IllegalArgumentException(groupToRemove + " is not an instance of MetaContactGroupImpl");
        }
        try {
            Iterator protoGroups = groupToRemove.getContactGroups();
            while (protoGroups.hasNext()) {
                ContactGroup protoGroup = (ContactGroup)protoGroups.next();
                OperationSetPersistentPresence opSetPersPresence = (OperationSetPersistentPresence)protoGroup.getProtocolProvider().getOperationSet(OperationSetPersistentPresence.class);
                if (opSetPersPresence == null) {
                    return;
                }
                opSetPersPresence.removeServerStoredContactGroup(protoGroup);
            }
        }
        catch (Exception ex) {
            throw new MetaContactListException(ex.getMessage(), 6);
        }
        MetaContactGroupImpl parentMetaGroup = (MetaContactGroupImpl)this.findParentMetaContactGroup(groupToRemove);
        parentMetaGroup.removeSubgroup(groupToRemove);
        this.fireMetaContactGroupEvent(groupToRemove, null, null, 2);
    }

    public void removeContactGroupFromMetaContactGroup(MetaContactGroupImpl metaContainer, ContactGroup groupToRemove, ProtocolProviderService sourceProvider) {
        if (metaContainer == null) {
            logger.warn((Object)("No meta container found, when trying to remove group: " + groupToRemove));
            return;
        }
        this.locallyRemoveAllContactsForProvider(metaContainer, groupToRemove);
        this.fireMetaContactGroupEvent(metaContainer, sourceProvider, groupToRemove, 3);
    }

    public void purgeLocallyStoredContactListCopy() {
        this.storageManager.storeContactListAndStopStorageManager();
        this.storageManager.removeContactListFile();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Removed meta contact list storage file.");
        }
    }

    private void locallyRemoveAllContactsForProvider(MetaContactGroupImpl parentMetaGroup, ContactGroup groupToRemove) {
        Iterator<MetaContact> childrenContactsIter = parentMetaGroup.getChildContacts();
        while (childrenContactsIter.hasNext()) {
            MetaContactImpl child = (MetaContactImpl)childrenContactsIter.next();
            Iterator<Contact> contactsToRemove = child.getContactsForContactGroup(groupToRemove);
            child.removeContactsForGroup(groupToRemove);
            if (child.getContactCount() == 0) {
                parentMetaGroup.removeMetaContact(child);
                this.fireMetaContactEvent(child, parentMetaGroup, 2);
                continue;
            }
            while (contactsToRemove.hasNext()) {
                this.fireProtoContactEvent(contactsToRemove.next(), "ProtoContactRemoved", child, null);
            }
        }
        Iterator<MetaContactGroup> subgroupsIter = parentMetaGroup.getSubgroups();
        while (subgroupsIter.hasNext()) {
            MetaContactGroupImpl subMetaGroup = (MetaContactGroupImpl)subgroupsIter.next();
            Iterator<ContactGroup> contactGroups = subMetaGroup.getContactGroups();
            ContactGroup protoGroup = null;
            while (contactGroups.hasNext()) {
                protoGroup = contactGroups.next();
                if (groupToRemove != protoGroup.getParentContactGroup()) continue;
                this.locallyRemoveAllContactsForProvider(subMetaGroup, protoGroup);
            }
            if (subMetaGroup.countSubgroups() != 0 || subMetaGroup.countChildContacts() != 0 || subMetaGroup.countContactGroups() != 0) continue;
            parentMetaGroup.removeSubgroup(subMetaGroup);
            this.fireMetaContactGroupEvent(subMetaGroup, groupToRemove.getProtocolProvider(), protoGroup, 2);
        }
        parentMetaGroup.removeProtoGroup(groupToRemove);
    }

    public MetaContactGroup findMetaContactGroupByContactGroup(ContactGroup contactGroup) {
        return this.rootMetaGroup.findMetaContactGroupByContactGroup(contactGroup);
    }

    public MetaContact findMetaContactByContact(Contact contact) {
        return this.rootMetaGroup.findMetaContactByContact(contact);
    }

    public MetaContact findMetaContactByContact(String contactAddress, String accountID) {
        return this.rootMetaGroup.findMetaContactByContact(contactAddress, accountID);
    }

    public MetaContact findMetaContactByMetaUID(String metaContactID) {
        return this.rootMetaGroup.findMetaContactByMetaUID(metaContactID);
    }

    public MetaContactGroup findMetaContactGroupByMetaUID(String metaGroupID) {
        return this.rootMetaGroup.findMetaContactGroupByMetaUID(metaGroupID);
    }

    public Iterator<MetaContact> findAllMetaContactsForProvider(ProtocolProviderService protocolProvider) {
        ArrayList<MetaContact> resultList = new ArrayList<MetaContact>();
        this.findAllMetaContactsForProvider(protocolProvider, this.rootMetaGroup, resultList);
        return resultList.iterator();
    }

    public Iterator<MetaContact> findAllMetaContactsForProvider(ProtocolProviderService protocolProvider, MetaContactGroup metaContactGroup) {
        LinkedList<MetaContact> resultList = new LinkedList<MetaContact>();
        this.findAllMetaContactsForProvider(protocolProvider, metaContactGroup, resultList);
        return resultList.iterator();
    }

    public Iterator<MetaContact> findAllMetaContactsForAddress(String contactAddress) {
        LinkedList<MetaContact> resultList = new LinkedList<MetaContact>();
        this.findAllMetaContactsForAddress(this.rootMetaGroup, contactAddress, resultList);
        return resultList.iterator();
    }

    private void findAllMetaContactsForAddress(MetaContactGroup metaContactGroup, String contactAddress, List<MetaContact> resultList) {
        Iterator childContacts = metaContactGroup.getChildContacts();
        while (childContacts.hasNext()) {
            MetaContact metaContact = (MetaContact)childContacts.next();
            Iterator protocolContacts = metaContact.getContacts();
            while (protocolContacts.hasNext()) {
                Contact protocolContact = (Contact)protocolContacts.next();
                if (!protocolContact.getAddress().equals(contactAddress) && !protocolContact.getDisplayName().equals(contactAddress)) continue;
                resultList.add(metaContact);
            }
        }
        Iterator subGroups = metaContactGroup.getSubgroups();
        while (subGroups.hasNext()) {
            MetaContactGroup subGroup = (MetaContactGroup)subGroups.next();
            Iterator protocolSubgroups = subGroup.getContactGroups();
            if (!protocolSubgroups.hasNext()) continue;
            this.findAllMetaContactsForAddress(subGroup, contactAddress, resultList);
        }
    }

    private void findAllMetaContactsForProvider(ProtocolProviderService protocolProvider, MetaContactGroup metaContactGroup, List<MetaContact> resultList) {
        Iterator childContacts = metaContactGroup.getChildContacts();
        while (childContacts.hasNext()) {
            MetaContact metaContact = (MetaContact)childContacts.next();
            Iterator protocolContacts = metaContact.getContactsForProvider(protocolProvider);
            if (!protocolContacts.hasNext()) continue;
            resultList.add(metaContact);
        }
        Iterator subGroups = metaContactGroup.getSubgroups();
        while (subGroups.hasNext()) {
            MetaContactGroup subGroup = (MetaContactGroup)subGroups.next();
            Iterator protocolSubgroups = subGroup.getContactGroupsForProvider(protocolProvider);
            if (!protocolSubgroups.hasNext()) continue;
            this.findAllMetaContactsForProvider(protocolProvider, subGroup, resultList);
        }
    }

    private void synchronizeOpSetWithLocalContactList(OperationSetPersistentPresence presenceOpSet) {
        ContactGroup rootProtoGroup = presenceOpSet.getServerStoredContactListRoot();
        if (rootProtoGroup != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("subgroups: " + rootProtoGroup.countSubgroups()));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("child contacts: " + rootProtoGroup.countContacts()));
            }
            this.addContactGroupToMetaGroup(rootProtoGroup, this.rootMetaGroup, true);
        }
        presenceOpSet.addSubscriptionListener((SubscriptionListener)this.clSubscriptionEventHandler);
        presenceOpSet.addServerStoredGroupChangeListener((ServerStoredGroupListener)this.clGroupEventHandler);
    }

    private void addContactGroupToMetaGroup(ContactGroup protoGroup, MetaContactGroupImpl metaGroup, boolean fireEvents) {
        metaGroup.addProtoGroup(protoGroup);
        Iterator subgroupsIter = protoGroup.subgroups();
        while (subgroupsIter.hasNext()) {
            ContactGroup group = (ContactGroup)subgroupsIter.next();
            if (metaGroup.findMetaContactGroupByContactGroup(group) != null) continue;
            MetaContactGroupImpl newMetaGroup = new MetaContactGroupImpl(this, group.getGroupName());
            metaGroup.addSubgroup(newMetaGroup);
            this.addContactGroupToMetaGroup(group, newMetaGroup, false);
            if (!fireEvents) continue;
            this.fireMetaContactGroupEvent(newMetaGroup, group.getProtocolProvider(), group, 1);
        }
        Iterator contactsIter = protoGroup.contacts();
        while (contactsIter.hasNext()) {
            Contact contact = (Contact)contactsIter.next();
            if (metaGroup.findMetaContactByContact(contact) != null) continue;
            MetaContactImpl newMetaContact = new MetaContactImpl();
            newMetaContact.addProtoContact(contact);
            metaGroup.addMetaContact(newMetaContact);
            if (!fireEvents) continue;
            this.fireMetaContactEvent(newMetaContact, metaGroup, 1);
        }
    }

    private synchronized void handleProviderAdded(ProtocolProviderService provider) {
        OperationSetContactCapabilities capOpSet;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding protocol provider " + provider.getAccountID().getAccountUniqueID()));
        }
        OperationSetPersistentPresence opSetPersPresence = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
        this.currentlyInstalledProviders.put(provider.getAccountID().getAccountUniqueID(), provider);
        if (opSetPersPresence != null) {
            try {
                this.storageManager.extractContactsForAccount(provider.getAccountID().getAccountUniqueID());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("All contacts loaded for account " + provider.getAccountID().getAccountUniqueID()));
                }
            }
            catch (XMLException exc) {
                logger.error((Object)("Failed to load contacts for account " + provider.getAccountID().getAccountUniqueID()), (Throwable)exc);
            }
            this.synchronizeOpSetWithLocalContactList(opSetPersPresence);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Service did not have a pers. pres. op. set.");
        }
        if (opSetPersPresence != null) {
            opSetPersPresence.addContactPresenceStatusListener((ContactPresenceStatusListener)this);
        }
        if ((capOpSet = (OperationSetContactCapabilities)provider.getOperationSet(OperationSetContactCapabilities.class)) != null) {
            capOpSet.addContactCapabilitiesListener((ContactCapabilitiesListener)this);
        }
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        OperationSetContactCapabilities capOpSet;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing protocol provider " + provider));
        }
        this.currentlyInstalledProviders.remove(provider.getAccountID().getAccountUniqueID());
        OperationSetPersistentPresence persPresOpSet = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
        if (persPresOpSet != null) {
            persPresOpSet.removeContactPresenceStatusListener((ContactPresenceStatusListener)this);
            persPresOpSet.removeSubscriptionListener((SubscriptionListener)this.clSubscriptionEventHandler);
            persPresOpSet.removeServerStoredGroupChangeListener((ServerStoredGroupListener)this.clGroupEventHandler);
            ContactGroup rootGroup = persPresOpSet.getServerStoredContactListRoot();
            Iterator subgroups = rootGroup.subgroups();
            while (subgroups.hasNext()) {
                ContactGroup group = (ContactGroup)subgroups.next();
                this.removeContactGroupFromMetaContactGroup((MetaContactGroupImpl)this.findMetaContactGroupByContactGroup(group), group, provider);
            }
            this.removeContactGroupFromMetaContactGroup(this.rootMetaGroup, rootGroup, provider);
        }
        if ((capOpSet = (OperationSetContactCapabilities)provider.getOperationSet(OperationSetContactCapabilities.class)) != null) {
            capOpSet.removeContactCapabilitiesListener((ContactCapabilitiesListener)this);
        }
    }

    private void addGroupToEventIgnoreList(String group, ProtocolProviderService ownerProvider) {
        if (this.isGroupInEventIgnoreList(group, ownerProvider)) {
            return;
        }
        List<ProtocolProviderService> existingProvList = this.groupEventIgnoreList.get(group);
        if (existingProvList == null) {
            existingProvList = new LinkedList<ProtocolProviderService>();
        }
        existingProvList.add(ownerProvider);
        this.groupEventIgnoreList.put(group, existingProvList);
    }

    private boolean isGroupInEventIgnoreList(String group, ProtocolProviderService ownerProvider) {
        List<ProtocolProviderService> existingProvList = this.groupEventIgnoreList.get(group);
        return existingProvList != null && existingProvList.contains(ownerProvider);
    }

    private void removeGroupFromEventIgnoreList(String group, ProtocolProviderService ownerProvider) {
        if (!this.isGroupInEventIgnoreList(group, ownerProvider)) {
            return;
        }
        List<ProtocolProviderService> existingProvList = this.groupEventIgnoreList.get(group);
        if (existingProvList.size() < 1) {
            this.groupEventIgnoreList.remove(group);
        } else {
            existingProvList.remove(ownerProvider);
        }
    }

    private void addContactToEventIgnoreList(String contact, ProtocolProviderService ownerProvider) {
        if (this.isContactInEventIgnoreList(contact, ownerProvider)) {
            return;
        }
        List<ProtocolProviderService> existingProvList = this.contactEventIgnoreList.get(contact);
        if (existingProvList == null) {
            existingProvList = new LinkedList<ProtocolProviderService>();
        }
        existingProvList.add(ownerProvider);
        this.contactEventIgnoreList.put(contact, existingProvList);
    }

    private boolean isContactInEventIgnoreList(String contact, ProtocolProviderService ownerProvider) {
        List<ProtocolProviderService> existingProvList = this.contactEventIgnoreList.get(contact);
        return existingProvList != null && existingProvList.contains(ownerProvider);
    }

    private boolean isContactInEventIgnoreList(Contact contact, ProtocolProviderService ownerProvider) {
        for (Map.Entry<String, List<ProtocolProviderService>> contactEventIgnoreEntry : this.contactEventIgnoreList.entrySet()) {
            String contactAddress = contactEventIgnoreEntry.getKey();
            if (!contact.getAddress().equals(contactAddress) && !contact.equals(contactAddress)) continue;
            List<ProtocolProviderService> existingProvList = contactEventIgnoreEntry.getValue();
            return existingProvList != null && existingProvList.contains(ownerProvider);
        }
        return false;
    }

    private void removeContactFromEventIgnoreList(String contact, ProtocolProviderService ownerProvider) {
        if (!this.isContactInEventIgnoreList(contact, ownerProvider)) {
            return;
        }
        List<ProtocolProviderService> existingProvList = this.contactEventIgnoreList.get(contact);
        if (existingProvList.size() < 1) {
            this.groupEventIgnoreList.remove(contact);
        } else {
            existingProvList.remove(ownerProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ServiceReference[] allBundleServices;
        Object sService = this.bundleContext.getService(event.getServiceReference());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a service event for: " + sService.getClass().getName()));
        }
        if (!(sService instanceof ProtocolProviderService)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Service is a protocol provider.");
        }
        ProtocolProviderService provider = (ProtocolProviderService)sService;
        ProtocolProviderFactory sourceFactory = null;
        for (ServiceReference bundleServiceRef : allBundleServices = event.getServiceReference().getBundle().getRegisteredServices()) {
            Object service = this.bundleContext.getService(bundleServiceRef);
            if (!(service instanceof ProtocolProviderFactory)) continue;
            sourceFactory = (ProtocolProviderFactory)service;
            break;
        }
        if (event.getType() == 1) {
            String servRefMask;
            String providerMask;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Handling registration of a new Protocol Provider.");
            }
            if (!((providerMask = System.getProperty("net.java.sip.communicator.service.contactlist.PROVIDER_MASK")) == null || providerMask.trim().length() <= 0 || (servRefMask = (String)event.getServiceReference().getProperty("net.java.sip.communicator.service.contactlist.PROVIDER_MASK")) != null && servRefMask.equals(providerMask))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Ignoing masked provider: " + provider.getAccountID()));
                }
                return;
            }
            if (sourceFactory != null && this.currentlyInstalledProviders.containsKey(provider.getAccountID().getAccountUniqueID()) && logger.isDebugEnabled()) {
                logger.debug((Object)("An already installed account: " + provider.getAccountID() + ". Modifying it."));
            }
            this.handleProviderAdded((ProtocolProviderService)sService);
        } else if (event.getType() == 4) {
            if (sourceFactory == null) {
                return;
            }
            AccountID accountID = provider.getAccountID();
            if (ContactlistActivator.getAccountManager().getStoredAccounts().contains(accountID)) {
                MetaContactListServiceImpl metaContactListServiceImpl = this;
                synchronized (metaContactListServiceImpl) {
                    this.removeMetaContactListListener(this.storageManager);
                    this.handleProviderRemoved((ProtocolProviderService)sService);
                    this.addMetaContactListListener(this.storageManager);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Account uninstalled. acc.id=" + provider.getAccountID() + ". Removing from meta contact list."));
            }
            this.handleProviderRemoved((ProtocolProviderService)sService);
        }
    }

    private synchronized void fireMetaContactEvent(MetaContact sourceContact, MetaContactGroup parentGroup, int eventID) {
        MetaContactEvent evt = new MetaContactEvent(sourceContact, parentGroup, eventID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following mcl event: " + evt));
        }
        block4: for (MetaContactListListener listener : this.getMetaContactListListeners()) {
            switch (evt.getEventID()) {
                case 1: {
                    listener.metaContactAdded(evt);
                    continue block4;
                }
                case 2: {
                    listener.metaContactRemoved(evt);
                    continue block4;
                }
                default: {
                    logger.error((Object)("Unknown event type " + evt.getEventID()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaContactListListener[] getMetaContactListListeners() {
        MetaContactListListener[] listeners;
        List<MetaContactListListener> list = this.metaContactListListeners;
        synchronized (list) {
            listeners = this.metaContactListListeners.toArray(new MetaContactListListener[this.metaContactListListeners.size()]);
        }
        return listeners;
    }

    synchronized void fireMetaContactEvent(MetaContactPropertyChangeEvent event) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following mcl property change event: " + event));
        }
        for (MetaContactListListener listener : this.getMetaContactListListeners()) {
            if (event instanceof MetaContactMovedEvent) {
                listener.metaContactMoved((MetaContactMovedEvent)event);
                continue;
            }
            if (event instanceof MetaContactRenamedEvent) {
                listener.metaContactRenamed((MetaContactRenamedEvent)event);
                continue;
            }
            if (event instanceof MetaContactModifiedEvent) {
                listener.metaContactModified((MetaContactModifiedEvent)event);
                continue;
            }
            if (!(event instanceof MetaContactAvatarUpdateEvent)) continue;
            listener.metaContactAvatarUpdated((MetaContactAvatarUpdateEvent)event);
        }
    }

    private synchronized void fireProtoContactEvent(Contact source, String eventName, MetaContact oldParent, MetaContact newParent) {
        ProtoContactEvent event = new ProtoContactEvent(source, eventName, oldParent, newParent);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following mcl property change event: " + event));
        }
        for (MetaContactListListener listener : this.getMetaContactListListeners()) {
            if (eventName.equals("ProtoContactAdded")) {
                listener.protoContactAdded(event);
                continue;
            }
            if (eventName.equals("ProtoContactMoved")) {
                listener.protoContactMoved(event);
                continue;
            }
            if (eventName.equals("ProtoContactRemoved")) {
                listener.protoContactRemoved(event);
                continue;
            }
            if (!eventName.equals("ProtoContactModified")) continue;
            listener.protoContactModified(event);
        }
    }

    public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
        int newContactIndex;
        MetaContactImpl metaContactImpl = (MetaContactImpl)this.findMetaContactByContact(evt.getSourceContact());
        if (metaContactImpl == null) {
            return;
        }
        int oldContactIndex = metaContactImpl.getParentGroup().indexOf(metaContactImpl);
        if (oldContactIndex != (newContactIndex = metaContactImpl.reevalContact())) {
            this.fireMetaContactGroupEvent(this.findParentMetaContactGroup(metaContactImpl), evt.getSourceProvider(), null, 4);
        }
    }

    MetaContactGroupImpl loadStoredMetaContactGroup(MetaContactGroupImpl parentGroup, String metaContactGroupUID, String displayName) {
        MetaContactGroupImpl newMetaGroup = (MetaContactGroupImpl)parentGroup.getMetaContactSubgroupByUID(metaContactGroupUID);
        if (newMetaGroup != null) {
            return newMetaGroup;
        }
        newMetaGroup = new MetaContactGroupImpl(this, displayName, metaContactGroupUID);
        parentGroup.addSubgroup(newMetaGroup);
        this.fireMetaContactGroupEvent(newMetaGroup, null, null, 1);
        return newMetaGroup;
    }

    ContactGroup loadStoredContactGroup(MetaContactGroupImpl containingMetaGroup, String contactGroupUID, ContactGroup parentProtoGroup, String persistentData, String accountID) {
        ProtocolProviderService sourceProvider = this.currentlyInstalledProviders.get(accountID);
        OperationSetPersistentPresence presenceOpSet = (OperationSetPersistentPresence)sourceProvider.getOperationSet(OperationSetPersistentPresence.class);
        ContactGroup newProtoGroup = presenceOpSet.createUnresolvedContactGroup(contactGroupUID, persistentData, parentProtoGroup == null ? presenceOpSet.getServerStoredContactListRoot() : parentProtoGroup);
        containingMetaGroup.addProtoGroup(newProtoGroup);
        return newProtoGroup;
    }

    MetaContactImpl loadStoredMetaContact(MetaContactGroupImpl parentGroup, String metaUID, String displayName, Map<String, List<String>> details, List<MclStorageManager.StoredProtoContactDescriptor> protoContacts, String accountID) {
        MetaContactImpl newMetaContact = (MetaContactImpl)this.findMetaContactByMetaUID(metaUID);
        if (newMetaContact == null) {
            newMetaContact = new MetaContactImpl(metaUID, details);
            newMetaContact.setDisplayName(displayName);
        }
        ProtocolProviderService sourceProvider = this.currentlyInstalledProviders.get(accountID);
        OperationSetPersistentPresence presenceOpSet = (OperationSetPersistentPresence)sourceProvider.getOperationSet(OperationSetPersistentPresence.class);
        for (MclStorageManager.StoredProtoContactDescriptor contactDescriptor : protoContacts) {
            MetaContact mc = this.findMetaContactByContact(contactDescriptor.contactAddress, accountID);
            if (mc != null) {
                logger.warn((Object)("Ignoring duplicate proto contact " + contactDescriptor + " accountID=" + accountID + ". The contact was also present in the folloing meta contact:" + mc));
                continue;
            }
            Contact protoContact = presenceOpSet.createUnresolvedContact(contactDescriptor.contactAddress, contactDescriptor.persistentData, contactDescriptor.parentProtoGroup == null ? presenceOpSet.getServerStoredContactListRoot() : contactDescriptor.parentProtoGroup);
            newMetaContact.addProtoContact(protoContact);
        }
        if (newMetaContact.getContactCount() == 0) {
            logger.error((Object)"Found an empty meta contact. Throwing an exception so that the storage manager would remove it.");
            throw new IllegalArgumentException("MetaContact[" + (Object)((Object)newMetaContact) + "] contains no non-duplicating child contacts.");
        }
        parentGroup.addMetaContact(newMetaContact);
        this.fireMetaContactEvent(newMetaContact, parentGroup, 1);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created meta contact: " + (Object)((Object)newMetaContact)));
        }
        return newMetaContact;
    }

    private synchronized void fireMetaContactGroupEvent(MetaContactGroup source, ProtocolProviderService provider, ContactGroup sourceProtoGroup, int eventID) {
        MetaContactGroupEvent evt = new MetaContactGroupEvent(source, provider, sourceProtoGroup, eventID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following mcl event: " + evt));
        }
        block6: for (MetaContactListListener listener : this.getMetaContactListListeners()) {
            switch (eventID) {
                case 1: {
                    listener.metaContactGroupAdded(evt);
                    continue block6;
                }
                case 2: {
                    listener.metaContactGroupRemoved(evt);
                    continue block6;
                }
                case 4: {
                    listener.childContactsReordered(evt);
                    continue block6;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    listener.metaContactGroupModified(evt);
                    continue block6;
                }
                default: {
                    logger.error((Object)("Unknown event type (" + eventID + ") for event: " + evt));
                }
            }
        }
    }

    public void supportedOperationSetsChanged(ContactCapabilitiesEvent event) {
        MetaContactImpl metaContactImpl = (MetaContactImpl)this.findMetaContactByContact(event.getSourceContact());
        if (metaContactImpl == null) {
            return;
        }
        Contact contact = event.getSourceContact();
        metaContactImpl.updateCapabilities(contact, event.getOperationSets());
        this.fireProtoContactEvent(contact, "ProtoContactModified", metaContactImpl, metaContactImpl);
    }

    private static class BlockingSubscriptionEventRetriever
    implements SubscriptionListener,
    ServerStoredGroupListener {
        private final String subscriptionAddress;
        public Contact sourceContact = null;
        public EventObject evt = null;

        public void groupResolved(ServerStoredGroupEvent event) {
        }

        public void groupRemoved(ServerStoredGroupEvent event) {
        }

        public void groupNameChanged(ServerStoredGroupEvent event) {
        }

        BlockingSubscriptionEventRetriever(String subscriptionAddress) {
            this.subscriptionAddress = subscriptionAddress;
        }

        public synchronized void groupCreated(ServerStoredGroupEvent event) {
            Contact contact = event.getSourceGroup().getContact(this.subscriptionAddress);
            if (contact != null) {
                this.evt = event;
                this.sourceContact = contact;
                this.notifyAll();
            }
        }

        public synchronized void subscriptionCreated(SubscriptionEvent event) {
            if (event.getSourceContact().getAddress().equals(this.subscriptionAddress) || event.getSourceContact().equals(this.subscriptionAddress)) {
                this.evt = event;
                this.sourceContact = event.getSourceContact();
                this.notifyAll();
            }
        }

        public void subscriptionRemoved(SubscriptionEvent event) {
        }

        public synchronized void subscriptionFailed(SubscriptionEvent event) {
            if (event.getSourceContact().getAddress().equals(this.subscriptionAddress)) {
                this.evt = event;
                this.sourceContact = event.getSourceContact();
                this.notifyAll();
            }
        }

        public void subscriptionMoved(SubscriptionMovedEvent event) {
        }

        public void subscriptionResolved(SubscriptionEvent event) {
        }

        public void contactModified(ContactPropertyChangeEvent event) {
        }

        public synchronized void waitForEvent(long millis) {
            if (this.evt == null) {
                try {
                    this.wait(millis);
                }
                catch (InterruptedException ex) {
                    logger.error((Object)"Interrupted while waiting for contact creation", (Throwable)ex);
                }
            }
        }
    }

    private static class BlockingGroupEventRetriever
    implements ServerStoredGroupListener {
        private final String groupName;
        public ServerStoredGroupEvent evt = null;

        BlockingGroupEventRetriever(String groupName) {
            this.groupName = groupName;
        }

        public synchronized void groupCreated(ServerStoredGroupEvent event) {
            if (event.getSourceGroup().getGroupName().equals(this.groupName)) {
                this.evt = event;
                this.notifyAll();
            }
        }

        public void groupRemoved(ServerStoredGroupEvent event) {
        }

        public void groupNameChanged(ServerStoredGroupEvent event) {
        }

        public void groupResolved(ServerStoredGroupEvent event) {
        }

        public synchronized void waitForEvent(long millis) {
            if (this.evt == null) {
                try {
                    this.wait(millis);
                }
                catch (InterruptedException ex) {
                    logger.error((Object)"Interrupted while waiting for group creation", (Throwable)ex);
                }
            }
        }
    }

    private class ContactListGroupListener
    implements ServerStoredGroupListener {
        private ContactListGroupListener() {
        }

        private MetaContactGroup handleGroupCreatedEvent(MetaContactGroupImpl parent, ContactGroup group) {
            MetaContactGroupImpl newMetaGroup = (MetaContactGroupImpl)parent.getMetaContactSubgroup(group.getGroupName());
            if (newMetaGroup == null) {
                newMetaGroup = new MetaContactGroupImpl(MetaContactListServiceImpl.this, group.getGroupName());
                newMetaGroup.addProtoGroup(group);
                parent.addSubgroup(newMetaGroup);
            } else {
                newMetaGroup.addProtoGroup(group);
            }
            Iterator subgroups = group.subgroups();
            while (subgroups.hasNext()) {
                ContactGroup subgroup = (ContactGroup)subgroups.next();
                this.handleGroupCreatedEvent(newMetaGroup, subgroup);
            }
            Iterator contactsIter = group.contacts();
            while (contactsIter.hasNext()) {
                Contact contact = (Contact)contactsIter.next();
                MetaContactImpl newMetaContact = new MetaContactImpl();
                newMetaContact.addProtoContact(contact);
                newMetaContact.setDisplayName(contact.getDisplayName());
                newMetaGroup.addMetaContact(newMetaContact);
            }
            return newMetaGroup;
        }

        public void groupCreated(ServerStoredGroupEvent evt) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ContactGroup created: " + evt));
            }
            if (MetaContactListServiceImpl.this.isGroupInEventIgnoreList(evt.getSourceGroup().getGroupName(), evt.getSourceProvider())) {
                return;
            }
            MetaContactGroupImpl parentMetaGroup = (MetaContactGroupImpl)MetaContactListServiceImpl.this.findMetaContactGroupByContactGroup(evt.getParentGroup());
            if (parentMetaGroup == null) {
                logger.error((Object)("Failed to identify a parent where group " + evt.getSourceGroup().getGroupName() + "should be placed."));
            }
            boolean isExisting = parentMetaGroup.getMetaContactSubgroup(evt.getSourceGroup().getGroupName()) != null;
            MetaContactGroup newMetaGroup = this.handleGroupCreatedEvent(parentMetaGroup, evt.getSourceGroup());
            if (newMetaGroup.countContactGroups() > 1 || isExisting) {
                MetaContactListServiceImpl.this.fireMetaContactGroupEvent(newMetaGroup, evt.getSourceProvider(), evt.getSourceGroup(), 6);
            } else {
                MetaContactListServiceImpl.this.fireMetaContactGroupEvent(newMetaGroup, evt.getSourceProvider(), evt.getSourceGroup(), 1);
            }
        }

        public void groupResolved(ServerStoredGroupEvent evt) {
        }

        public void groupRemoved(ServerStoredGroupEvent evt) {
            MetaContactGroupImpl metaContactGroup;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ContactGroup removed: " + evt));
            }
            if ((metaContactGroup = (MetaContactGroupImpl)MetaContactListServiceImpl.this.findMetaContactGroupByContactGroup(evt.getSourceGroup())) == null) {
                logger.error((Object)("Received a RemovedGroup event for an orphan grp: " + evt.getSourceGroup()));
                return;
            }
            MetaContactListServiceImpl.this.removeContactGroupFromMetaContactGroup(metaContactGroup, evt.getSourceGroup(), evt.getSourceProvider());
            if (metaContactGroup.countContactGroups() == 0) {
                MetaContactListServiceImpl.this.removeMetaContactGroup(metaContactGroup);
            }
        }

        public void groupNameChanged(ServerStoredGroupEvent evt) {
            MetaContactGroup metaContactGroup;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ContactGroup renamed: " + evt));
            }
            if ((metaContactGroup = MetaContactListServiceImpl.this.findMetaContactGroupByContactGroup(evt.getSourceGroup())).countContactGroups() == 1) {
                ((MetaContactGroupImpl)metaContactGroup).setGroupName(evt.getSourceGroup().getGroupName());
            }
            MetaContactListServiceImpl.this.fireMetaContactGroupEvent(metaContactGroup, evt.getSourceProvider(), evt.getSourceGroup(), 5);
        }
    }

    private class ContactListSubscriptionListener
    implements SubscriptionListener {
        private ContactListSubscriptionListener() {
        }

        public void subscriptionCreated(SubscriptionEvent evt) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Subscription created: " + evt));
            }
            if (MetaContactListServiceImpl.this.isContactInEventIgnoreList(evt.getSourceContact(), evt.getSourceProvider())) {
                return;
            }
            MetaContactGroupImpl parentGroup = (MetaContactGroupImpl)MetaContactListServiceImpl.this.findMetaContactGroupByContactGroup(evt.getParentGroup());
            if (parentGroup == null) {
                logger.error((Object)"Received a subscription for a group that we hadn't seen before! ");
                return;
            }
            MetaContactImpl newMetaContact = new MetaContactImpl();
            newMetaContact.addProtoContact(evt.getSourceContact());
            newMetaContact.setDisplayName(evt.getSourceContact().getDisplayName());
            parentGroup.addMetaContact(newMetaContact);
            MetaContactListServiceImpl.this.fireMetaContactEvent(newMetaContact, parentGroup, 1);
            newMetaContact.getAvatar();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionMoved(SubscriptionMovedEvent evt) {
            Contact sourceContact;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Subscription moved: " + evt));
            }
            if (MetaContactListServiceImpl.this.isContactInEventIgnoreList(sourceContact = evt.getSourceContact(), evt.getSourceProvider())) {
                return;
            }
            MetaContactGroupImpl oldParentGroup = (MetaContactGroupImpl)MetaContactListServiceImpl.this.findMetaContactGroupByContactGroup(evt.getOldParentGroup());
            MetaContactGroupImpl newParentGroup = (MetaContactGroupImpl)MetaContactListServiceImpl.this.findMetaContactGroupByContactGroup(evt.getNewParentGroup());
            if (newParentGroup == null || oldParentGroup == null) {
                logger.error((Object)"Received a subscription for a group that we hadn't seen before! ");
                return;
            }
            MetaContactImpl currentMetaContact = (MetaContactImpl)MetaContactListServiceImpl.this.findMetaContactByContact(sourceContact);
            if (currentMetaContact == null) {
                logger.warn((Object)"Received a move event for a contact that is not in our contact list.", (Throwable)new NullPointerException("Received a move event for a contact that is not in our contact list."));
                return;
            }
            MetaContactGroup currentParentGroup = currentMetaContact.getParentMetaContactGroup();
            if (currentParentGroup == newParentGroup) {
                return;
            }
            if (currentMetaContact.getContactCount() == 1) {
                oldParentGroup.removeMetaContact(currentMetaContact);
                newParentGroup.addMetaContact(currentMetaContact);
                MetaContactListServiceImpl.this.fireMetaContactEvent((MetaContactPropertyChangeEvent)new MetaContactMovedEvent((MetaContact)currentMetaContact, (MetaContactGroup)oldParentGroup, (MetaContactGroup)newParentGroup));
            } else {
                MetaContactImpl newMetaContact = null;
                Contact contact = sourceContact;
                synchronized (contact) {
                    currentMetaContact.removeProtoContact(sourceContact);
                    MetaContact checkContact = MetaContactListServiceImpl.this.findMetaContactByContact(sourceContact);
                    if (checkContact == null) {
                        newMetaContact = new MetaContactImpl();
                        newMetaContact.setDisplayName(sourceContact.getDisplayName());
                        newParentGroup.addMetaContact(newMetaContact);
                        newMetaContact.addProtoContact(sourceContact);
                    }
                }
                if (newMetaContact != null) {
                    MetaContactListServiceImpl.this.fireMetaContactEvent(newMetaContact, newParentGroup, 1);
                    MetaContactListServiceImpl.this.fireProtoContactEvent(sourceContact, "ProtoContactMoved", currentMetaContact, newMetaContact);
                }
            }
        }

        public void subscriptionFailed(SubscriptionEvent evt) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Subscription failed: " + evt));
            }
        }

        public void subscriptionResolved(SubscriptionEvent evt) {
            MetaContactImpl mc = (MetaContactImpl)MetaContactListServiceImpl.this.findMetaContactByContact(evt.getSourceContact());
            if (mc != null) {
                mc.getAvatar();
                if (mc.getContactCount() == 1 && !mc.isDisplayNameUserDefined()) {
                    String oldDisplayName = mc.getDisplayName();
                    Contact c = mc.getDefaultContact();
                    String newDisplayName = c.getDisplayName();
                    if (newDisplayName != null && !newDisplayName.equals(oldDisplayName)) {
                        mc.setDisplayName(newDisplayName);
                        MetaContactListServiceImpl.this.fireMetaContactEvent((MetaContactPropertyChangeEvent)new MetaContactRenamedEvent((MetaContact)mc, oldDisplayName, newDisplayName));
                        MetaContactListServiceImpl.this.fireMetaContactGroupEvent(MetaContactListServiceImpl.this.findParentMetaContactGroup(mc), null, null, 4);
                    }
                }
            }
        }

        public void contactModified(ContactPropertyChangeEvent evt) {
            MetaContactImpl mc = (MetaContactImpl)MetaContactListServiceImpl.this.findMetaContactByContact(evt.getSourceContact());
            if ("DisplayName".equals(evt.getPropertyName())) {
                if (evt.getOldValue() != null && evt.getOldValue().equals(mc.getDisplayName())) {
                    MetaContactListServiceImpl.this.renameMetaContact(mc, (String)evt.getNewValue(), false);
                } else {
                    MetaContactListServiceImpl.this.fireProtoContactEvent(evt.getSourceContact(), "ProtoContactModified", mc, mc);
                }
            } else if ("Image".equals(evt.getPropertyName()) && evt.getNewValue() != null) {
                MetaContactListServiceImpl.this.changeMetaContactAvatar(mc, evt.getSourceContact(), (byte[])evt.getNewValue());
            } else if ("PersistentData".equals(evt.getPropertyName()) || "DisplayDetails".equals(evt.getPropertyName())) {
                MetaContactListServiceImpl.this.fireProtoContactEvent(evt.getSourceContact(), "ProtoContactModified", mc, mc);
            }
        }

        public void subscriptionRemoved(SubscriptionEvent evt) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Subscription removed: " + evt));
            }
            MetaContactImpl metaContact = (MetaContactImpl)MetaContactListServiceImpl.this.findMetaContactByContact(evt.getSourceContact());
            MetaContactGroupImpl metaContactGroup = (MetaContactGroupImpl)MetaContactListServiceImpl.this.findMetaContactGroupByContactGroup(evt.getParentGroup());
            metaContact.removeProtoContact(evt.getSourceContact());
            if (metaContact.getContactCount() == 0) {
                metaContactGroup.removeMetaContact(metaContact);
                MetaContactListServiceImpl.this.fireMetaContactEvent(metaContact, metaContactGroup, 2);
            } else {
                MetaContactListServiceImpl.this.fireProtoContactEvent(evt.getSourceContact(), "ProtoContactRemoved", metaContact, null);
            }
        }
    }
}

