/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ssiitem.BuddyItem;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyListener;
import net.kano.joustsim.oscar.oscar.service.ssi.ChangeTools;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddyList;

class SimpleBuddy
implements Buddy {
    private final SimpleBuddyList buddyList;
    private CopyOnWriteArrayList<BuddyListener> listeners = new CopyOnWriteArrayList();
    private final int itemId;
    private BuddyItem item;
    private boolean active = true;
    private Screenname screenname;
    private String alias;
    private String buddyComment;
    private int alertActionMask;
    private String alertSound;
    private int alertEventMask;
    private boolean awaitingAuthorization;

    SimpleBuddy(SimpleBuddyList list, BuddyItem item) {
        this.buddyList = list;
        this.itemId = item.getId();
        this.setItem(item);
    }

    public SimpleBuddyList getBuddyList() {
        return this.buddyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyItem getItem() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(BuddyItem item) {
        DefensiveTools.checkNull(item, "item");
        Object object = this.getBuddyListLock();
        synchronized (object) {
            if (item.getId() != this.itemId) {
                throw new IllegalArgumentException("item " + item + " does not " + "match ID " + this.itemId);
            }
            this.item = item;
            this.screenname = new Screenname(item.getScreenname());
            this.alias = item.getAlias();
            this.alertActionMask = item.getAlertActionMask();
            this.alertSound = item.getAlertSound();
            this.alertEventMask = item.getAlertWhenMask();
            this.buddyComment = item.getBuddyComment();
            this.awaitingAuthorization = item.isAwaitingAuth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuddyState saveState() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return new BuddyState();
        }
    }

    public void detectChanges(BuddyState oldState, BuddyState newState) {
        boolean newAwaitingAuth;
        boolean oldAwaitingAuth;
        int newAlertEvent;
        int oldAlertEvent;
        String newAlertSound;
        String oldAlertSound;
        int newAlertAction;
        int oldAlertAction;
        String newComment;
        String oldComment;
        String newAlias;
        String oldAlias;
        assert (!Thread.holdsLock(this));
        Screenname oldSn = oldState.getScreenname();
        Screenname newSn = newState.getScreenname();
        if (!ChangeTools.areEqual(oldSn.getFormatted(), newSn.getFormatted())) {
            for (BuddyListener listener : this.listeners) {
                listener.screennameChanged(this, oldSn, newSn);
            }
        }
        if (!ChangeTools.areEqual(oldAlias = oldState.getAlias(), newAlias = newState.getAlias())) {
            for (BuddyListener listener : this.listeners) {
                listener.aliasChanged(this, oldAlias, newAlias);
            }
        }
        if (!ChangeTools.areEqual(oldComment = oldState.getBuddyComment(), newComment = newState.getBuddyComment())) {
            for (BuddyListener listener : this.listeners) {
                listener.buddyCommentChanged(this, oldComment, newComment);
            }
        }
        if ((oldAlertAction = oldState.getAlertActionMask()) != (newAlertAction = newState.getAlertActionMask())) {
            for (BuddyListener listener : this.listeners) {
                listener.alertActionChanged(this, oldAlertAction, newAlertAction);
            }
        }
        if (!ChangeTools.areEqual(oldAlertSound = oldState.getAlertSound(), newAlertSound = newState.getAlertSound())) {
            for (BuddyListener listener : this.listeners) {
                listener.alertSoundChanged(this, oldAlertSound, newAlertSound);
            }
        }
        if ((oldAlertEvent = oldState.getAlertEventMask()) != (newAlertEvent = newState.getAlertEventMask())) {
            for (BuddyListener listener : this.listeners) {
                listener.alertTimeChanged(this, oldAlertEvent, newAlertEvent);
            }
        }
        if ((oldAwaitingAuth = oldState.isAwaitingAuthorization()) != (newAwaitingAuth = newState.isAwaitingAuthorization())) {
            for (BuddyListener listener : this.listeners) {
                listener.awaitingAuthChanged(this, oldAwaitingAuth, newAwaitingAuth);
            }
        }
    }

    public void addBuddyListener(BuddyListener listener) {
        this.listeners.add(listener);
    }

    public void removeBuddyListener(BuddyListener listener) {
        this.listeners.remove(listener);
    }

    private Object getBuddyListLock() {
        return this.buddyList.getLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active) {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            this.active = active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screenname getScreenname() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.screenname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlias() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.alias;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAlertActionMask() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.alertActionMask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlertSound() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.alertSound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAlertEventMask() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.alertEventMask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBuddyComment() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.buddyComment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAwaitingAuthorization() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return this.awaitingAuthorization;
        }
    }

    public String toString() {
        return "Buddy " + this.getScreenname() + " (alias " + this.getAlias() + ")";
    }

    protected class BuddyState {
        private Screenname screenname;
        private String alias;
        private String buddyComment;
        private int alertActionMask;
        private String alertSound;
        private int alertEventMask;
        private boolean awaitingAuthorization;

        public BuddyState() {
            this.screenname = SimpleBuddy.this.screenname;
            this.alias = SimpleBuddy.this.alias;
            this.buddyComment = SimpleBuddy.this.buddyComment;
            this.alertActionMask = SimpleBuddy.this.alertActionMask;
            this.alertSound = SimpleBuddy.this.alertSound;
            this.alertEventMask = SimpleBuddy.this.alertEventMask;
            this.awaitingAuthorization = SimpleBuddy.this.awaitingAuthorization;
        }

        public Screenname getScreenname() {
            return this.screenname;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getBuddyComment() {
            return this.buddyComment;
        }

        public int getAlertActionMask() {
            return this.alertActionMask;
        }

        public String getAlertSound() {
            return this.alertSound;
        }

        public int getAlertEventMask() {
            return this.alertEventMask;
        }

        public boolean isAwaitingAuthorization() {
            return this.awaitingAuthorization;
        }
    }
}

