/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.chatrooms;

import java.util.Collections;
import java.util.Set;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.net.ClientConn;
import net.kano.joscar.rv.RvProcessor;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.rvcmd.chatinvite.ChatInvitationRvCmd;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.OscarConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.ServiceListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatInvitation;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatInvitationImpl;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatMessage;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomService;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomServiceListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomSessionListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomUser;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatSessionState;
import net.kano.joustsim.oscar.oscar.service.chatrooms.EncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatRoomSession {
    private AimConnection aimConnection;
    private BasicConnection connection;
    private ChatRoomService service;
    private FullRoomInfo roomInfo;
    private ChatInvitationImpl invitation;
    private ChatSessionState state = ChatSessionState.INITIALIZING;
    private CopyOnWriteArrayList<ChatRoomSessionListener> listeners = new CopyOnWriteArrayList();

    public ChatRoomSession(AimConnection aimConnection) {
        this.aimConnection = aimConnection;
    }

    public AimConnection getAimConnection() {
        return this.aimConnection;
    }

    void setRoomInfo(FullRoomInfo roomInfo) {
        this.roomInfo = roomInfo;
    }

    public BasicConnection getConnection() {
        return this.connection;
    }

    public void addListener(ChatRoomSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChatRoomSessionListener listener) {
        this.listeners.remove(listener);
    }

    void setConnection(BasicConnection connection) {
        connection.addGlobalServiceListener(new ServiceListener(){

            public void handleServiceReady(Service service) {
                if (service instanceof ChatRoomService) {
                    ChatRoomService chatService = (ChatRoomService)service;
                    chatService.addChatRoomListener(new ChatRoomServiceListener(){

                        @Override
                        public void handleUsersJoined(ChatRoomService service, Set<ChatRoomUser> added) {
                            for (ChatRoomSessionListener l : ChatRoomSession.this.listeners) {
                                l.handleUsersJoined(ChatRoomSession.this, added);
                            }
                        }

                        @Override
                        public void handleUsersLeft(ChatRoomService service, Set<ChatRoomUser> removed) {
                            for (ChatRoomSessionListener l : ChatRoomSession.this.listeners) {
                                l.handleUsersLeft(ChatRoomSession.this, removed);
                            }
                        }

                        @Override
                        public void handleIncomingMessage(ChatRoomService service, ChatRoomUser user, ChatMessage message) {
                            for (ChatRoomSessionListener l : ChatRoomSession.this.listeners) {
                                l.handleIncomingMessage(ChatRoomSession.this, user, message);
                            }
                        }
                    });
                    ChatRoomSession.this.setState(ChatSessionState.INROOM);
                }
            }

            public void handleServiceFinished(Service service) {
            }
        });
        connection.addOscarListener(new OscarConnListener(){

            public void registeredSnacFamilies(OscarConnection conn) {
            }

            public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
                ClientConn.State state = event.getClientConnEvent().getNewState();
                if (state == ClientConn.STATE_FAILED) {
                    ChatRoomSession.this.setState(ChatSessionState.FAILED);
                } else if (state == ClientConn.STATE_NOT_CONNECTED) {
                    ChatRoomSession.this.setState(ChatSessionState.CLOSED);
                }
            }

            public void allFamiliesReady(OscarConnection conn) {
            }
        });
        this.connection = connection;
    }

    public void close() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public void sendMessage(String msg) throws EncodingException {
        this.service.sendMessage(msg);
    }

    void setInvitation(ChatInvitationImpl invitation) {
        this.invitation = invitation;
    }

    public ChatInvitation getInvitation() {
        return this.invitation;
    }

    ChatInvitationImpl getInvitationImpl() {
        return this.invitation;
    }

    public FullRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    void setService(ChatRoomService service) {
        this.service = service;
    }

    public synchronized ChatSessionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(ChatSessionState state) {
        ChatSessionState oldState;
        ChatRoomSession chatRoomSession = this;
        synchronized (chatRoomSession) {
            oldState = this.state;
            if (state == oldState) {
                return;
            }
            this.state = state;
        }
        for (ChatRoomSessionListener listener : this.listeners) {
            listener.handleStateChange(this, oldState, state);
        }
    }

    public Set<ChatRoomUser> getUsers() {
        if (this.service == null) {
            return Collections.EMPTY_SET;
        }
        return this.service.getUsers();
    }

    public void invite(Screenname screenname, String message) {
        DefensiveTools.checkNull(screenname, "screenname");
        DefensiveTools.checkNull(this.roomInfo, "roomInfo");
        RvProcessor rvProcessor = this.aimConnection.getIcbmService().getRvProcessor();
        RvSession session = rvProcessor.createRvSession(screenname.getNormal());
        session.sendRv(new ChatInvitationRvCmd(new MiniRoomInfo(this.roomInfo), message == null ? null : new InvitationMessage(message)));
    }
}

