/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class SsiDataCheck
extends SsiCommand {
    private final long lastmod;
    private final int itemCount;

    protected SsiDataCheck(SnacPacket packet) {
        super(5);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.lastmod = BinaryTools.getUInt(snacData, 0);
        this.itemCount = BinaryTools.getUShort(snacData, 4);
    }

    public SsiDataCheck(long lastmod, int itemCount) {
        super(5);
        DefensiveTools.checkRange(lastmod, "lastmod", -1L);
        DefensiveTools.checkRange(itemCount, "itemCount", -1);
        this.lastmod = lastmod;
        this.itemCount = itemCount;
    }

    public final long getLastModDate() {
        return this.lastmod;
    }

    public final int getItemCount() {
        return this.itemCount;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.lastmod != -1L) {
            BinaryTools.writeUInt(out, this.lastmod);
            if (this.itemCount != -1) {
                BinaryTools.writeUShort(out, this.itemCount);
            }
        }
    }

    public String toString() {
        return "SsiDataCheck: lastmod=" + this.lastmod + ", " + this.itemCount + " items";
    }
}

