/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class SetInterestsAck
extends LocCommand {
    public static final int CODE_SUCCESS = 1;
    private final int code;

    protected SetInterestsAck(SnacPacket packet) {
        super(16);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.code = BinaryTools.getUShort(snacData, 0);
    }

    public SetInterestsAck() {
        this(1);
    }

    public SetInterestsAck(int code) {
        super(16);
        DefensiveTools.checkRange(code, "code", 0);
        this.code = code;
    }

    public final int getResultCode() {
        return this.code;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.code);
    }

    public String toString() {
        return "SetInterestsAck: code=" + this.code;
    }
}

