/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoData
implements LiveWritable {
    private static final Logger LOGGER = LoggingSystem.getLogger(InfoData.class.getName());
    public static final String NOT_AWAY = "";
    private static final int TYPE_INFO_FMT = 1;
    private static final int TYPE_INFO = 2;
    private static final int TYPE_AWAY_FMT = 3;
    private static final int TYPE_AWAY = 4;
    private static final int TYPE_CAPS = 5;
    private static final int TYPE_CERTIFICATE_INFO = 6;
    private static final int TYPE_UNKNOWN1 = 11;
    private final String userProfile;
    private final String awayMessage;
    private final List<CapabilityBlock> caps;
    private final CertificateInfo certInfo;

    public static InfoData forUserProfile(String profile) {
        DefensiveTools.checkNull(profile, "profile");
        return new InfoData(profile, null, null, null);
    }

    public static InfoData forAwayMessage(String awayMessage) {
        DefensiveTools.checkNull(awayMessage, "awayMessage");
        return new InfoData(null, awayMessage, null, null);
    }

    public static InfoData forCapabilities(List<CapabilityBlock> caps) {
        DefensiveTools.checkNull(caps, "caps");
        return new InfoData(null, null, caps, null);
    }

    public static InfoData forCertificateInfo(CertificateInfo certInfo) {
        DefensiveTools.checkNull(certInfo, "certInfo");
        return new InfoData(null, null, null, certInfo);
    }

    public static InfoData forEmptyInfo() {
        return new InfoData(null, null, null, null);
    }

    public static InfoData readInfoData(ByteBlock block) {
        return InfoData.readInfoDataFromChain(TlvTools.readChain(block));
    }

    public static InfoData readInfoDataFromChain(TlvChain chain) {
        DefensiveTools.checkNull(chain, "chain");
        String awayType = chain.getString(3);
        Tlv awayTlv = chain.getLastTlv(4);
        String infoType = chain.getString(1);
        Tlv infoTlv = chain.getLastTlv(2);
        Tlv capTlv = chain.getLastTlv(5);
        Tlv certTlv = chain.getLastTlv(6);
        String awayMessage = null;
        if (awayTlv != null) {
            awayMessage = OscarTools.getInfoString(awayTlv.getData(), awayType);
        }
        String info = null;
        if (infoTlv != null) {
            info = OscarTools.getInfoString(infoTlv.getData(), infoType);
        }
        List<CapabilityBlock> caps = null;
        if (capTlv != null) {
            caps = CapabilityBlock.getCapabilityBlocks(capTlv.getData());
        }
        CertificateInfo certInfo = null;
        if (certTlv != null) {
            certInfo = CertificateInfo.readCertInfoBlock(certTlv.getData());
        }
        MutableTlvChain copy = TlvTools.getMutableCopy(chain);
        copy.removeTlvs(3, 4, 1, 2, 5, 6, 11);
        if (copy.getTlvCount() > 0) {
            LOGGER.logWarning("Unknown TLV's in InfoData: " + copy);
        }
        return new InfoData(info, awayMessage, caps, certInfo);
    }

    public InfoData(String profile, String awayMessage, List<CapabilityBlock> caps, CertificateInfo certInfo) {
        this.userProfile = profile;
        this.awayMessage = awayMessage;
        this.caps = DefensiveTools.getSafeListCopy(caps, "caps");
        this.certInfo = certInfo;
    }

    public final String getUserProfile() {
        return this.userProfile;
    }

    public final String getAwayMessage() {
        return this.awayMessage;
    }

    public final List<CapabilityBlock> getCaps() {
        return this.caps;
    }

    public final CertificateInfo getCertificateInfo() {
        return this.certInfo;
    }

    private static String getFormatString(String charset) {
        return "text/x-aolrtf; charset=" + charset;
    }

    private static void writeInfoTlvs(String text, OutputStream out, int fmtType, int textType) throws IOException {
        EncodedStringInfo encInfo = MinimalEncoder.encodeMinimally(text);
        ByteBlock infoBlock = ByteBlock.wrap(encInfo.getData());
        String formatString = InfoData.getFormatString(encInfo.getCharset());
        Tlv.getStringInstance(fmtType, formatString).write(out);
        new Tlv(textType, infoBlock).write(out);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        if (this.userProfile != null) {
            InfoData.writeInfoTlvs(this.userProfile, out, 1, 2);
        }
        if (this.awayMessage != null) {
            InfoData.writeInfoTlvs(this.awayMessage, out, 3, 4);
        }
        if (this.caps != null) {
            byte[] capBlock = CapabilityBlock.convertToBytes(this.caps);
            new Tlv(5, ByteBlock.wrap(capBlock)).write(out);
        }
        if (this.certInfo != null) {
            ByteBlock certInfoBlock = ByteBlock.createByteBlock(this.certInfo);
            new Tlv(6, certInfoBlock).write(out);
        }
    }

    public String toString() {
        String display;
        StringBuffer buffer = new StringBuffer();
        buffer.append("InfoData:");
        if (this.userProfile != null && this.userProfile.length() > 0) {
            display = this.userProfile;
            if (display.length() > 20) {
                display = display.substring(0, 20) + "...";
            }
            buffer.append("  info: ");
            buffer.append(display);
        }
        if (this.awayMessage != null && this.awayMessage.length() > 0) {
            display = this.awayMessage;
            if (display.length() > 20) {
                display = display.substring(0, 20) + "...";
            }
            buffer.append("  away: ");
            buffer.append(display);
        }
        if (this.caps != null && this.caps.size() > 0) {
            buffer.append("  capabilities: ");
            buffer.append(this.caps.size());
        }
        if (this.certInfo != null) {
            buffer.append("  certinfo: ");
            buffer.append(this.certInfo);
        }
        return buffer.toString();
    }
}

