/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.media.CaptureDeviceInfo;
import net.java.sip.communicator.impl.neomedia.AbstractDeviceConfigurationListener;
import net.java.sip.communicator.impl.neomedia.NeomediaActivator;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.service.resources.ResourceManagementService;

public class AudioDeviceConfigurationListener
extends AbstractDeviceConfigurationListener {
    private PropertyChangeEvent capturePropertyChangeEvent;
    private PropertyChangeEvent notifyPropertyChangeEvent;
    private PropertyChangeEvent playbackPropertyChangeEvent;

    public AudioDeviceConfigurationListener(ConfigurationForm configurationForm) {
        super(configurationForm);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if ("net.java.sip.communicator.impl.neomedia.audioSystem.devices".equals(propertyName)) {
            boolean removal;
            List devices;
            String title;
            List oldDevices = (List)ev.getOldValue();
            List newDevices = (List)ev.getNewValue();
            if (oldDevices.isEmpty()) {
                oldDevices = null;
            }
            if (newDevices.isEmpty()) {
                newDevices = null;
            }
            ResourceManagementService r = NeomediaActivator.getResources();
            if (newDevices != null) {
                title = r.getI18NString("impl.media.configform.AUDIO_DEVICE_CONNECTED");
                devices = newDevices;
                removal = false;
            } else if (oldDevices != null) {
                title = r.getI18NString("impl.media.configform.AUDIO_DEVICE_DISCONNECTED");
                devices = oldDevices;
                removal = true;
            } else {
                this.capturePropertyChangeEvent = null;
                this.notifyPropertyChangeEvent = null;
                this.playbackPropertyChangeEvent = null;
                return;
            }
            StringBuilder body = new StringBuilder();
            for (CaptureDeviceInfo device : devices) {
                body.append(device.getName()).append("\r\n");
            }
            DeviceConfiguration devConf = (DeviceConfiguration)ev.getSource();
            AudioSystem audioSystem = devConf.getAudioSystem();
            boolean selectedHasChanged = false;
            if (audioSystem != null) {
                CaptureDeviceInfo2 cdi;
                if (this.capturePropertyChangeEvent != null && (cdi = audioSystem.getSelectedDevice(AudioSystem.DataFlow.CAPTURE)) != null && !cdi.equals(this.capturePropertyChangeEvent.getOldValue())) {
                    body.append("\r\n").append(r.getI18NString("impl.media.configform.AUDIO_DEVICE_SELECTED_AUDIO_IN")).append("\r\n\t").append(cdi.getName());
                    selectedHasChanged = true;
                }
                if (this.playbackPropertyChangeEvent != null && (cdi = audioSystem.getSelectedDevice(AudioSystem.DataFlow.PLAYBACK)) != null && !cdi.equals(this.playbackPropertyChangeEvent.getOldValue())) {
                    body.append("\r\n").append(r.getI18NString("impl.media.configform.AUDIO_DEVICE_SELECTED_AUDIO_OUT")).append("\r\n\t").append(cdi.getName());
                    selectedHasChanged = true;
                }
                if (this.notifyPropertyChangeEvent != null && (cdi = audioSystem.getSelectedDevice(AudioSystem.DataFlow.NOTIFY)) != null && !cdi.equals(this.notifyPropertyChangeEvent.getOldValue())) {
                    body.append("\r\n").append(r.getI18NString("impl.media.configform.AUDIO_DEVICE_SELECTED_AUDIO_NOTIFICATIONS")).append("\r\n\t").append(cdi.getName());
                    selectedHasChanged = true;
                }
            }
            this.capturePropertyChangeEvent = null;
            this.notifyPropertyChangeEvent = null;
            this.playbackPropertyChangeEvent = null;
            if (!removal || selectedHasChanged) {
                this.showPopUpNotification(title, body.toString(), "DeviceConfigurationChanged");
            }
        } else if ("captureDevice".equals(propertyName)) {
            this.capturePropertyChangeEvent = ev;
        } else if ("notifyDevice".equals(propertyName)) {
            this.notifyPropertyChangeEvent = ev;
        } else if ("playbackDevice".equals(propertyName)) {
            this.playbackPropertyChangeEvent = ev;
        }
    }
}

