/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.history;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import net.java.sip.communicator.service.history.QueryResultSet;

public class OrderedQueryResultSet<T>
implements QueryResultSet<T> {
    private LinkedList<T> records = null;
    private int currentPos = -1;

    public OrderedQueryResultSet(Set<T> records) {
        this.records = new LinkedList<T>(records);
    }

    @Override
    public boolean hasNext() {
        return this.currentPos + 1 < this.records.size();
    }

    @Override
    public boolean hasPrev() {
        return this.currentPos - 1 >= 0;
    }

    @Override
    public T next() {
        ++this.currentPos;
        if (this.currentPos >= this.records.size()) {
            throw new NoSuchElementException();
        }
        return this.records.get(this.currentPos);
    }

    @Override
    public T nextRecord() throws NoSuchElementException {
        return this.next();
    }

    @Override
    public T prev() throws NoSuchElementException {
        --this.currentPos;
        if (this.currentPos < 0) {
            throw new NoSuchElementException();
        }
        return this.records.get(this.currentPos);
    }

    @Override
    public T prevRecord() throws NoSuchElementException {
        return this.prev();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from underlaying collection.");
    }
}

