/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.history;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import net.java.sip.communicator.impl.history.HistoryImpl;
import net.java.sip.communicator.impl.history.HistoryServiceImpl;
import net.java.sip.communicator.service.history.History;
import net.java.sip.communicator.service.history.HistoryID;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBStructSerializer {
    private HistoryServiceImpl historyService;

    public DBStructSerializer(HistoryServiceImpl historyService) {
        this.historyService = historyService;
    }

    public void writeHistory(File dbDatFile, History history) throws IOException {
        DocumentBuilder builder = this.historyService.getDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("dbstruct");
        root.setAttribute("version", "1.0");
        Element structure = this.createStructureTag(doc, history.getHistoryRecordsStructure());
        Element id = this.createIDTag(doc, history.getID());
        root.appendChild(structure);
        root.appendChild(id);
        doc.appendChild(root);
        XMLUtils.writeXML((Document)doc, (File)dbDatFile);
    }

    private Element createIDTag(Document doc, HistoryID historyID) {
        Element idroot;
        Element current = idroot = doc.createElement("id");
        String[] idelements = historyID.getID();
        for (int i = 0; i < idelements.length; ++i) {
            Element idnode = doc.createElement("component");
            idnode.setAttribute("value", idelements[i]);
            current.appendChild(idnode);
            current = idnode;
        }
        return idroot;
    }

    private Element createStructureTag(Document doc, HistoryRecordStructure recordStructure) {
        Element structure = doc.createElement("structure");
        String[] propertyNames = recordStructure.getPropertyNames();
        int count = recordStructure.getPropertyCount();
        for (int i = 0; i < count; ++i) {
            Element property = doc.createElement("property");
            property.setAttribute("name", propertyNames[i]);
            structure.appendChild(property);
        }
        return structure;
    }

    public History loadHistory(File dbDatFile) throws SAXException, IOException, ParseException {
        Document doc = this.historyService.parse(dbDatFile);
        Node root = doc.getFirstChild();
        HistoryID id = this.loadID(root);
        HistoryRecordStructure structure = this.loadStructure(root);
        return new HistoryImpl(id, dbDatFile.getParentFile(), structure, this.historyService);
    }

    private HistoryRecordStructure loadStructure(Node root) throws ParseException {
        Element structNode = this.findElement(root, "structure");
        if (structNode == null) {
            throw new ParseException("There is no structure tag defined!", 0);
        }
        NodeList nodes = structNode.getChildNodes();
        int count = nodes.getLength();
        ArrayList<String> propertyNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            Element parameter;
            String paramName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !"property".equals(node.getNodeName()) || (paramName = (parameter = (Element)node).getAttribute("name")) == null) continue;
            propertyNames.add(paramName);
        }
        String[] names = new String[propertyNames.size()];
        propertyNames.toArray(names);
        return new HistoryRecordStructure(names);
    }

    private HistoryID loadID(Node parent) throws ParseException {
        Element idnode = this.findElement(parent, "id");
        ArrayList<String> al = this.loadID(new ArrayList<String>(), idnode);
        String[] id = new String[al.size()];
        al.toArray(id);
        return HistoryID.createFromID(id);
    }

    private ArrayList<String> loadID(ArrayList<String> loadedIDs, Node parent) throws ParseException {
        String idValue;
        Element node = this.findElement(parent, "component");
        if (node != null) {
            idValue = node.getAttribute("value");
            if (idValue == null) {
                throw new ParseException("There is an ID object without value.", 0);
            }
        } else {
            return loadedIDs;
        }
        loadedIDs.add(idValue);
        return this.loadID(loadedIDs, node);
    }

    private Element findElement(Node parent, String name) {
        Element retVal = null;
        NodeList nodes = parent.getChildNodes();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !name.equals(node.getNodeName())) continue;
            retVal = (Element)node;
            break;
        }
        return retVal;
    }
}

