/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.irc.ContactGroupIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ContactIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.IrcActivator;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class OperationSetPersistentPresenceIrcImpl
extends AbstractOperationSetPersistentPresence<ProtocolProviderServiceIrcImpl> {
    private static final Logger LOGGER = Logger.getLogger(OperationSetPersistentPresenceIrcImpl.class);
    private final ContactGroupIrcImpl rootGroup;

    protected OperationSetPersistentPresenceIrcImpl(ProtocolProviderServiceIrcImpl parentProvider) {
        super((ProtocolProviderService)parentProvider);
        this.rootGroup = new ContactGroupIrcImpl((ProtocolProviderServiceIrcImpl)this.parentProvider);
    }

    private ContactIrcImpl createVolatileContact(String id) {
        ContactGroupIrcImpl volatileGroup = this.getNonPersistentGroup();
        ContactIrcImpl newVolatileContact = new ContactIrcImpl((ProtocolProviderServiceIrcImpl)this.parentProvider, id, volatileGroup, IrcStatusEnum.ONLINE);
        volatileGroup.addContact(newVolatileContact);
        IrcConnection connection = ((ProtocolProviderServiceIrcImpl)this.parentProvider).getIrcStack().getConnection();
        if (connection != null) {
            connection.getPresenceManager().addNickWatch(id);
        }
        this.fireSubscriptionEvent((Contact)newVolatileContact, volatileGroup, 1);
        return newVolatileContact;
    }

    private ContactGroupIrcImpl getNonPersistentGroup() {
        String groupName = IrcActivator.getResources().getI18NString("service.gui.NOT_IN_CONTACT_LIST_GROUP_NAME");
        for (int i = 0; i < this.getRootGroup().countSubgroups(); ++i) {
            ContactGroupIrcImpl gr = (ContactGroupIrcImpl)this.getRootGroup().getGroup(i);
            if (gr.isPersistent() || !gr.getGroupName().equals(groupName)) continue;
            return gr;
        }
        ContactGroupIrcImpl volatileGroup = new ContactGroupIrcImpl((ProtocolProviderServiceIrcImpl)this.parentProvider, this.rootGroup, groupName);
        volatileGroup.setPersistent(false);
        this.rootGroup.addSubGroup(volatileGroup);
        this.fireServerStoredGroupEvent(volatileGroup, 1);
        return volatileGroup;
    }

    public ContactGroupIrcImpl getRootGroup() {
        return this.rootGroup;
    }

    public void subscribe(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.subscribe(this.rootGroup, contactIdentifier);
    }

    public void subscribe(ContactGroup parent, String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        if (contactIdentifier == null || contactIdentifier.isEmpty()) {
            throw new IllegalArgumentException("contactIdentifier cannot be null or empty");
        }
        if (!(parent instanceof ContactGroupIrcImpl)) {
            throw new IllegalArgumentException("parent group must be an instance of ContactGroupIrcImpl");
        }
        ContactGroupIrcImpl contactGroup = (ContactGroupIrcImpl)parent;
        IrcConnection connection = ((ProtocolProviderServiceIrcImpl)this.parentProvider).getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("not currently connected");
        }
        ContactIrcImpl newContact = new ContactIrcImpl((ProtocolProviderServiceIrcImpl)this.parentProvider, contactIdentifier, contactGroup, IrcStatusEnum.OFFLINE);
        try {
            contactGroup.addContact(newContact);
            connection.getPresenceManager().addNickWatch(contactIdentifier);
            this.fireSubscriptionEvent((Contact)newContact, contactGroup, 1);
        }
        catch (RuntimeException e) {
            LOGGER.debug((Object)"Failed to subscribe to contact.", (Throwable)e);
            this.fireSubscriptionEvent((Contact)newContact, contactGroup, 3);
        }
    }

    public void unsubscribe(Contact contact) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        if (!(contact instanceof ContactIrcImpl)) {
            throw new IllegalArgumentException("contact must be instance of ContactIrcImpl");
        }
        ContactIrcImpl ircContact = (ContactIrcImpl)contact;
        ContactGroupIrcImpl parentGroup = (ContactGroupIrcImpl)ircContact.getParentContactGroup();
        try {
            IrcConnection connection = ((ProtocolProviderServiceIrcImpl)this.parentProvider).getIrcStack().getConnection();
            if (connection != null) {
                connection.getPresenceManager().removeNickWatch(contact.getAddress());
            }
            parentGroup.removeContact(ircContact);
            this.fireSubscriptionEvent((Contact)ircContact, parentGroup, 2);
        }
        catch (RuntimeException e) {
            LOGGER.debug((Object)"Failed to unsubscribe from contact.", (Throwable)e);
            this.fireSubscriptionEvent((Contact)ircContact, parentGroup, 3);
        }
    }

    public void createServerStoredContactGroup(ContactGroup parent, String groupName) throws OperationFailedException {
        LOGGER.trace((Object)"createServerStoredContactGroup(...) called");
        if (!(parent instanceof ContactGroupIrcImpl)) {
            throw new IllegalArgumentException("parent is not an instance of ContactGroupIrcImpl");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("groupName cannot be null or empty");
        }
        ContactGroupIrcImpl parentGroup = (ContactGroupIrcImpl)parent;
        ContactGroupIrcImpl newGroup = new ContactGroupIrcImpl((ProtocolProviderServiceIrcImpl)this.parentProvider, parentGroup, groupName);
        parentGroup.addSubGroup(newGroup);
        this.fireServerStoredGroupEvent(newGroup, 1);
    }

    public void removeServerStoredContactGroup(ContactGroup group) throws OperationFailedException {
        LOGGER.trace((Object)"removeServerStoredContactGroup called");
        if (!(group instanceof ContactGroupIrcImpl)) {
            throw new IllegalArgumentException("group must be an instance of ContactGroupIrcImpl");
        }
        ContactGroupIrcImpl ircGroup = (ContactGroupIrcImpl)group;
        ((ContactGroupIrcImpl)ircGroup.getParentContactGroup()).removeSubGroup(ircGroup);
        this.fireServerStoredGroupEvent(ircGroup, 2);
    }

    public void renameServerStoredContactGroup(ContactGroup group, String newName) {
        LOGGER.trace((Object)"renameServerStoredContactGroup called");
        ((ContactGroupIrcImpl)group).setGroupName(newName);
    }

    public void moveContactToGroup(Contact contactToMove, ContactGroup newParent) throws OperationFailedException {
        LOGGER.trace((Object)"moveContactToGroup called");
        if (!(contactToMove instanceof ContactIrcImpl)) {
            throw new IllegalArgumentException("contactToMove must be an instance of ContactIrcImpl");
        }
        ContactIrcImpl contact = (ContactIrcImpl)contactToMove;
        ((ContactGroupIrcImpl)contact.getParentContactGroup()).removeContact(contact);
        ContactGroupIrcImpl newGroup = (ContactGroupIrcImpl)newParent;
        newGroup.addContact(contact);
        contact.setParentContactGroup(newGroup);
    }

    public ContactGroup getServerStoredContactListRoot() {
        return this.rootGroup;
    }

    public ContactIrcImpl createUnresolvedContact(String address, String persistentData) {
        return this.createUnresolvedContact(address, persistentData, this.rootGroup);
    }

    public ContactIrcImpl createUnresolvedContact(String address, String persistentData, ContactGroup parentGroup) {
        if (address == null || address.isEmpty()) {
            throw new IllegalArgumentException("address cannot be null or empty");
        }
        if (!(parentGroup instanceof ContactGroupIrcImpl)) {
            throw new IllegalArgumentException("Provided contact group is not an IRC contact group instance.");
        }
        ContactGroupIrcImpl group = (ContactGroupIrcImpl)parentGroup;
        ContactIrcImpl unresolvedContact = new ContactIrcImpl((ProtocolProviderServiceIrcImpl)this.parentProvider, address, (ContactGroupIrcImpl)parentGroup, IrcStatusEnum.OFFLINE);
        group.addContact(unresolvedContact);
        ((ProtocolProviderServiceIrcImpl)this.parentProvider).getIrcStack().getContext().nickWatchList.add(address);
        return unresolvedContact;
    }

    public ContactGroupIrcImpl createUnresolvedContactGroup(String groupUID, String persistentData, ContactGroup parentGroup) {
        if (!(parentGroup instanceof ContactGroupIrcImpl)) {
            throw new IllegalArgumentException("parentGroup is not a ContactGroupIrcImpl instance");
        }
        ContactGroupIrcImpl unresolvedGroup = new ContactGroupIrcImpl((ProtocolProviderServiceIrcImpl)this.parentProvider, (ContactGroupIrcImpl)parentGroup, groupUID);
        ((ContactGroupIrcImpl)parentGroup).addSubGroup(unresolvedGroup);
        return unresolvedGroup;
    }

    public PresenceStatus getPresenceStatus() {
        IrcConnection connection = ((ProtocolProviderServiceIrcImpl)this.parentProvider).getIrcStack().getConnection();
        if (connection != null && connection.isConnected()) {
            return connection.getPresenceManager().isAway() ? IrcStatusEnum.AWAY : IrcStatusEnum.ONLINE;
        }
        return IrcStatusEnum.OFFLINE;
    }

    public void publishPresenceStatus(PresenceStatus status, String statusMessage) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        IrcConnection connection = ((ProtocolProviderServiceIrcImpl)this.parentProvider).getIrcStack().getConnection();
        String message = statusMessage;
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        if (message != null && message.isEmpty()) {
            message = null;
        }
        if (status.getStatus() >= 50) {
            connection.getPresenceManager().away(false, message);
        } else if (status.getStatus() >= 36) {
            connection.getPresenceManager().away(true, message);
        }
    }

    void updatePresenceStatus(PresenceStatus previousStatus, PresenceStatus status) {
        this.fireProviderStatusChangeEvent(previousStatus, status);
    }

    public Iterator<PresenceStatus> getSupportedStatusSet() {
        HashSet<IrcStatusEnum> statuses = new HashSet<IrcStatusEnum>();
        Iterator<IrcStatusEnum> supported = IrcStatusEnum.supportedStatusSet();
        while (supported.hasNext()) {
            statuses.add(supported.next());
        }
        return statuses.iterator();
    }

    public PresenceStatus queryContactStatus(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        IrcConnection connection = ((ProtocolProviderServiceIrcImpl)this.parentProvider).getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("not connected");
        }
        try {
            return connection.getPresenceManager().query(contactIdentifier);
        }
        catch (IOException e) {
            throw new OperationFailedException("Presence query failed.", 2, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new OperationFailedException("Presence query interrupted.", 1, (Throwable)e);
        }
    }

    public ContactIrcImpl findContactByID(String contactID) {
        return this.rootGroup.findContact(contactID);
    }

    public void setAuthorizationHandler(AuthorizationHandler handler) {
    }

    public String getCurrentStatusMessage() {
        IrcConnection connection = ((ProtocolProviderServiceIrcImpl)this.parentProvider).getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        return connection.getPresenceManager().isAway() ? connection.getPresenceManager().getMessage() : "";
    }

    Contact findOrCreateContactByID(String id) {
        ContactIrcImpl contact = this.findContactByID(id);
        if (contact == null) {
            contact = this.createVolatileContact(id);
            LOGGER.debug((Object)("No existing contact found. Created volatile contact for nick name '" + id + "'."));
        }
        return contact;
    }

    void updateNickContactPresence(String nick, PresenceStatus newStatus) {
        LOGGER.trace((Object)("Received presence update for nick '" + nick + "', status: " + newStatus.getStatus()));
        ContactIrcImpl contact = this.findContactByID(nick);
        if (contact == null) {
            LOGGER.trace((Object)"null contact instance found: presence will not be processed.");
            return;
        }
        if (!(contact instanceof ContactIrcImpl)) {
            throw new IllegalArgumentException("Expected contact to be an IRC contact instance.");
        }
        ContactIrcImpl contactIrc = contact;
        ContactGroup group = contact.getParentContactGroup();
        PresenceStatus previous = contactIrc.getPresenceStatus();
        contactIrc.setPresenceStatus(newStatus);
        this.fireContactPresenceStatusChangeEvent((Contact)contact, group, previous);
    }

    void updateNick(String oldNick, String newNick) {
        ContactIrcImpl contact = this.findContactByID(oldNick);
        if (contact == null) {
            return;
        }
        contact.setAddress(newNick);
        this.fireContactPropertyChangeEvent("DisplayName", (Contact)contact, oldNick, newNick);
    }
}

