/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats;

import com.google.common.collect.Maps;
import com.google.gdata.model.Attribute;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.QName;
import com.google.gdata.util.common.xml.XmlNamespace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GeneratorUtils {
    public static Map<String, XmlNamespace> calculateNamespaces(Element root, ElementMetadata<?, ?> metadata) {
        HashMap namespaceMap = Maps.newHashMap();
        GeneratorUtils.calculateNamespaces(namespaceMap, root, metadata);
        return namespaceMap;
    }

    private static void calculateNamespaces(Map<String, XmlNamespace> namespaces, Element e, ElementMetadata<?, ?> metadata) {
        QName name = metadata == null ? e.getElementId() : metadata.getName();
        GeneratorUtils.addNamespace(namespaces, name);
        Iterator<Attribute> attIter = e.getAttributeIterator(metadata);
        while (attIter.hasNext()) {
            Attribute att = attIter.next();
            AttributeKey<?> attKey = att.getAttributeKey();
            AttributeMetadata<?> attMeta = metadata == null ? null : metadata.bindAttribute(attKey);
            name = attMeta == null ? attKey.getId() : attMeta.getName();
            GeneratorUtils.addNamespace(namespaces, name);
        }
        Iterator<Element> childIter = e.getElementIterator(metadata);
        while (childIter.hasNext()) {
            Element child = childIter.next();
            ElementMetadata<?, ?> childMeta = metadata == null ? null : metadata.bindElement(child.getElementKey());
            GeneratorUtils.calculateNamespaces(namespaces, child, childMeta);
        }
    }

    private static void addNamespace(Map<String, XmlNamespace> namespaces, QName name) {
        if (name == null) {
            return;
        }
        XmlNamespace ns = name.getNs();
        if (ns == null) {
            return;
        }
        String alias = ns.getAlias();
        if (alias == null) {
            return;
        }
        String uri = ns.getUri();
        if (namespaces.containsKey(uri)) {
            return;
        }
        namespaces.put(uri, ns);
    }
}

